/* Implementation of the MALLOC and FREE intrinsics
   Copyright (C) 2005-2015 Free Software Foundation, Inc.
   Contributed by François-Xavier Coudert <coudert@clipper.ens.fr>

This file is part of the GNU Fortran runtime library (libgfortran).

Libgfortran is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 3 of the License, or (at your option) any later version.

Libgfortran is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "libgfortran.h"
#include <stdlib.h>


/* The runtime MALLOC and FREE are kept here until the libgfortran ABI
   is broken.  The front-end now emits direct calls to the GCC's malloc()
   and free() built-ins.  */

extern void PREFIX(free) (void **);
export_proto_np(PREFIX(free));

void
PREFIX(free) (void ** ptr)
{
  free (*ptr);
}


extern void * PREFIX(malloc) (size_t *);
export_proto_np(PREFIX(malloc));

void *
PREFIX(malloc) (size_t * size)
{
  return malloc (*size);
}
