/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2015 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-dis.h"

/* Called by aarch64_opcode_lookup.  */

static int
aarch64_opcode_lookup_1 (uint32_t word)
{
  if (((word >> 26) & 0x1) == 0)
    {
      if (((word >> 25) & 0x1) == 0)
        {
          if (((word >> 27) & 0x1) == 0)
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 31) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0000xxx0
                         adr.  */
                      return 1007;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0000xxx1
                         adrp.  */
                      return 1008;
                    }
                }
              else
                {
                  if (((word >> 29) & 0x1) == 0)
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x00x
                             add.  */
                          return 12;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x01x
                             sub.  */
                          return 16;
                        }
                    }
                  else
                    {
                      if (((word >> 30) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x10x
                             adds.  */
                          return 14;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx1000x11x
                             subs.  */
                          return 17;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 28) & 0x1) == 0)
                {
                  if (((word >> 22) & 0x1) == 0)
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx000x0010000
                                                 stxrb.  */
                                              return 765;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx000x0010010
                                                 stxrh.  */
                                              return 771;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx000x00100x1
                                             stxr.  */
                                          return 777;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx100x00100x0
                                             casp.  */
                                          return 842;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx100x00100x1
                                             stxp.  */
                                          return 779;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx000x0010000
                                                 stlxrb.  */
                                              return 766;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx000x0010010
                                                 stlxrh.  */
                                              return 772;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx000x00100x1
                                             stlxr.  */
                                          return 778;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx100x00100x0
                                             caspl.  */
                                          return 844;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx100x00100x1
                                             stlxp.  */
                                          return 780;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx00x00101xx
                                 stnp.  */
                              return 793;
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx001x00100x0
                                             stllrb.  */
                                          return 791;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx001x00100x1
                                             stllr.  */
                                          return 790;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx101x0010000
                                                 casb.  */
                                              return 830;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx101x0010010
                                                 cash.  */
                                              return 831;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx101x00100x1
                                             cas.  */
                                          return 832;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx001x0010000
                                                 stlrb.  */
                                              return 769;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx001x0010010
                                                 stlrh.  */
                                              return 775;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx001x00100x1
                                             stlr.  */
                                          return 785;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx101x0010000
                                                 caslb.  */
                                              return 834;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx101x0010010
                                                 caslh.  */
                                              return 837;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx101x00100x1
                                             casl.  */
                                          return 840;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx01x00101xx
                                 stp.  */
                              return 802;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx010x0010000
                                                 ldxrb.  */
                                              return 767;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx010x0010010
                                                 ldxrh.  */
                                              return 773;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx010x00100x1
                                             ldxr.  */
                                          return 781;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx110x00100x0
                                             caspa.  */
                                          return 843;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx110x00100x1
                                             ldxp.  */
                                          return 783;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx010x0010000
                                                 ldaxrb.  */
                                              return 768;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx010x0010010
                                                 ldaxrh.  */
                                              return 774;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx010x00100x1
                                             ldaxr.  */
                                          return 782;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx110x00100x0
                                             caspal.  */
                                          return 845;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx110x00100x1
                                             ldaxp.  */
                                          return 784;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10x001010x
                                     ldnp.  */
                                  return 794;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10x001011x
                                     ldpsw.  */
                                  return 801;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx011x0010000
                                                 ldlarb.  */
                                              return 788;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx011x0010010
                                                 ldlarh.  */
                                              return 789;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx011x00100x1
                                             ldlar.  */
                                          return 787;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx111x0010000
                                                 casab.  */
                                              return 833;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx0xxxxx111x0010010
                                                 casah.  */
                                              return 836;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx0xxxxx111x00100x1
                                             casa.  */
                                          return 839;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx011x0010000
                                                 ldarb.  */
                                              return 770;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx011x0010010
                                                 ldarh.  */
                                              return 776;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx011x00100x1
                                             ldar.  */
                                          return 786;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx111x0010000
                                                 casalb.  */
                                              return 835;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxxxxxxx1xxxxx111x0010010
                                                 casalh.  */
                                              return 838;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxx1xxxxx111x00100x1
                                             casal.  */
                                          return 841;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx11x001010x
                                     ldp.  */
                                  return 803;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx11x001011x
                                     ldpsw.  */
                                  return 806;
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxxx000110x0
                                 ldr.  */
                              return 807;
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxxx00011001
                                     ldrsw.  */
                                  return 809;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxxx00011011
                                     prfm.  */
                                  return 810;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00xxxxxxxxx00000011100
                                                         sturb.  */
                                                      return 753;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00xxxxxxxxx00000011110
                                                         sturh.  */
                                                      return 758;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx000000111x1
                                                     stur.  */
                                                  return 761;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00xxxxxxxxx01000011100
                                                         ldurb.  */
                                                      return 754;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00xxxxxxxxx01000011110
                                                         ldurh.  */
                                                      return 759;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx010000111x1
                                                     ldur.  */
                                                  return 762;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0x100011100
                                                     ldursb.  */
                                                  return 755;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0x100011101
                                                     ldursw.  */
                                                  return 763;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0x100011110
                                                     ldursh.  */
                                                  return 760;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0x100011111
                                                     prfum.  */
                                                  return 764;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx10000011100
                                                                         ldaddb.  */
                                                                      return 858;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx10000011110
                                                                         ldaddh.  */
                                                                      return 859;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000000xxxxx100000111x1
                                                                     ldadd.  */
                                                                  return 860;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx10100011100
                                                                         ldaddab.  */
                                                                      return 861;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx10100011110
                                                                         ldaddah.  */
                                                                      return 864;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000000xxxxx101000111x1
                                                                     ldadda.  */
                                                                  return 867;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx11000011100
                                                                         ldaddlb.  */
                                                                      return 862;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx11000011110
                                                                         ldaddlh.  */
                                                                      return 865;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000000xxxxx110000111x1
                                                                     ldaddl.  */
                                                                  return 868;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx11100011100
                                                                         ldaddalb.  */
                                                                      return 863;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000xxxxx11100011110
                                                                         ldaddalh.  */
                                                                      return 866;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000000xxxxx111000111x1
                                                                     ldaddal.  */
                                                                  return 869;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 22) & 0x1) == 0)
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx10000011100
                                                                         swpb.  */
                                                                      return 846;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx10000011110
                                                                         swph.  */
                                                                      return 847;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000001xxxxx100000111x1
                                                                     swp.  */
                                                                  return 848;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx10100011100
                                                                         swpab.  */
                                                                      return 849;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx10100011110
                                                                         swpah.  */
                                                                      return 852;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000001xxxxx101000111x1
                                                                     swpa.  */
                                                                  return 855;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 23) & 0x1) == 0)
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx11000011100
                                                                         swplb.  */
                                                                      return 850;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx11000011110
                                                                         swplh.  */
                                                                      return 853;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000001xxxxx110000111x1
                                                                     swpl.  */
                                                                  return 856;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 31) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 30) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx11100011100
                                                                         swpalb.  */
                                                                      return 851;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000001xxxxx11100011110
                                                                         swpalh.  */
                                                                      return 854;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx000001xxxxx111000111x1
                                                                     swpal.  */
                                                                  return 857;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx10000011100
                                                                     ldsmaxb.  */
                                                                  return 906;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx10000011110
                                                                     ldsmaxh.  */
                                                                  return 907;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00001xxxxxx100000111x1
                                                                 ldsmax.  */
                                                              return 908;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx10100011100
                                                                     ldsmaxab.  */
                                                                  return 909;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx10100011110
                                                                     ldsmaxah.  */
                                                                  return 912;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00001xxxxxx101000111x1
                                                                 ldsmaxa.  */
                                                              return 915;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx11000011100
                                                                     ldsmaxlb.  */
                                                                  return 910;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx11000011110
                                                                     ldsmaxlh.  */
                                                                  return 913;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00001xxxxxx110000111x1
                                                                 ldsmaxl.  */
                                                              return 916;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx11100011100
                                                                     ldsmaxalb.  */
                                                                  return 911;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00001xxxxxx11100011110
                                                                     ldsmaxalh.  */
                                                                  return 914;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00001xxxxxx111000111x1
                                                                 ldsmaxal.  */
                                                              return 917;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx10000011100
                                                                     ldeorb.  */
                                                                  return 882;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx10000011110
                                                                     ldeorh.  */
                                                                  return 883;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00010xxxxxx100000111x1
                                                                 ldeor.  */
                                                              return 884;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx10100011100
                                                                     ldeorab.  */
                                                                  return 885;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx10100011110
                                                                     ldeorah.  */
                                                                  return 888;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00010xxxxxx101000111x1
                                                                 ldeora.  */
                                                              return 891;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx11000011100
                                                                     ldeorlb.  */
                                                                  return 886;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx11000011110
                                                                     ldeorlh.  */
                                                                  return 889;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00010xxxxxx110000111x1
                                                                 ldeorl.  */
                                                              return 892;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx11100011100
                                                                     ldeoralb.  */
                                                                  return 887;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00010xxxxxx11100011110
                                                                     ldeoralh.  */
                                                                  return 890;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00010xxxxxx111000111x1
                                                                 ldeoral.  */
                                                              return 893;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx10000011100
                                                                     ldumaxb.  */
                                                                  return 930;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx10000011110
                                                                     ldumaxh.  */
                                                                  return 931;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00011xxxxxx100000111x1
                                                                 ldumax.  */
                                                              return 932;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx10100011100
                                                                     ldumaxab.  */
                                                                  return 933;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx10100011110
                                                                     ldumaxah.  */
                                                                  return 936;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00011xxxxxx101000111x1
                                                                 ldumaxa.  */
                                                              return 939;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx11000011100
                                                                     ldumaxlb.  */
                                                                  return 934;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx11000011110
                                                                     ldumaxlh.  */
                                                                  return 937;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00011xxxxxx110000111x1
                                                                 ldumaxl.  */
                                                              return 940;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx11100011100
                                                                     ldumaxalb.  */
                                                                  return 935;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00011xxxxxx11100011110
                                                                     ldumaxalh.  */
                                                                  return 938;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00011xxxxxx111000111x1
                                                                 ldumaxal.  */
                                                              return 941;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx10000011100
                                                                     ldclrb.  */
                                                                  return 870;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx10000011110
                                                                     ldclrh.  */
                                                                  return 871;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00100xxxxxx100000111x1
                                                                 ldclr.  */
                                                              return 872;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx10100011100
                                                                     ldclrab.  */
                                                                  return 873;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx10100011110
                                                                     ldclrah.  */
                                                                  return 876;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00100xxxxxx101000111x1
                                                                 ldclra.  */
                                                              return 879;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx11000011100
                                                                     ldclrlb.  */
                                                                  return 874;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx11000011110
                                                                     ldclrlh.  */
                                                                  return 877;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00100xxxxxx110000111x1
                                                                 ldclrl.  */
                                                              return 880;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx11100011100
                                                                     ldclralb.  */
                                                                  return 875;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00100xxxxxx11100011110
                                                                     ldclralh.  */
                                                                  return 878;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00100xxxxxx111000111x1
                                                                 ldclral.  */
                                                              return 881;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx10000011100
                                                                     ldsminb.  */
                                                                  return 918;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx10000011110
                                                                     ldsminh.  */
                                                                  return 919;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00101xxxxxx100000111x1
                                                                 ldsmin.  */
                                                              return 920;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx10100011100
                                                                     ldsminab.  */
                                                                  return 921;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx10100011110
                                                                     ldsminah.  */
                                                                  return 924;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00101xxxxxx101000111x1
                                                                 ldsmina.  */
                                                              return 927;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx11000011100
                                                                     ldsminlb.  */
                                                                  return 922;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx11000011110
                                                                     ldsminlh.  */
                                                                  return 925;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00101xxxxxx110000111x1
                                                                 ldsminl.  */
                                                              return 928;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx11100011100
                                                                     ldsminalb.  */
                                                                  return 923;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00101xxxxxx11100011110
                                                                     ldsminalh.  */
                                                                  return 926;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00101xxxxxx111000111x1
                                                                 ldsminal.  */
                                                              return 929;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx10000011100
                                                                     ldsetb.  */
                                                                  return 894;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx10000011110
                                                                     ldseth.  */
                                                                  return 895;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00110xxxxxx100000111x1
                                                                 ldset.  */
                                                              return 896;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx10100011100
                                                                     ldsetab.  */
                                                                  return 897;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx10100011110
                                                                     ldsetah.  */
                                                                  return 900;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00110xxxxxx101000111x1
                                                                 ldseta.  */
                                                              return 903;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx11000011100
                                                                     ldsetlb.  */
                                                                  return 898;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx11000011110
                                                                     ldsetlh.  */
                                                                  return 901;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00110xxxxxx110000111x1
                                                                 ldsetl.  */
                                                              return 904;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx11100011100
                                                                     ldsetalb.  */
                                                                  return 899;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00110xxxxxx11100011110
                                                                     ldsetalh.  */
                                                                  return 902;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00110xxxxxx111000111x1
                                                                 ldsetal.  */
                                                              return 905;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx10000011100
                                                                     lduminb.  */
                                                                  return 942;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx10000011110
                                                                     lduminh.  */
                                                                  return 943;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00111xxxxxx100000111x1
                                                                 ldumin.  */
                                                              return 944;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx10100011100
                                                                     lduminab.  */
                                                                  return 945;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx10100011110
                                                                     lduminah.  */
                                                                  return 948;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00111xxxxxx101000111x1
                                                                 ldumina.  */
                                                              return 951;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx11000011100
                                                                     lduminlb.  */
                                                                  return 946;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx11000011110
                                                                     lduminlh.  */
                                                                  return 949;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00111xxxxxx110000111x1
                                                                 lduminl.  */
                                                              return 952;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 31) & 0x1) == 0)
                                                            {
                                                              if (((word >> 30) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx11100011100
                                                                     lduminalb.  */
                                                                  return 947;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx00111xxxxxx11100011110
                                                                     lduminalh.  */
                                                                  return 950;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx00111xxxxxx111000111x1
                                                                 lduminal.  */
                                                              return 953;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx00000011100
                                                         sttrb.  */
                                                      return 744;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx00000011110
                                                         sttrh.  */
                                                      return 747;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx000000111x1
                                                     sttr.  */
                                                  return 750;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx01000011100
                                                         ldtrb.  */
                                                      return 745;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx01000011110
                                                         ldtrh.  */
                                                      return 748;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx010000111x1
                                                     ldtr.  */
                                                  return 751;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx0x100011100
                                                     ldtrsb.  */
                                                  return 746;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx0x100011101
                                                     ldtrsw.  */
                                                  return 752;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx01xxxxxxxxx0x10001111x
                                                 ldtrsh.  */
                                              return 749;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 22) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx10000011100
                                                         strb.  */
                                                      return 732;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx10000011110
                                                         strh.  */
                                                      return 737;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx100000111x1
                                                     str.  */
                                                  return 740;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx11000011100
                                                         ldrb.  */
                                                      return 733;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01xxxxxxxxx11000011110
                                                         ldrh.  */
                                                      return 738;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx110000111x1
                                                     ldr.  */
                                                  return 741;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011100
                                                     ldrsb.  */
                                                  return 734;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011101
                                                     ldrsw.  */
                                                  return 742;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 31) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011110
                                                     ldrsh.  */
                                                  return 739;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01xxxxxxxxx1x100011111
                                                     prfm.  */
                                                  return 743;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 23) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx0000011100
                                                 strb.  */
                                              return 709;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx0000011110
                                                 strh.  */
                                              return 714;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxx00000111x1
                                             str.  */
                                          return 717;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx1000011100
                                                 ldrb.  */
                                              return 710;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1xxxxxxxxxxx1000011110
                                                 ldrh.  */
                                              return 715;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxx10000111x1
                                             ldr.  */
                                          return 718;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      if (((word >> 31) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxxx100011100
                                             ldrsb.  */
                                          return 711;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1xxxxxxxxxxxx100011101
                                             ldrsw.  */
                                          return 719;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1xxxxxxxxxxxx10001111x
                                         ldrsh.  */
                                      return 716;
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 22) & 0x1) == 0)
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx0010011x00
                                         strb.  */
                                      return 720;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx0010011x10
                                         strh.  */
                                      return 725;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx0010011xx1
                                     str.  */
                                  return 728;
                                }
                            }
                          else
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx1010011x00
                                         ldrb.  */
                                      return 721;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxxx1010011x10
                                         ldrh.  */
                                      return 726;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx1010011xx1
                                     ldr.  */
                                  return 729;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x00
                                     ldrsb.  */
                                  return 722;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x01
                                     ldrsw.  */
                                  return 730;
                                }
                            }
                          else
                            {
                              if (((word >> 31) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x10
                                     ldrsh.  */
                                  return 727;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxxx110011x11
                                     prfm.  */
                                  return 731;
                                }
                            }
                        }
                    }
                }
            }
        }
      else
        {
          if (((word >> 24) & 0x1) == 0)
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x00x
                                 and.  */
                              return 811;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x01x
                                 eor.  */
                              return 815;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x10x
                                 orr.  */
                              return 813;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx00100x11x
                                 ands.  */
                              return 816;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx10100x00x
                                 movn.  */
                              return 1002;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx10100x01x
                                 movz.  */
                              return 1004;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxx10100x1xx
                             movk.  */
                          return 1006;
                        }
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101000x
                                     and.  */
                                  return 818;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101001x
                                     eor.  */
                                  return 825;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101010x
                                     orr.  */
                                  return 820;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx0101011x
                                     ands.  */
                                  return 827;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101100x
                                                     adc.  */
                                                  return 0;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101101x
                                                     sbc.  */
                                                  return 2;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101110x
                                                     adcs.  */
                                                  return 1;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00xxxxxxxxx0000101111x
                                                     sbcs.  */
                                                  return 4;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx00101011x0x
                                                 csel.  */
                                              return 533;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx00101011x1x
                                                 csinv.  */
                                              return 537;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 23) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx01001011x0x
                                                 ccmn.  */
                                              return 531;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx00xxxxxxxxx01001011x1x
                                                 ccmp.  */
                                              return 532;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00000xxxxxx01101011xxx
                                                         rbit.  */
                                                      return 556;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00001xxxxxx01101011xxx
                                                         crc32b.  */
                                                      return 574;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0001xxxxxxx01101011xxx
                                                     lslv.  */
                                                  return 566;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx001x0xxxxxx01101011xxx
                                                     clz.  */
                                                  return 561;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx001x1xxxxxx01101011xxx
                                                     crc32cb.  */
                                                  return 578;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx01xxxxxxxxx0x001011x0x
                                             ccmn.  */
                                          return 529;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx01xxxxxxxxx0x001011x1x
                                             ccmp.  */
                                          return 530;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx01000xxxxxx0x101011x0x
                                                         udiv.  */
                                                      return 564;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 31) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx01000xxxxxx0x101011x10
                                                             rev.  */
                                                          return 558;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx01000xxxxxx0x101011x11
                                                             rev32.  */
                                                          return 563;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01001xxxxxx0x101011xxx
                                                     crc32w.  */
                                                  return 576;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0101xxxxxxx0x101011xxx
                                                 asrv.  */
                                              return 570;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx011xxxxxxxx0x101011xxx
                                             crc32cw.  */
                                          return 580;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx10xxxxxxxxx00x01011x0x
                                             csinc.  */
                                          return 534;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx10xxxxxxxxx00x01011x1x
                                             csneg.  */
                                          return 540;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10000xxxxxx01x01011xxx
                                                     rev16.  */
                                                  return 557;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10001xxxxxx01x01011xxx
                                                     crc32h.  */
                                                  return 575;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1001xxxxxxx01x01011xxx
                                                 lsrv.  */
                                              return 568;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x0xxxxxx01x01011xxx
                                                 cls.  */
                                              return 562;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x1xxxxxx01x01011xxx
                                                 crc32ch.  */
                                              return 579;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11000xxxxxx0xx01011x0x
                                                     sdiv.  */
                                                  return 565;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11000xxxxxx0xx01011x1x
                                                     rev.  */
                                                  return 559;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11001xxxxxx0xx01011xxx
                                                 crc32x.  */
                                              return 577;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx1101xxxxxxx0xx01011xxx
                                             rorv.  */
                                          return 572;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx111xxxxxxxx0xx01011xxx
                                         crc32cx.  */
                                      return 581;
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x00x
                                 bic.  */
                              return 819;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x01x
                                 eon.  */
                              return 826;
                            }
                        }
                      else
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x10x
                                 orn.  */
                              return 823;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxx1xx0101x11x
                                 bics.  */
                              return 829;
                            }
                        }
                    }
                }
            }
          else
            {
              if (((word >> 27) & 0x1) == 0)
                {
                  if (((word >> 23) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          if (((word >> 30) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx01100x00x
                                 sbfm.  */
                              return 501;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxx01100x01x
                                 ubfm.  */
                              return 512;
                            }
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxx01100x1xx
                             bfm.  */
                          return 508;
                        }
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxx11100xxxx
                         extr.  */
                      return 604;
                    }
                }
              else
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101000x
                                     add.  */
                                  return 19;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101001x
                                     sub.  */
                                  return 22;
                                }
                            }
                          else
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101010x
                                     adds.  */
                                  return 20;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx0xx1101011x
                                     subs.  */
                                  return 24;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxx0xxxxx00x11011xxx
                                     madd.  */
                                  return 582;
                                }
                              else
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx01011011xxx
                                         smulh.  */
                                      return 590;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx01111011xxx
                                         umulh.  */
                                      return 595;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxx1xxxxx0xx11011xxx
                                 msub.  */
                              return 584;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 28) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101000x
                                         add.  */
                                      return 6;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101001x
                                         sub.  */
                                      return 9;
                                    }
                                }
                              else
                                {
                                  if (((word >> 30) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101010x
                                         adds.  */
                                      return 7;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx1x01101011x
                                         subs.  */
                                      return 10;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxx0xxxxx1x011011xxx
                                     smaddl.  */
                                  return 586;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxx1xxxxx1x011011xxx
                                     smsubl.  */
                                  return 588;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 15) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxx0xxxxx1x11101xxxx
                                 umaddl.  */
                              return 591;
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxx1xxxxx1x11101xxxx
                                 umsubl.  */
                              return 593;
                            }
                        }
                    }
                }
            }
        }
    }
  else
    {
      if (((word >> 27) & 0x1) == 0)
        {
          if (((word >> 29) & 0x1) == 0)
            {
              if (((word >> 30) & 0x1) == 0)
                {
                  if (((word >> 31) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxxxx10x000
                         b.  */
                      return 519;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxxxx10x001
                         bl.  */
                      return 520;
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 25) & 0x1) == 0)
                        {
                          if (((word >> 31) & 0x1) == 0)
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxxxx0010x010
                                 b.c.  */
                              return 528;
                            }
                          else
                            {
                              if (((word >> 0) & 0x1) == 0)
                                {
                                  if (((word >> 1) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             00xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             hlt.  */
                                          return 600;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             00xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             brk.  */
                                          return 599;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             01xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             hvc.  */
                                          return 597;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             01xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             dcps2.  */
                                          return 602;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 1) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             10xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             svc.  */
                                          return 596;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             10xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             dcps1.  */
                                          return 601;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             11xxxxxxxxxxxxxxxxxxx0xx0010x011
                                             smc.  */
                                          return 598;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             11xxxxxxxxxxxxxxxxxxx1xx0010x011
                                             dcps3.  */
                                          return 603;
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 21) & 0x1) == 0)
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  if (((word >> 23) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx0000110x01x
                                         br.  */
                                      return 521;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx0010110x01x
                                         eret.  */
                                      return 524;
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx01x0110x01x
                                     ret.  */
                                  return 523;
                                }
                            }
                          else
                            {
                              if (((word >> 23) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx1x00110x01x
                                     blr.  */
                                  return 522;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxx1x10110x01x
                                     drps.  */
                                  return 525;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 21) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxx0xx1x10x01x
                             msr.  */
                          return 1009;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxx1xx1x10x01x
                             sysl.  */
                          return 1027;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 25) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0010x1xx
                         cbz.  */
                      return 526;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx0110x1xx
                         tbz.  */
                      return 1029;
                    }
                }
              else
                {
                  if (((word >> 25) & 0x1) == 0)
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx1010x1xx
                         cbnz.  */
                      return 527;
                    }
                  else
                    {
                      /* 33222222222211111111110000000000
                         10987654321098765432109876543210
                         xxxxxxxxxxxxxxxxxxxxxxxx1110x1xx
                         tbnz.  */
                      return 1030;
                    }
                }
            }
        }
      else
        {
          if (((word >> 25) & 0x1) == 0)
            {
              if (((word >> 28) & 0x1) == 0)
                {
                  if (((word >> 22) & 0x1) == 0)
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 24) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx00001100xx
                                     st4.  */
                                  return 361;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx00001101xx
                                     stnp.  */
                                  return 795;
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx000101100xx
                                             st1.  */
                                          return 377;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx100101100xx
                                             st2.  */
                                          return 379;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx000101100xx
                                             st3.  */
                                          return 378;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx100101100xx
                                             st4.  */
                                          return 380;
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx00101101xx
                                     stp.  */
                                  return 799;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 24) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx001001100xx
                                         st4.  */
                                      return 369;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx001101100xx
                                             st1.  */
                                          return 389;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx001101100xx
                                             st3.  */
                                          return 390;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx0xxxxxxx101x01100xx
                                         st2.  */
                                      return 391;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx1xxxxxxx101x01100xx
                                         st4.  */
                                      return 392;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx01x01101xx
                                 stp.  */
                              return 804;
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 23) & 0x1) == 0)
                        {
                          if (((word >> 24) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10001100xx
                                     ld4.  */
                                  return 365;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10001101xx
                                     ldnp.  */
                                  return 796;
                                }
                            }
                          else
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx010101100xx
                                             ld1.  */
                                          return 381;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx110101100xx
                                             ld2.  */
                                          return 385;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 21) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx010101100xx
                                             ld3.  */
                                          return 382;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx110101100xx
                                             ld4.  */
                                          return 386;
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxxxxxxxxxxxxx10101101xx
                                     ldp.  */
                                  return 800;
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 21) & 0x1) == 0)
                                {
                                  if (((word >> 24) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxxxxxxxx011001100xx
                                         ld4.  */
                                      return 373;
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx0xxxxxxx011101100xx
                                             ld1.  */
                                          return 393;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxx1xxxxxxx011101100xx
                                             ld3.  */
                                          return 394;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx0xxxxxxx111x01100xx
                                         ld2.  */
                                      return 397;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxx1xxxxxxx111x01100xx
                                         ld4.  */
                                      return 398;
                                    }
                                }
                            }
                          else
                            {
                              /* 33222222222211111111110000000000
                                 10987654321098765432109876543210
                                 xxxxxxxxxxxxxxxxxxxxxx11x01101xx
                                 ldp.  */
                              return 805;
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 24) & 0x1) == 0)
                    {
                      if (((word >> 29) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxxxx001110xx
                             ldr.  */
                          return 808;
                        }
                      else
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx00xxxxxxxxxx0x001111xx
                                         stur.  */
                                      return 756;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx00xxxxxxxxxx1x001111xx
                                         ldur.  */
                                      return 757;
                                    }
                                }
                              else
                                {
                                  if (((word >> 22) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx01xxxxxxxxxx0x001111xx
                                         str.  */
                                      return 735;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx01xxxxxxxxxx1x001111xx
                                         ldr.  */
                                      return 736;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 22) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx1xxxxxxxxxxx0x001111xx
                                     str.  */
                                  return 712;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx1xxxxxxxxxxx1x001111xx
                                     ldr.  */
                                  return 713;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 22) & 0x1) == 0)
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxx0x10111xxx
                             str.  */
                          return 723;
                        }
                      else
                        {
                          /* 33222222222211111111110000000000
                             10987654321098765432109876543210
                             xxxxxxxxxxxxxxxxxxxxxx1x10111xxx
                             ldr.  */
                          return 724;
                        }
                    }
                }
            }
          else
            {
              if (((word >> 24) & 0x1) == 0)
                {
                  if (((word >> 21) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 29) & 0x1) == 0)
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx000xxxxxxxx0xx011100xx
                                             tbl.  */
                                          return 345;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx001xxxxxxxx0xx011100xx
                                             tbx.  */
                                          return 346;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx010x0xxxxxx0xx011100xx
                                                 trn1.  */
                                              return 218;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx010x1xxxxxx0xx011100xx
                                                 trn2.  */
                                              return 221;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01100xxxxxx0xx011100xx
                                                     uzp1.  */
                                                  return 217;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01101xxxxxx0xx011100xx
                                                     uzp2.  */
                                                  return 220;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01110xxxxxx0xx011100xx
                                                     zip1.  */
                                                  return 219;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx01111xxxxxx0xx011100xx
                                                     zip2.  */
                                                  return 222;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxx0xxxxxxxxxx0xx011101xx
                                     ext.  */
                                  return 121;
                                }
                            }
                          else
                            {
                              if (((word >> 15) & 0x1) == 0)
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx10xxx0xxxxx0xx011100xx
                                             dup.  */
                                          return 137;
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1100x0xxxxx0xx011100xx
                                                     dup.  */
                                                  return 138;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1101x0xxxxx0xx011100xx
                                                     smov.  */
                                                  return 139;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x0xxxxx0xx011100xx
                                                     ins.  */
                                                  return 142;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1111x0xxxxx0xx011100xx
                                                     umov.  */
                                                  return 140;
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1xxxx0xxxxx0xx011101xx
                                         ins.  */
                                      return 144;
                                    }
                                }
                              else
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx10xxx1xxxxx0xx01110xxx
                                         sqrdmlah.  */
                                      return 301;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx11xxx1xxxxx0xx01110xxx
                                         sqrdmlsh.  */
                                      return 302;
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 16) & 0x1) == 0)
                                    {
                                      if (((word >> 17) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxxx00xxx0xx0111100x
                                             fcvtzs.  */
                                          return 610;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxxx01xxx0xx0111100x
                                             scvtf.  */
                                          return 606;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 17) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxxx10xxx0xx0111100x
                                             fcvtzu.  */
                                          return 612;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxxxxxx11xxx0xx0111100x
                                             ucvtf.  */
                                          return 608;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x000xxxxxx0xx0111101x
                                                     sha1c.  */
                                                  return 549;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x001xxxxxx0xx0111101x
                                                     sha256h.  */
                                                  return 553;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x010xxxxxx0xx0111101x
                                                     sha1m.  */
                                                  return 551;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x011xxxxxx0xx0111101x
                                                     sha256su1.  */
                                                  return 555;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x100xxxxxx0xx0111101x
                                                     sha1p.  */
                                                  return 550;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x101xxxxxx0xx0111101x
                                                     sha256h2.  */
                                                  return 554;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x11xxxxxxx0xx0111101x
                                                 sha1su0.  */
                                              return 552;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1xxxxxxxxxx0xx0111101x
                                         dup.  */
                                      return 436;
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxx0xxxxxxxxx0xx011111xx
                                     sqrdmlah.  */
                                  return 475;
                                }
                              else
                                {
                                  /* 33222222222211111111110000000000
                                     10987654321098765432109876543210
                                     xxxxxxxxxxx1xxxxxxxxx0xx011111xx
                                     sqrdmlsh.  */
                                  return 476;
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 10) & 0x1) == 0)
                        {
                          if (((word >> 11) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111000x
                                                             saddl.  */
                                                          return 38;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111001x
                                                             saddl2.  */
                                                          return 39;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111010x
                                                             uaddl.  */
                                                          return 70;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000000xxxxx1xx0111011x
                                                             uaddl2.  */
                                                          return 71;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000001xx01111xxx
                                                                         fcvtns.  */
                                                                      return 614;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000011xx01111xxx
                                                                         fcvtms.  */
                                                                      return 634;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000101xx01111xxx
                                                                         fcvtps.  */
                                                                      return 630;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000000111xx01111xxx
                                                                         fcvtzs.  */
                                                                      return 638;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000001xx1xx01111xxx
                                                                 fcvtas.  */
                                                              return 622;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000010xx1xx01111xxx
                                                                 scvtf.  */
                                                              return 618;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000000110x1xx01111xxx
                                                                     fmov.  */
                                                                  return 626;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000000111x1xx01111xxx
                                                                     fmov.  */
                                                                  return 642;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 17) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100001xx01111xxx
                                                                         fcvtnu.  */
                                                                      return 616;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100011xx01111xxx
                                                                         fcvtmu.  */
                                                                      return 636;
                                                                    }
                                                                }
                                                              else
                                                                {
                                                                  if (((word >> 20) & 0x1) == 0)
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100101xx01111xxx
                                                                         fcvtpu.  */
                                                                      return 632;
                                                                    }
                                                                  else
                                                                    {
                                                                      /* 33222222222211111111110000000000
                                                                         10987654321098765432109876543210
                                                                         xxxxxxxxxx000000100111xx01111xxx
                                                                         fcvtzu.  */
                                                                      return 640;
                                                                    }
                                                                }
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000101xx1xx01111xxx
                                                                 fcvtau.  */
                                                              return 624;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000000110xx1xx01111xxx
                                                                 ucvtf.  */
                                                              return 620;
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 19) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000001110x1xx01111xxx
                                                                     fmov.  */
                                                                  return 628;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0000001111x1xx01111xxx
                                                                     fmov.  */
                                                                  return 643;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x00x
                                                         smlal.  */
                                                      return 54;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x01x
                                                         smlal2.  */
                                                      return 55;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x10x
                                                         umlal.  */
                                                      return 86;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000001xxxxx1xx0111x11x
                                                         umlal2.  */
                                                      return 87;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 28) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111000x
                                                             addhn.  */
                                                          return 46;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111001x
                                                             addhn2.  */
                                                          return 47;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111010x
                                                             raddhn.  */
                                                          return 78;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000010xxxxx1xx0111011x
                                                             raddhn2.  */
                                                          return 79;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111000x
                                                             smull.  */
                                                          return 62;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111001x
                                                             smull2.  */
                                                          return 63;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111010x
                                                             umull.  */
                                                          return 90;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011xxxxx1xx0111011x
                                                             umull2.  */
                                                          return 91;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 17) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010000xx1xx01111xxx
                                                                 fmov.  */
                                                              return 656;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010001xx1xx01111xxx
                                                                 frintn.  */
                                                              return 665;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010100xx1xx01111xxx
                                                                 fneg.  */
                                                              return 660;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010101xx1xx01111xxx
                                                                 frintm.  */
                                                              return 669;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 16) & 0x1) == 0)
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011000xx1xx01111xxx
                                                                 fabs.  */
                                                              return 658;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011001xx1xx01111xxx
                                                                 frintp.  */
                                                              return 667;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 18) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011100xx1xx01111xxx
                                                                 fsqrt.  */
                                                              return 662;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000011101xx1xx01111xxx
                                                                 frintz.  */
                                                              return 671;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 18) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00001xx10xx1xx01111xxx
                                                         fcvt.  */
                                                      return 664;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 15) & 0x1) == 0)
                                                        {
                                                          if (((word >> 16) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010011xx1xx01111xxx
                                                                 frinta.  */
                                                              return 673;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx000010111xx1xx01111xxx
                                                                 frintx.  */
                                                              return 675;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000011x11xx1xx01111xxx
                                                             frinti.  */
                                                          return 677;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111000x
                                                             ssubl.  */
                                                          return 42;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111001x
                                                             ssubl2.  */
                                                          return 43;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111010x
                                                             usubl.  */
                                                          return 74;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx000100xxxxx1xx0111011x
                                                             usubl2.  */
                                                          return 75;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 3) & 0x1) == 0)
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx00xxxxx000100xxxxx1xx01111xxx
                                                             fcmp.  */
                                                          return 648;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx01xxxxx000100xxxxx1xx01111xxx
                                                             fcmpe.  */
                                                          return 650;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 4) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx10xxxxx000100xxxxx1xx01111xxx
                                                             fcmp.  */
                                                          return 652;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxx11xxxxx000100xxxxx1xx01111xxx
                                                             fcmpe.  */
                                                          return 654;
                                                        }
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x00x
                                                         smlsl.  */
                                                      return 58;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x01x
                                                         smlsl2.  */
                                                      return 59;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x10x
                                                         umlsl.  */
                                                      return 88;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000101xxxxx1xx0111x11x
                                                         umlsl2.  */
                                                      return 89;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x00x
                                                         subhn.  */
                                                      return 50;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x01x
                                                         subhn2.  */
                                                      return 51;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x10x
                                                         rsubhn.  */
                                                      return 82;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000110xxxxx1xx0111x11x
                                                         rsubhn2.  */
                                                      return 83;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 22) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx10x0111xx0x
                                                         pmull.  */
                                                      return 66;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx10x0111xx1x
                                                         pmull2.  */
                                                      return 68;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx11x0111xx0x
                                                         pmull.  */
                                                      return 67;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx000111xxxxx11x0111xx1x
                                                         pmull2.  */
                                                      return 69;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 28) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111000x
                                                             saddw.  */
                                                          return 40;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111001x
                                                             saddw2.  */
                                                          return 41;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111010x
                                                             uaddw.  */
                                                          return 72;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001000xxxxx1xx0111011x
                                                             uaddw2.  */
                                                          return 73;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001001xxxxx1xx01110x0x
                                                         sqdmlal.  */
                                                      return 56;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001001xxxxx1xx01110x1x
                                                         sqdmlal2.  */
                                                      return 57;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111000x
                                                             sabal.  */
                                                          return 48;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111001x
                                                             sabal2.  */
                                                          return 49;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111010x
                                                             uabal.  */
                                                          return 80;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001010xxxxx1xx0111011x
                                                             uabal2.  */
                                                          return 81;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001011xxxxx1xx01110x0x
                                                         sqdmull.  */
                                                      return 64;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001011xxxxx1xx01110x1x
                                                         sqdmull2.  */
                                                      return 65;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111000x
                                                             ssubw.  */
                                                          return 44;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111001x
                                                             ssubw2.  */
                                                          return 45;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111010x
                                                             usubw.  */
                                                          return 76;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx001100xxxxx1xx0111011x
                                                             usubw2.  */
                                                          return 77;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001101xxxxx1xx01110x0x
                                                         sqdmlsl.  */
                                                      return 60;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx001101xxxxx1xx01110x1x
                                                         sqdmlsl2.  */
                                                      return 61;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111000x
                                                         sabdl.  */
                                                      return 52;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111001x
                                                         sabdl2.  */
                                                      return 53;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111010x
                                                         uabdl.  */
                                                      return 84;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx00111xxxxxx1xx0111011x
                                                         uabdl2.  */
                                                      return 85;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx001xxxxxxxx1xx01111x0x
                                             fmov.  */
                                          return 705;
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00100xxxxxx1xx01111x1x
                                                     sqdmlal.  */
                                                  return 347;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx00101xxxxxx1xx01111x1x
                                                     sqdmull.  */
                                                  return 349;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0011xxxxxxx1xx01111x1x
                                                 sqdmlsl.  */
                                              return 348;
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx011100xx
                                                         rev64.  */
                                                      return 146;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx011101xx
                                                         rev32.  */
                                                      return 182;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx01111x0x
                                                         fmul.  */
                                                      return 679;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010000xxxxx1xx01111x1x
                                                         sha1h.  */
                                                      return 546;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100010xxxx1xx011100xx
                                                             cmgt.  */
                                                          return 154;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100010xxxx1xx011101xx
                                                             cmge.  */
                                                          return 188;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100011xxxx1x0011100xx
                                                                 frintn.  */
                                                              return 166;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100011xxxx1x0011101xx
                                                                 frinta.  */
                                                              return 199;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100011xxxx1x101110xxx
                                                             frintp.  */
                                                          return 176;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010001xxxxx1xx0111100x
                                                             fnmul.  */
                                                          return 695;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010001xxxxx1xx0111101x
                                                             cmgt.  */
                                                          return 403;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010001xxxxx1xx011111xx
                                                         cmge.  */
                                                      return 421;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100100xx0x1xx011100xx
                                                                 cls.  */
                                                              return 150;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100100xx0x1xx011101xx
                                                                 clz.  */
                                                              return 185;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100100xx1x1xx01110xxx
                                                             aese.  */
                                                          return 542;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111000x
                                                                 sqxtn.  */
                                                              return 160;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111001x
                                                                 sqxtn2.  */
                                                              return 161;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111010x
                                                                 uqxtn.  */
                                                              return 195;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100101xxxx1xx0111011x
                                                                 uqxtn2.  */
                                                              return 196;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010010xxxxx1xx0111100x
                                                             fmax.  */
                                                          return 687;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010010xxxxx1xx0111101x
                                                             sqxtn.  */
                                                          return 407;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010010xxxxx1xx011111xx
                                                         uqxtn.  */
                                                      return 425;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx01xx011100xx
                                                                 fcmgt.  */
                                                              return 172;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx01xx011101xx
                                                                 fcmge.  */
                                                              return 208;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx01xx011110xx
                                                                 fcmgt.  */
                                                              return 412;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx01xx011111xx
                                                                 fcmge.  */
                                                              return 431;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx11x001110xxx
                                                                 fmaxnmv.  */
                                                              return 34;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx11x001111xxx
                                                                 fmaxnmp.  */
                                                              return 439;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx11x101110xxx
                                                                 fminnmv.  */
                                                              return 36;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100110xxx11x101111xxx
                                                                 fminnmp.  */
                                                              return 442;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xxxx1x0011100xx
                                                                 fcvtas.  */
                                                              return 170;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xxxx1x0011101xx
                                                                 fcvtau.  */
                                                              return 203;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xxxx1x0011110xx
                                                                 fcvtas.  */
                                                              return 410;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0100111xxxx1x0011111xx
                                                                 fcvtau.  */
                                                              return 429;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100111xxxx1x10111x0xx
                                                             urecpe.  */
                                                          return 180;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0100111xxxx1x10111x1xx
                                                             ursqrte.  */
                                                          return 214;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101000xxxx1xx011100xx
                                                             saddlp.  */
                                                          return 148;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101000xxxx1xx011101xx
                                                             uaddlp.  */
                                                          return 183;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111000x
                                                                 xtn.  */
                                                              return 158;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111001x
                                                                 xtn2.  */
                                                              return 159;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111010x
                                                                 sqxtun.  */
                                                              return 191;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101001xxxx1xx0111011x
                                                                 sqxtun2.  */
                                                              return 192;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010100xxxxx1xx0111100x
                                                             fadd.  */
                                                          return 683;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx010100xxxxx1xx0111101x
                                                             sha256su0.  */
                                                          return 548;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010100xxxxx1xx011111xx
                                                         sqxtun.  */
                                                      return 424;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx01xx01110xxx
                                                             cmlt.  */
                                                          return 156;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx01xx01111xxx
                                                             cmlt.  */
                                                          return 405;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx11xx0111x0xx
                                                             smaxv.  */
                                                          return 28;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101010xxx11xx0111x1xx
                                                             umaxv.  */
                                                          return 32;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x0011100xx
                                                                     fcvtns.  */
                                                                  return 168;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x0011101xx
                                                                     fcvtnu.  */
                                                                  return 201;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x0011110xx
                                                                     fcvtns.  */
                                                                  return 408;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x0011111xx
                                                                     fcvtnu.  */
                                                                  return 427;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x1011100xx
                                                                     fcvtps.  */
                                                                  return 178;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x1011101xx
                                                                     fcvtpu.  */
                                                                  return 212;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x1011110xx
                                                                     fcvtps.  */
                                                                  return 415;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0101011xxx01x1011111xx
                                                                     fcvtpu.  */
                                                                  return 433;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101011xxx11xx0111x0xx
                                                             sminv.  */
                                                          return 29;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101011xxx11xx0111x1xx
                                                             uminv.  */
                                                          return 33;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101100xx0x1xx011100xx
                                                                 sadalp.  */
                                                              return 152;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101100xx0x1xx011101xx
                                                                 uadalp.  */
                                                              return 186;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0101100xx1x1xx01110xxx
                                                             aesmc.  */
                                                          return 544;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111000x
                                                                 fcvtn.  */
                                                              return 162;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111001x
                                                                 fcvtn2.  */
                                                              return 163;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 30) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111010x
                                                                 fcvtxn.  */
                                                              return 197;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0101101xxxx1xx0111011x
                                                                 fcvtxn2.  */
                                                              return 198;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010110xxxxx1xx011110xx
                                                         fmaxnm.  */
                                                      return 691;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx010110xxxxx1xx011111xx
                                                         fcvtxn.  */
                                                      return 426;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx010111xxxxx1xx01110xxx
                                                     fcmlt.  */
                                                  return 174;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx010111xxxxx1xx01111xxx
                                                     fcmlt.  */
                                                  return 414;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx011000xxxxx1xx01110xxx
                                                     rev16.  */
                                                  return 147;
                                                }
                                              else
                                                {
                                                  if (((word >> 30) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011000xxxxx1xx01111x0x
                                                         fdiv.  */
                                                      return 681;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011000xxxxx1xx01111x1x
                                                         sha1su1.  */
                                                      return 547;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011100xx
                                                             cmeq.  */
                                                          return 155;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011101xx
                                                             cmle.  */
                                                          return 189;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011110xx
                                                             cmeq.  */
                                                          return 404;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110010xxxx1xx011111xx
                                                             cmle.  */
                                                          return 422;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110011xxxx1x00111x0xx
                                                             frintm.  */
                                                          return 167;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110011xxxx1x00111x1xx
                                                             frintx.  */
                                                          return 200;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110011xxxx1x10111x0xx
                                                             frintz.  */
                                                          return 177;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0110011xxxx1x10111x1xx
                                                             frinti.  */
                                                          return 211;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 19) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011010xxx0x1xx011100xx
                                                             cnt.  */
                                                          return 151;
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 22) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx011010xxx0x10x011101xx
                                                                 not.  */
                                                              return 205;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx011010xxx0x11x011101xx
                                                                 rbit.  */
                                                              return 207;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011010xxx1x1xx01110xxx
                                                         aesd.  */
                                                      return 543;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx011010xxxxx1xx01111xxx
                                                     fmin.  */
                                                  return 689;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xxx01xx011100xx
                                                                 fcmeq.  */
                                                              return 173;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xxx01xx011101xx
                                                                 fcmle.  */
                                                              return 209;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xxx01xx011110xx
                                                                 fcmeq.  */
                                                              return 413;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110110xxx01xx011111xx
                                                                 fcmle.  */
                                                              return 432;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx0110110xxx11xx0111xxxx
                                                         faddp.  */
                                                      return 440;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x0011100xx
                                                                 scvtf.  */
                                                              return 171;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x0011101xx
                                                                 ucvtf.  */
                                                              return 204;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x0011110xx
                                                                 scvtf.  */
                                                              return 411;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x0011111xx
                                                                 ucvtf.  */
                                                              return 430;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x1011100xx
                                                                 frecpe.  */
                                                              return 181;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x1011101xx
                                                                 frsqrte.  */
                                                              return 215;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x1011110xx
                                                                 frecpe.  */
                                                              return 417;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0110111xxxx1x1011111xx
                                                                 frsqrte.  */
                                                              return 435;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 20) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx01xx011100xx
                                                                 suqadd.  */
                                                              return 149;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx01xx011101xx
                                                                 usqadd.  */
                                                              return 184;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx11xx011100xx
                                                                 saddlv.  */
                                                              return 27;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111000xxx11xx011101xx
                                                                 uaddlv.  */
                                                              return 31;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111001xxxx1xx01110x0x
                                                             shll.  */
                                                          return 193;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111001xxxx1xx01110x1x
                                                             shll2.  */
                                                          return 194;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011100xxxxx1xx0111100x
                                                             fsub.  */
                                                          return 685;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011100xxxxx1xx0111101x
                                                             suqadd.  */
                                                          return 401;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011100xxxxx1xx011111xx
                                                         usqadd.  */
                                                      return 419;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011100xx
                                                             abs.  */
                                                          return 157;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011101xx
                                                             neg.  */
                                                          return 190;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011110xx
                                                             abs.  */
                                                          return 406;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111010xxxx1xx011111xx
                                                             neg.  */
                                                          return 423;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x0011100xx
                                                                     fcvtms.  */
                                                                  return 169;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x0011101xx
                                                                     fcvtmu.  */
                                                                  return 202;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x0011110xx
                                                                     fcvtms.  */
                                                                  return 409;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x0011111xx
                                                                     fcvtmu.  */
                                                                  return 428;
                                                                }
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x1011100xx
                                                                     fcvtzs.  */
                                                                  return 179;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x1011101xx
                                                                     fcvtzu.  */
                                                                  return 213;
                                                                }
                                                            }
                                                          else
                                                            {
                                                              if (((word >> 29) & 0x1) == 0)
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x1011110xx
                                                                     fcvtzs.  */
                                                                  return 416;
                                                                }
                                                              else
                                                                {
                                                                  /* 33222222222211111111110000000000
                                                                     10987654321098765432109876543210
                                                                     xxxxxxxxxx0111011xxx01x1011111xx
                                                                     fcvtzu.  */
                                                                  return 434;
                                                                }
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 28) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111011xxx11xx01110xxx
                                                             addv.  */
                                                          return 30;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111011xxx11xx01111xxx
                                                             addp.  */
                                                          return 438;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 15) & 0x1) == 0)
                                            {
                                              if (((word >> 28) & 0x1) == 0)
                                                {
                                                  if (((word >> 16) & 0x1) == 0)
                                                    {
                                                      if (((word >> 19) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111100xx0x1xx011100xx
                                                                 sqabs.  */
                                                              return 153;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111100xx0x1xx011101xx
                                                                 sqneg.  */
                                                              return 187;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111100xx1x1xx01110xxx
                                                             aesimc.  */
                                                          return 545;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111101xxxx1xx01110x0x
                                                             fcvtl.  */
                                                          return 164;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111101xxxx1xx01110x1x
                                                             fcvtl2.  */
                                                          return 165;
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      if (((word >> 30) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011110xxxxx1xx0111100x
                                                             fminnm.  */
                                                          return 693;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx011110xxxxx1xx0111101x
                                                             sqabs.  */
                                                          return 402;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx011110xxxxx1xx011111xx
                                                         sqneg.  */
                                                      return 420;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 16) & 0x1) == 0)
                                                {
                                                  if (((word >> 20) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111110xxx01xx0111x0xx
                                                             fabs.  */
                                                          return 175;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx0111110xxx01xx0111x1xx
                                                             fneg.  */
                                                          return 210;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xxx11x001110xxx
                                                                 fmaxv.  */
                                                              return 35;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xxx11x001111xxx
                                                                 fmaxp.  */
                                                              return 441;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 28) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xxx11x101110xxx
                                                                 fminv.  */
                                                              return 37;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx0111110xxx11x101111xxx
                                                                 fminp.  */
                                                              return 443;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 28) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx0111111xxxx1xx01110xxx
                                                         fsqrt.  */
                                                      return 216;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx0111111xxxx1xx01111xxx
                                                         frecpx.  */
                                                      return 418;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 11) & 0x1) == 0)
                            {
                              if (((word >> 28) & 0x1) == 0)
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100000xxxxx1xx011100xx
                                                         shadd.  */
                                                      return 223;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100000xxxxx1xx011101xx
                                                         uhadd.  */
                                                      return 263;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100001xxxxx1xx011100xx
                                                         add.  */
                                                      return 238;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100001xxxxx1xx011101xx
                                                         sub.  */
                                                      return 278;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100010xxxxx1xx011100xx
                                                         sshl.  */
                                                      return 230;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100010xxxxx1xx011101xx
                                                         ushl.  */
                                                      return 270;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x0011100xx
                                                             fmaxnm.  */
                                                          return 246;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x0011101xx
                                                             fmaxnmp.  */
                                                          return 285;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x1011100xx
                                                             fminnm.  */
                                                          return 255;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100011xxxxx1x1011101xx
                                                             fminnmp.  */
                                                          return 294;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100100xxxxx1xx011100xx
                                                         shsub.  */
                                                      return 226;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100100xxxxx1xx011101xx
                                                         uhsub.  */
                                                      return 266;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100101xxxxx1xx011100xx
                                                         smaxp.  */
                                                      return 242;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100101xxxxx1xx011101xx
                                                         umaxp.  */
                                                      return 282;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100110xxxxx1xx011100xx
                                                         smax.  */
                                                      return 234;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100110xxxxx1xx011101xx
                                                         umax.  */
                                                      return 274;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100111xxxxx1x0011100xx
                                                             fcmeq.  */
                                                          return 250;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx100111xxxxx1x0011101xx
                                                             fcmge.  */
                                                          return 288;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx100111xxxxx1x101110xxx
                                                         fcmgt.  */
                                                      return 296;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101000xxxxx1xx011100xx
                                                         srhadd.  */
                                                      return 225;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101000xxxxx1xx011101xx
                                                         urhadd.  */
                                                      return 265;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101001xxxxx1xx011100xx
                                                         mla.  */
                                                      return 240;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101001xxxxx1xx011101xx
                                                         mls.  */
                                                      return 280;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101010xxxxx1xx011100xx
                                                         srshl.  */
                                                      return 232;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101010xxxxx1xx011101xx
                                                         urshl.  */
                                                      return 272;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x0011100xx
                                                             fadd.  */
                                                          return 248;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x0011101xx
                                                             faddp.  */
                                                          return 286;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x1011100xx
                                                             fsub.  */
                                                          return 257;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101011xxxxx1x1011101xx
                                                             fabd.  */
                                                          return 295;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101100xxxxx1xx011100xx
                                                         cmgt.  */
                                                      return 228;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101100xxxxx1xx011101xx
                                                         cmhi.  */
                                                      return 268;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101101xxxxx1xx011100xx
                                                         sqdmulh.  */
                                                      return 244;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101101xxxxx1xx011101xx
                                                         sqrdmulh.  */
                                                      return 284;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101110xxxxx1xx011100xx
                                                         sabd.  */
                                                      return 236;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx101110xxxxx1xx011101xx
                                                         uabd.  */
                                                      return 276;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x0011100xx
                                                             fmax.  */
                                                          return 251;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x0011101xx
                                                             fmaxp.  */
                                                          return 290;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x1011100xx
                                                             fmin.  */
                                                          return 258;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx101111xxxxx1x1011101xx
                                                             fminp.  */
                                                          return 298;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          if (((word >> 4) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxx0xxxxx10xxxxxxxxx1xx0111100x
                                                 fccmp.  */
                                              return 644;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxx1xxxxx10xxxxxxxxx1xx0111100x
                                                 fccmpe.  */
                                              return 646;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx10000xxxxxx1xx0111101x
                                                         add.  */
                                                      return 457;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx10001xxxxxx1xx0111101x
                                                         sshl.  */
                                                      return 455;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1001xxxxxxx1xx0111101x
                                                     fcmeq.  */
                                                  return 450;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1010xxxxxxx1xx0111101x
                                                     srshl.  */
                                                  return 456;
                                                }
                                              else
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1011x0xxxxx1xx0111101x
                                                         cmgt.  */
                                                      return 453;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1011x1xxxxx1xx0111101x
                                                         sqdmulh.  */
                                                      return 448;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10000xxxxxx1xx011111xx
                                                     sub.  */
                                                  return 473;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx10001xxxxxx1xx011111xx
                                                     ushl.  */
                                                  return 471;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 23) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1001xxxxxxx1x0011111xx
                                                     fcmge.  */
                                                  return 464;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1001xxxxxxx1x1011111xx
                                                     fcmgt.  */
                                                  return 467;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1010x0xxxxx1xx011111xx
                                                     urshl.  */
                                                  return 472;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1010x1xxxxx1xx011111xx
                                                     fabd.  */
                                                  return 466;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1011x0xxxxx1xx011111xx
                                                     cmhi.  */
                                                  return 469;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1011x1xxxxx1xx011111xx
                                                     sqrdmulh.  */
                                                  return 463;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 28) & 0x1) == 0)
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110000xxxxx1xx011100xx
                                                         sqadd.  */
                                                      return 224;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110000xxxxx1xx011101xx
                                                         uqadd.  */
                                                      return 264;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110001xxxxx1xx011100xx
                                                         cmtst.  */
                                                      return 239;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110001xxxxx1xx011101xx
                                                         cmeq.  */
                                                      return 279;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110010xxxxx1xx011100xx
                                                         sqshl.  */
                                                      return 231;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110010xxxxx1xx011101xx
                                                         uqshl.  */
                                                      return 271;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110011xxxxx1x001110xxx
                                                         fmla.  */
                                                      return 247;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110011xxxxx1x101110xxx
                                                         fmls.  */
                                                      return 256;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110100xxxxx1xx011100xx
                                                         sqsub.  */
                                                      return 227;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110100xxxxx1xx011101xx
                                                         uqsub.  */
                                                      return 267;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110101xxxxx1xx011100xx
                                                         sminp.  */
                                                      return 243;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110101xxxxx1xx011101xx
                                                         uminp.  */
                                                      return 283;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110110xxxxx1xx011100xx
                                                         smin.  */
                                                      return 235;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110110xxxxx1xx011101xx
                                                         umin.  */
                                                      return 275;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110111xxxxx1x001110xxx
                                                         facge.  */
                                                      return 289;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110111xxxxx1x101110xxx
                                                         facgt.  */
                                                      return 297;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 22) & 0x1) == 0)
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx100011100xx
                                                                 and.  */
                                                              return 253;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx100011101xx
                                                                 eor.  */
                                                              return 292;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx101011100xx
                                                                 orr.  */
                                                              return 260;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx101011101xx
                                                                 bit.  */
                                                              return 299;
                                                            }
                                                        }
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx110011100xx
                                                                 bic.  */
                                                              return 254;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx110011101xx
                                                                 bsl.  */
                                                              return 293;
                                                            }
                                                        }
                                                      else
                                                        {
                                                          if (((word >> 29) & 0x1) == 0)
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx111011100xx
                                                                 orn.  */
                                                              return 262;
                                                            }
                                                          else
                                                            {
                                                              /* 33222222222211111111110000000000
                                                                 10987654321098765432109876543210
                                                                 xxxxxxxxxx111000xxxxx111011101xx
                                                                 bif.  */
                                                              return 300;
                                                            }
                                                        }
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111001xxxxx1xx011100xx
                                                         mul.  */
                                                      return 241;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111001xxxxx1xx011101xx
                                                         pmul.  */
                                                      return 281;
                                                    }
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111010xxxxx1xx011100xx
                                                         sqrshl.  */
                                                      return 233;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111010xxxxx1xx011101xx
                                                         uqrshl.  */
                                                      return 273;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111011xxxxx1xx011100xx
                                                         fmulx.  */
                                                      return 249;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111011xxxxx1xx011101xx
                                                         fmul.  */
                                                      return 287;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111100xxxxx1xx011100xx
                                                         cmge.  */
                                                      return 229;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111100xxxxx1xx011101xx
                                                         cmhs.  */
                                                      return 269;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx111101xxxxx1xx01110xxx
                                                     addp.  */
                                                  return 245;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 15) & 0x1) == 0)
                                                {
                                                  if (((word >> 29) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111110xxxxx1xx011100xx
                                                         saba.  */
                                                      return 237;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111110xxxxx1xx011101xx
                                                         uaba.  */
                                                      return 277;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      if (((word >> 29) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx111111xxxxx1x0011100xx
                                                             frecps.  */
                                                          return 252;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx111111xxxxx1x0011101xx
                                                             fdiv.  */
                                                          return 291;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx111111xxxxx1x101110xxx
                                                         frsqrts.  */
                                                      return 259;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      if (((word >> 30) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx11xxxxxxxxx1xx0111100x
                                             fcsel.  */
                                          return 707;
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      if (((word >> 15) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx110000xxxxx1xx0111101x
                                                             sqadd.  */
                                                          return 444;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx110001xxxxx1xx0111101x
                                                             cmtst.  */
                                                          return 458;
                                                        }
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11001xxxxxx1xx0111101x
                                                         sqshl.  */
                                                      return 446;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1101xxxxxxx1xx0111101x
                                                     sqsub.  */
                                                  return 445;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 13) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1110x0xxxxx1xx0111101x
                                                         sqrshl.  */
                                                      return 447;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx1110x1xxxxx1xx0111101x
                                                         fmulx.  */
                                                      return 449;
                                                    }
                                                }
                                              else
                                                {
                                                  if (((word >> 14) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11110xxxxxx1xx0111101x
                                                         cmge.  */
                                                      return 454;
                                                    }
                                                  else
                                                    {
                                                      if (((word >> 23) & 0x1) == 0)
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx11111xxxxxx1x00111101x
                                                             frecps.  */
                                                          return 451;
                                                        }
                                                      else
                                                        {
                                                          /* 33222222222211111111110000000000
                                                             10987654321098765432109876543210
                                                             xxxxxxxxxx11111xxxxxx1x10111101x
                                                             frsqrts.  */
                                                          return 452;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  if (((word >> 15) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110000xxxxx1xx011111xx
                                                         uqadd.  */
                                                      return 459;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx110001xxxxx1xx011111xx
                                                         cmeq.  */
                                                      return 474;
                                                    }
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11001xxxxxx1xx011111xx
                                                     uqshl.  */
                                                  return 461;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx11010xxxxxx1xx011111xx
                                                     uqsub.  */
                                                  return 460;
                                                }
                                              else
                                                {
                                                  if (((word >> 23) & 0x1) == 0)
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11011xxxxxx1x0011111xx
                                                         facge.  */
                                                      return 465;
                                                    }
                                                  else
                                                    {
                                                      /* 33222222222211111111110000000000
                                                         10987654321098765432109876543210
                                                         xxxxxxxxxx11011xxxxxx1x1011111xx
                                                         facgt.  */
                                                      return 468;
                                                    }
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1110xxxxxxx1xx011111xx
                                                 uqrshl.  */
                                              return 462;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111xxxxxxx1xx011111xx
                                                 cmhs.  */
                                              return 470;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
              else
                {
                  if (((word >> 15) & 0x1) == 0)
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0000xxxxxxxx11110xxx
                                             mla.  */
                                          return 110;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0010xxxxxxxx11110xxx
                                             mls.  */
                                          return 113;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111000x
                                                     smlal.  */
                                                  return 92;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111001x
                                                     smlal2.  */
                                                  return 93;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111010x
                                                     umlal.  */
                                                  return 111;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0100xxxxxxxx1111011x
                                                     umlal2.  */
                                                  return 112;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111000x
                                                     smlsl.  */
                                                  return 96;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111001x
                                                     smlsl2.  */
                                                  return 97;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111010x
                                                     umlsl.  */
                                                  return 114;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x0110xxxxxxxx1111011x
                                                     umlsl2.  */
                                                  return 115;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x1000xxxxxxxx11110xxx
                                             fmla.  */
                                          return 107;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x1010xxxxxxxx11110xxx
                                             fmls.  */
                                          return 108;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1100xxxxxxxx11110x0x
                                                 sqdmlal.  */
                                              return 94;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1100xxxxxxxx11110x1x
                                                 sqdmlal2.  */
                                              return 95;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1110xxxxxxxx11110x0x
                                                 sqdmlsl.  */
                                              return 98;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1110xxxxxxxx11110x1x
                                                 sqdmlsl2.  */
                                              return 99;
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x0xx0xxxxxxxx111100xx
                                         movi.  */
                                      return 122;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x0xx0xxxxxxxx111101xx
                                         mvni.  */
                                      return 129;
                                    }
                                }
                              else
                                {
                                  if (((word >> 29) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x1xx0xxxxxxxx111100xx
                                         orr.  */
                                      return 123;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx1x1xx0xxxxxxxx111101xx
                                         bic.  */
                                      return 130;
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx0xx1111100x
                                         fmadd.  */
                                      return 697;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx0xxxxx1xx1111100x
                                         fnmadd.  */
                                      return 701;
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx000xxxxxxxx1111101x
                                                 fmla.  */
                                              return 355;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx010xxxxxxxx1111101x
                                                 fmls.  */
                                              return 356;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 14) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx100xxxxxxxx1111101x
                                                 sqdmlal.  */
                                              return 350;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0xx110xxxxxxxx1111101x
                                                 sqdmlsl.  */
                                              return 351;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1x00x0xxxxxxxx1111101x
                                                 sshr.  */
                                              return 477;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1x01x0xxxxxxxx1111101x
                                                 srshr.  */
                                              return 479;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1000xxxxxxxx1111101x
                                                     ssra.  */
                                                  return 478;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1010xxxxxxxx1111101x
                                                     shl.  */
                                                  return 481;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1100xxxxxxxx1111101x
                                                     srsra.  */
                                                  return 480;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1x1110xxxxxxxx1111101x
                                                     sqshl.  */
                                                  return 482;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0000xxxxxxxx111111xx
                                             ushr.  */
                                          return 487;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0010xxxxxxxx111111xx
                                             sri.  */
                                          return 491;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0100xxxxxxxx111111xx
                                             urshr.  */
                                          return 489;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx0110xxxxxxxx111111xx
                                             sqshlu.  */
                                          return 493;
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1000xxxxxxxx111111xx
                                             usra.  */
                                          return 488;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1010xxxxxxxx111111xx
                                             sli.  */
                                          return 492;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1100xxxxxxxx111111xx
                                             ursra.  */
                                          return 490;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxxxx1110xxxxxxxx111111xx
                                             uqshl.  */
                                          return 494;
                                        }
                                    }
                                }
                            }
                        }
                    }
                  else
                    {
                      if (((word >> 28) & 0x1) == 0)
                        {
                          if (((word >> 10) & 0x1) == 0)
                            {
                              if (((word >> 12) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0001xxxxxxxx11110xxx
                                             mul.  */
                                          return 100;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0011xxxxxxxx11110xxx
                                             sqdmulh.  */
                                          return 105;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 29) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111000x
                                                 smull.  */
                                              return 101;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111001x
                                                 smull2.  */
                                              return 102;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111010x
                                                 umull.  */
                                              return 116;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x01x1xxxxxxxx1111011x
                                                 umull2.  */
                                              return 117;
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1001xxxxxxxx111100xx
                                                 fmul.  */
                                              return 109;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1001xxxxxxxx111101xx
                                                 fmulx.  */
                                              return 118;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1011xxxxxxxx111100xx
                                                 sqrdmulh.  */
                                              return 106;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1011xxxxxxxx111101xx
                                                 sqrdmlah.  */
                                              return 119;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1101xxxxxxxx11110x0x
                                                 sqdmull.  */
                                              return 103;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x1101xxxxxxxx11110x1x
                                                 sqdmull2.  */
                                              return 104;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x1111xxxxxxxx11110xxx
                                             sqrdmlsh.  */
                                          return 120;
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 11) & 0x1) == 0)
                                {
                                  if (((word >> 14) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx100x01xxxxxxxx111100xx
                                                 movi.  */
                                              return 124;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx100x01xxxxxxxx111101xx
                                                 mvni.  */
                                              return 131;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x01xxxxxxxx111100xx
                                                 orr.  */
                                              return 125;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101x01xxxxxxxx111101xx
                                                 bic.  */
                                              return 132;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx10x011xxxxxxxx111100xx
                                                 movi.  */
                                              return 126;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx10x011xxxxxxxx111101xx
                                                 mvni.  */
                                              return 133;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx100111xxxxxxxx111100xx
                                                     movi.  */
                                                  return 127;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx100111xxxxxxxx111101xx
                                                     movi.  */
                                                  return 134;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 29) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx101111xxxxxxxx111100xx
                                                     fmov.  */
                                                  return 128;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx101111xxxxxxxx111101xx
                                                     fmov.  */
                                                  return 136;
                                                }
                                            }
                                        }
                                    }
                                }
                              else
                                {
                                  if (((word >> 12) & 0x1) == 0)
                                    {
                                      if (((word >> 29) & 0x1) == 0)
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111000x
                                                 rshrn.  */
                                              return 311;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111001x
                                                 rshrn2.  */
                                              return 312;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 30) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111010x
                                                 sqrshrun.  */
                                              return 333;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx110xx1xxxxxxxx1111011x
                                                 sqrshrun2.  */
                                              return 334;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 13) & 0x1) == 0)
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111000x
                                                     sqrshrn.  */
                                                  return 315;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111001x
                                                     sqrshrn2.  */
                                                  return 316;
                                                }
                                            }
                                          else
                                            {
                                              if (((word >> 30) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111010x
                                                     uqrshrn.  */
                                                  return 337;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx1110x1xxxxxxxx1111011x
                                                     uqrshrn2.  */
                                                  return 338;
                                                }
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 29) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111x1xxxxxxxx111100xx
                                                 fcvtzs.  */
                                              return 322;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111x1xxxxxxxx111101xx
                                                 fcvtzu.  */
                                              return 344;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                      else
                        {
                          if (((word >> 29) & 0x1) == 0)
                            {
                              if (((word >> 30) & 0x1) == 0)
                                {
                                  if (((word >> 21) & 0x1) == 0)
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx1xxxxx0xx1111100x
                                         fmsub.  */
                                      return 699;
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxxxxxxx1xxxxx1xx1111100x
                                         fnmsub.  */
                                      return 703;
                                    }
                                }
                              else
                                {
                                  if (((word >> 10) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0x0xx1xxxxxxxx1111101x
                                             sqdmulh.  */
                                          return 353;
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              if (((word >> 14) & 0x1) == 0)
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x1001xxxxxxxx1111101x
                                                     fmul.  */
                                                  return 357;
                                                }
                                              else
                                                {
                                                  /* 33222222222211111111110000000000
                                                     10987654321098765432109876543210
                                                     xxxxxxxxxx0x1011xxxxxxxx1111101x
                                                     sqrdmulh.  */
                                                  return 354;
                                                }
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx0x11x1xxxxxxxx1111101x
                                                 sqdmull.  */
                                              return 352;
                                            }
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 11) & 0x1) == 0)
                                        {
                                          if (((word >> 12) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx100xx1xxxxxxxx1111101x
                                                 scvtf.  */
                                              return 485;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx101xx1xxxxxxxx1111101x
                                                 sqshrn.  */
                                              return 483;
                                            }
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11x0x1xxxxxxxx1111101x
                                                 sqrshrn.  */
                                              return 484;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx11x1x1xxxxxxxx1111101x
                                                 fcvtzs.  */
                                              return 486;
                                            }
                                        }
                                    }
                                }
                            }
                          else
                            {
                              if (((word >> 10) & 0x1) == 0)
                                {
                                  if (((word >> 13) & 0x1) == 0)
                                    {
                                      if (((word >> 14) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0xx001xxxxxxxx111111xx
                                             fmulx.  */
                                          return 358;
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx0xx011xxxxxxxx111111xx
                                             sqrdmlah.  */
                                          return 359;
                                        }
                                    }
                                  else
                                    {
                                      /* 33222222222211111111110000000000
                                         10987654321098765432109876543210
                                         xxxxxxxxxx0xx1x1xxxxxxxx111111xx
                                         sqrdmlsh.  */
                                      return 360;
                                    }
                                }
                              else
                                {
                                  if (((word >> 11) & 0x1) == 0)
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1000x1xxxxxxxx111111xx
                                                 sqshrun.  */
                                              return 495;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1001x1xxxxxxxx111111xx
                                                 ucvtf.  */
                                              return 499;
                                            }
                                        }
                                      else
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx101xx1xxxxxxxx111111xx
                                             uqshrn.  */
                                          return 497;
                                        }
                                    }
                                  else
                                    {
                                      if (((word >> 12) & 0x1) == 0)
                                        {
                                          /* 33222222222211111111110000000000
                                             10987654321098765432109876543210
                                             xxxxxxxxxx110xx1xxxxxxxx111111xx
                                             sqrshrun.  */
                                          return 496;
                                        }
                                      else
                                        {
                                          if (((word >> 13) & 0x1) == 0)
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1110x1xxxxxxxx111111xx
                                                 uqrshrn.  */
                                              return 498;
                                            }
                                          else
                                            {
                                              /* 33222222222211111111110000000000
                                                 10987654321098765432109876543210
                                                 xxxxxxxxxx1111x1xxxxxxxx111111xx
                                                 fcvtzu.  */
                                              return 500;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

/* Lookup opcode WORD in the opcode table.  N.B. all alias
   opcodes are ignored here.  */

const aarch64_opcode *
aarch64_opcode_lookup (uint32_t word)
{
  return aarch64_opcode_table + aarch64_opcode_lookup_1 (word);
}

const aarch64_opcode *
aarch64_find_next_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the next opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 793: value = 797; break;	/* stnp --> stp.  */
    case 797: return NULL;		/* stp --> NULL.  */
    case 791: value = 792; break;	/* stllrb --> stllrh.  */
    case 792: return NULL;		/* stllrh --> NULL.  */
    case 794: value = 798; break;	/* ldnp --> ldp.  */
    case 798: return NULL;		/* ldp --> NULL.  */
    case 1009: value = 1010; break;	/* msr --> hint.  */
    case 1010: value = 1017; break;	/* hint --> clrex.  */
    case 1017: value = 1018; break;	/* clrex --> dsb.  */
    case 1018: value = 1019; break;	/* dsb --> dmb.  */
    case 1019: value = 1020; break;	/* dmb --> isb.  */
    case 1020: value = 1021; break;	/* isb --> sys.  */
    case 1021: value = 1026; break;	/* sys --> msr.  */
    case 1026: return NULL;		/* msr --> NULL.  */
    case 1027: value = 1028; break;	/* sysl --> mrs.  */
    case 1028: return NULL;		/* mrs --> NULL.  */
    case 361: value = 362; break;	/* st4 --> st1.  */
    case 362: value = 363; break;	/* st1 --> st2.  */
    case 363: value = 364; break;	/* st2 --> st3.  */
    case 364: return NULL;		/* st3 --> NULL.  */
    case 369: value = 370; break;	/* st4 --> st1.  */
    case 370: value = 371; break;	/* st1 --> st2.  */
    case 371: value = 372; break;	/* st2 --> st3.  */
    case 372: return NULL;		/* st3 --> NULL.  */
    case 365: value = 366; break;	/* ld4 --> ld1.  */
    case 366: value = 367; break;	/* ld1 --> ld2.  */
    case 367: value = 368; break;	/* ld2 --> ld3.  */
    case 368: return NULL;		/* ld3 --> NULL.  */
    case 381: value = 383; break;	/* ld1 --> ld1r.  */
    case 383: return NULL;		/* ld1r --> NULL.  */
    case 385: value = 387; break;	/* ld2 --> ld2r.  */
    case 387: return NULL;		/* ld2r --> NULL.  */
    case 382: value = 384; break;	/* ld3 --> ld3r.  */
    case 384: return NULL;		/* ld3r --> NULL.  */
    case 386: value = 388; break;	/* ld4 --> ld4r.  */
    case 388: return NULL;		/* ld4r --> NULL.  */
    case 373: value = 374; break;	/* ld4 --> ld1.  */
    case 374: value = 375; break;	/* ld1 --> ld2.  */
    case 375: value = 376; break;	/* ld2 --> ld3.  */
    case 376: return NULL;		/* ld3 --> NULL.  */
    case 393: value = 395; break;	/* ld1 --> ld1r.  */
    case 395: return NULL;		/* ld1r --> NULL.  */
    case 394: value = 396; break;	/* ld3 --> ld3r.  */
    case 396: return NULL;		/* ld3r --> NULL.  */
    case 397: value = 399; break;	/* ld2 --> ld2r.  */
    case 399: return NULL;		/* ld2r --> NULL.  */
    case 398: value = 400; break;	/* ld4 --> ld4r.  */
    case 400: return NULL;		/* ld4r --> NULL.  */
    case 610: value = 611; break;	/* fcvtzs --> fcvtzs.  */
    case 611: return NULL;		/* fcvtzs --> NULL.  */
    case 606: value = 607; break;	/* scvtf --> scvtf.  */
    case 607: return NULL;		/* scvtf --> NULL.  */
    case 612: value = 613; break;	/* fcvtzu --> fcvtzu.  */
    case 613: return NULL;		/* fcvtzu --> NULL.  */
    case 608: value = 609; break;	/* ucvtf --> ucvtf.  */
    case 609: return NULL;		/* ucvtf --> NULL.  */
    case 614: value = 615; break;	/* fcvtns --> fcvtns.  */
    case 615: return NULL;		/* fcvtns --> NULL.  */
    case 634: value = 635; break;	/* fcvtms --> fcvtms.  */
    case 635: return NULL;		/* fcvtms --> NULL.  */
    case 630: value = 631; break;	/* fcvtps --> fcvtps.  */
    case 631: return NULL;		/* fcvtps --> NULL.  */
    case 638: value = 639; break;	/* fcvtzs --> fcvtzs.  */
    case 639: return NULL;		/* fcvtzs --> NULL.  */
    case 622: value = 623; break;	/* fcvtas --> fcvtas.  */
    case 623: return NULL;		/* fcvtas --> NULL.  */
    case 618: value = 619; break;	/* scvtf --> scvtf.  */
    case 619: return NULL;		/* scvtf --> NULL.  */
    case 626: value = 627; break;	/* fmov --> fmov.  */
    case 627: return NULL;		/* fmov --> NULL.  */
    case 616: value = 617; break;	/* fcvtnu --> fcvtnu.  */
    case 617: return NULL;		/* fcvtnu --> NULL.  */
    case 636: value = 637; break;	/* fcvtmu --> fcvtmu.  */
    case 637: return NULL;		/* fcvtmu --> NULL.  */
    case 632: value = 633; break;	/* fcvtpu --> fcvtpu.  */
    case 633: return NULL;		/* fcvtpu --> NULL.  */
    case 640: value = 641; break;	/* fcvtzu --> fcvtzu.  */
    case 641: return NULL;		/* fcvtzu --> NULL.  */
    case 624: value = 625; break;	/* fcvtau --> fcvtau.  */
    case 625: return NULL;		/* fcvtau --> NULL.  */
    case 620: value = 621; break;	/* ucvtf --> ucvtf.  */
    case 621: return NULL;		/* ucvtf --> NULL.  */
    case 628: value = 629; break;	/* fmov --> fmov.  */
    case 629: return NULL;		/* fmov --> NULL.  */
    case 656: value = 657; break;	/* fmov --> fmov.  */
    case 657: return NULL;		/* fmov --> NULL.  */
    case 665: value = 666; break;	/* frintn --> frintn.  */
    case 666: return NULL;		/* frintn --> NULL.  */
    case 660: value = 661; break;	/* fneg --> fneg.  */
    case 661: return NULL;		/* fneg --> NULL.  */
    case 669: value = 670; break;	/* frintm --> frintm.  */
    case 670: return NULL;		/* frintm --> NULL.  */
    case 658: value = 659; break;	/* fabs --> fabs.  */
    case 659: return NULL;		/* fabs --> NULL.  */
    case 667: value = 668; break;	/* frintp --> frintp.  */
    case 668: return NULL;		/* frintp --> NULL.  */
    case 662: value = 663; break;	/* fsqrt --> fsqrt.  */
    case 663: return NULL;		/* fsqrt --> NULL.  */
    case 671: value = 672; break;	/* frintz --> frintz.  */
    case 672: return NULL;		/* frintz --> NULL.  */
    case 673: value = 674; break;	/* frinta --> frinta.  */
    case 674: return NULL;		/* frinta --> NULL.  */
    case 675: value = 676; break;	/* frintx --> frintx.  */
    case 676: return NULL;		/* frintx --> NULL.  */
    case 677: value = 678; break;	/* frinti --> frinti.  */
    case 678: return NULL;		/* frinti --> NULL.  */
    case 648: value = 649; break;	/* fcmp --> fcmp.  */
    case 649: return NULL;		/* fcmp --> NULL.  */
    case 650: value = 651; break;	/* fcmpe --> fcmpe.  */
    case 651: return NULL;		/* fcmpe --> NULL.  */
    case 652: value = 653; break;	/* fcmp --> fcmp.  */
    case 653: return NULL;		/* fcmp --> NULL.  */
    case 654: value = 655; break;	/* fcmpe --> fcmpe.  */
    case 655: return NULL;		/* fcmpe --> NULL.  */
    case 705: value = 706; break;	/* fmov --> fmov.  */
    case 706: return NULL;		/* fmov --> NULL.  */
    case 679: value = 680; break;	/* fmul --> fmul.  */
    case 680: return NULL;		/* fmul --> NULL.  */
    case 695: value = 696; break;	/* fnmul --> fnmul.  */
    case 696: return NULL;		/* fnmul --> NULL.  */
    case 687: value = 688; break;	/* fmax --> fmax.  */
    case 688: return NULL;		/* fmax --> NULL.  */
    case 683: value = 684; break;	/* fadd --> fadd.  */
    case 684: return NULL;		/* fadd --> NULL.  */
    case 691: value = 692; break;	/* fmaxnm --> fmaxnm.  */
    case 692: return NULL;		/* fmaxnm --> NULL.  */
    case 681: value = 682; break;	/* fdiv --> fdiv.  */
    case 682: return NULL;		/* fdiv --> NULL.  */
    case 689: value = 690; break;	/* fmin --> fmin.  */
    case 690: return NULL;		/* fmin --> NULL.  */
    case 685: value = 686; break;	/* fsub --> fsub.  */
    case 686: return NULL;		/* fsub --> NULL.  */
    case 693: value = 694; break;	/* fminnm --> fminnm.  */
    case 694: return NULL;		/* fminnm --> NULL.  */
    case 644: value = 645; break;	/* fccmp --> fccmp.  */
    case 645: return NULL;		/* fccmp --> NULL.  */
    case 646: value = 647; break;	/* fccmpe --> fccmpe.  */
    case 647: return NULL;		/* fccmpe --> NULL.  */
    case 707: value = 708; break;	/* fcsel --> fcsel.  */
    case 708: return NULL;		/* fcsel --> NULL.  */
    case 122: value = 303; break;	/* movi --> sshr.  */
    case 303: value = 305; break;	/* sshr --> srshr.  */
    case 305: return NULL;		/* srshr --> NULL.  */
    case 129: value = 323; break;	/* mvni --> ushr.  */
    case 323: value = 325; break;	/* ushr --> urshr.  */
    case 325: value = 327; break;	/* urshr --> sri.  */
    case 327: value = 329; break;	/* sri --> sqshlu.  */
    case 329: return NULL;		/* sqshlu --> NULL.  */
    case 123: value = 304; break;	/* orr --> ssra.  */
    case 304: value = 306; break;	/* ssra --> srsra.  */
    case 306: value = 307; break;	/* srsra --> shl.  */
    case 307: value = 308; break;	/* shl --> sqshl.  */
    case 308: return NULL;		/* sqshl --> NULL.  */
    case 130: value = 324; break;	/* bic --> usra.  */
    case 324: value = 326; break;	/* usra --> ursra.  */
    case 326: value = 328; break;	/* ursra --> sli.  */
    case 328: value = 330; break;	/* sli --> uqshl.  */
    case 330: return NULL;		/* uqshl --> NULL.  */
    case 697: value = 698; break;	/* fmadd --> fmadd.  */
    case 698: return NULL;		/* fmadd --> NULL.  */
    case 701: value = 702; break;	/* fnmadd --> fnmadd.  */
    case 702: return NULL;		/* fnmadd --> NULL.  */
    case 124: value = 309; break;	/* movi --> shrn.  */
    case 309: value = 310; break;	/* shrn --> shrn2.  */
    case 310: value = 317; break;	/* shrn2 --> sshll.  */
    case 317: value = 319; break;	/* sshll --> sshll2.  */
    case 319: return NULL;		/* sshll2 --> NULL.  */
    case 131: value = 331; break;	/* mvni --> sqshrun.  */
    case 331: value = 332; break;	/* sqshrun --> sqshrun2.  */
    case 332: value = 339; break;	/* sqshrun2 --> ushll.  */
    case 339: value = 341; break;	/* ushll --> ushll2.  */
    case 341: return NULL;		/* ushll2 --> NULL.  */
    case 125: value = 313; break;	/* orr --> sqshrn.  */
    case 313: value = 314; break;	/* sqshrn --> sqshrn2.  */
    case 314: return NULL;		/* sqshrn2 --> NULL.  */
    case 132: value = 335; break;	/* bic --> uqshrn.  */
    case 335: value = 336; break;	/* uqshrn --> uqshrn2.  */
    case 336: return NULL;		/* uqshrn2 --> NULL.  */
    case 127: value = 321; break;	/* movi --> scvtf.  */
    case 321: return NULL;		/* scvtf --> NULL.  */
    case 134: value = 135; break;	/* movi --> movi.  */
    case 135: value = 343; break;	/* movi --> ucvtf.  */
    case 343: return NULL;		/* ucvtf --> NULL.  */
    case 699: value = 700; break;	/* fmsub --> fmsub.  */
    case 700: return NULL;		/* fmsub --> NULL.  */
    case 703: value = 704; break;	/* fnmsub --> fnmsub.  */
    case 704: return NULL;		/* fnmsub --> NULL.  */
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const aarch64_opcode *
aarch64_find_alias_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the alias opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 2: value = 3; break;	/* sbc --> ngc.  */
    case 4: value = 5; break;	/* sbcs --> ngcs.  */
    case 7: value = 8; break;	/* adds --> cmn.  */
    case 10: value = 11; break;	/* subs --> cmp.  */
    case 12: value = 13; break;	/* add --> mov.  */
    case 14: value = 15; break;	/* adds --> cmn.  */
    case 17: value = 18; break;	/* subs --> cmp.  */
    case 20: value = 21; break;	/* adds --> cmn.  */
    case 22: value = 23; break;	/* sub --> neg.  */
    case 24: value = 26; break;	/* subs --> negs.  */
    case 140: value = 141; break;	/* umov --> mov.  */
    case 142: value = 143; break;	/* ins --> mov.  */
    case 144: value = 145; break;	/* ins --> mov.  */
    case 205: value = 206; break;	/* not --> mvn.  */
    case 260: value = 261; break;	/* orr --> mov.  */
    case 317: value = 318; break;	/* sshll --> sxtl.  */
    case 319: value = 320; break;	/* sshll2 --> sxtl2.  */
    case 339: value = 340; break;	/* ushll --> uxtl.  */
    case 341: value = 342; break;	/* ushll2 --> uxtl2.  */
    case 436: value = 437; break;	/* dup --> mov.  */
    case 501: value = 506; break;	/* sbfm --> sxtw.  */
    case 508: value = 510; break;	/* bfm --> bfc.  */
    case 512: value = 516; break;	/* ubfm --> uxth.  */
    case 534: value = 536; break;	/* csinc --> cset.  */
    case 537: value = 539; break;	/* csinv --> csetm.  */
    case 540: value = 541; break;	/* csneg --> cneg.  */
    case 559: value = 559; break;	/* rev --> rev.  */
    case 566: value = 567; break;	/* lslv --> lsl.  */
    case 568: value = 569; break;	/* lsrv --> lsr.  */
    case 570: value = 571; break;	/* asrv --> asr.  */
    case 572: value = 573; break;	/* rorv --> ror.  */
    case 582: value = 583; break;	/* madd --> mul.  */
    case 584: value = 585; break;	/* msub --> mneg.  */
    case 586: value = 587; break;	/* smaddl --> smull.  */
    case 588: value = 589; break;	/* smsubl --> smnegl.  */
    case 591: value = 592; break;	/* umaddl --> umull.  */
    case 593: value = 594; break;	/* umsubl --> umnegl.  */
    case 604: value = 605; break;	/* extr --> ror.  */
    case 811: value = 812; break;	/* and --> bic.  */
    case 813: value = 814; break;	/* orr --> mov.  */
    case 816: value = 817; break;	/* ands --> tst.  */
    case 820: value = 822; break;	/* orr --> uxtw.  */
    case 823: value = 824; break;	/* orn --> mvn.  */
    case 827: value = 828; break;	/* ands --> tst.  */
    case 858: value = 954; break;	/* ldaddb --> staddb.  */
    case 859: value = 955; break;	/* ldaddh --> staddh.  */
    case 860: value = 956; break;	/* ldadd --> stadd.  */
    case 862: value = 957; break;	/* ldaddlb --> staddlb.  */
    case 865: value = 958; break;	/* ldaddlh --> staddlh.  */
    case 868: value = 959; break;	/* ldaddl --> staddl.  */
    case 870: value = 960; break;	/* ldclrb --> stclrb.  */
    case 871: value = 961; break;	/* ldclrh --> stclrh.  */
    case 872: value = 962; break;	/* ldclr --> stclr.  */
    case 874: value = 963; break;	/* ldclrlb --> stclrlb.  */
    case 877: value = 964; break;	/* ldclrlh --> stclrlh.  */
    case 880: value = 965; break;	/* ldclrl --> stclrl.  */
    case 882: value = 966; break;	/* ldeorb --> steorb.  */
    case 883: value = 967; break;	/* ldeorh --> steorh.  */
    case 884: value = 968; break;	/* ldeor --> steor.  */
    case 886: value = 969; break;	/* ldeorlb --> steorlb.  */
    case 889: value = 970; break;	/* ldeorlh --> steorlh.  */
    case 892: value = 971; break;	/* ldeorl --> steorl.  */
    case 894: value = 972; break;	/* ldsetb --> stsetb.  */
    case 895: value = 973; break;	/* ldseth --> stseth.  */
    case 896: value = 974; break;	/* ldset --> stset.  */
    case 898: value = 975; break;	/* ldsetlb --> stsetlb.  */
    case 901: value = 976; break;	/* ldsetlh --> stsetlh.  */
    case 904: value = 977; break;	/* ldsetl --> stsetl.  */
    case 906: value = 978; break;	/* ldsmaxb --> stsmaxb.  */
    case 907: value = 979; break;	/* ldsmaxh --> stsmaxh.  */
    case 908: value = 980; break;	/* ldsmax --> stsmax.  */
    case 910: value = 981; break;	/* ldsmaxlb --> stsmaxlb.  */
    case 913: value = 982; break;	/* ldsmaxlh --> stsmaxlh.  */
    case 916: value = 983; break;	/* ldsmaxl --> stsmaxl.  */
    case 918: value = 984; break;	/* ldsminb --> stsminb.  */
    case 919: value = 985; break;	/* ldsminh --> stsminh.  */
    case 920: value = 986; break;	/* ldsmin --> stsmin.  */
    case 922: value = 987; break;	/* ldsminlb --> stsminlb.  */
    case 925: value = 988; break;	/* ldsminlh --> stsminlh.  */
    case 928: value = 989; break;	/* ldsminl --> stsminl.  */
    case 930: value = 990; break;	/* ldumaxb --> stumaxb.  */
    case 931: value = 991; break;	/* ldumaxh --> stumaxh.  */
    case 932: value = 992; break;	/* ldumax --> stumax.  */
    case 934: value = 993; break;	/* ldumaxlb --> stumaxlb.  */
    case 937: value = 994; break;	/* ldumaxlh --> stumaxlh.  */
    case 940: value = 995; break;	/* ldumaxl --> stumaxl.  */
    case 942: value = 996; break;	/* lduminb --> stuminb.  */
    case 943: value = 997; break;	/* lduminh --> stuminh.  */
    case 944: value = 998; break;	/* ldumin --> stumin.  */
    case 946: value = 999; break;	/* lduminlb --> stuminlb.  */
    case 949: value = 1000; break;	/* lduminlh --> stuminlh.  */
    case 952: value = 1001; break;	/* lduminl --> stuminl.  */
    case 1002: value = 1003; break;	/* movn --> mov.  */
    case 1004: value = 1005; break;	/* movz --> mov.  */
    case 1010: value = 1016; break;	/* hint --> sevl.  */
    case 1021: value = 1025; break;	/* sys --> tlbi.  */
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const aarch64_opcode *
aarch64_find_next_alias_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the next opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 3: value = 2; break;	/* ngc --> sbc.  */
    case 5: value = 4; break;	/* ngcs --> sbcs.  */
    case 8: value = 7; break;	/* cmn --> adds.  */
    case 11: value = 10; break;	/* cmp --> subs.  */
    case 13: value = 12; break;	/* mov --> add.  */
    case 15: value = 14; break;	/* cmn --> adds.  */
    case 18: value = 17; break;	/* cmp --> subs.  */
    case 21: value = 20; break;	/* cmn --> adds.  */
    case 23: value = 22; break;	/* neg --> sub.  */
    case 26: value = 25; break;	/* negs --> cmp.  */
    case 25: value = 24; break;	/* cmp --> subs.  */
    case 141: value = 140; break;	/* mov --> umov.  */
    case 143: value = 142; break;	/* mov --> ins.  */
    case 145: value = 144; break;	/* mov --> ins.  */
    case 206: value = 205; break;	/* mvn --> not.  */
    case 261: value = 260; break;	/* mov --> orr.  */
    case 318: value = 317; break;	/* sxtl --> sshll.  */
    case 320: value = 319; break;	/* sxtl2 --> sshll2.  */
    case 340: value = 339; break;	/* uxtl --> ushll.  */
    case 342: value = 341; break;	/* uxtl2 --> ushll2.  */
    case 437: value = 436; break;	/* mov --> dup.  */
    case 506: value = 505; break;	/* sxtw --> sxth.  */
    case 505: value = 504; break;	/* sxth --> sxtb.  */
    case 504: value = 507; break;	/* sxtb --> asr.  */
    case 507: value = 503; break;	/* asr --> sbfx.  */
    case 503: value = 502; break;	/* sbfx --> sbfiz.  */
    case 502: value = 501; break;	/* sbfiz --> sbfm.  */
    case 510: value = 511; break;	/* bfc --> bfxil.  */
    case 511: value = 509; break;	/* bfxil --> bfi.  */
    case 509: value = 508; break;	/* bfi --> bfm.  */
    case 516: value = 515; break;	/* uxth --> uxtb.  */
    case 515: value = 518; break;	/* uxtb --> lsr.  */
    case 518: value = 517; break;	/* lsr --> lsl.  */
    case 517: value = 514; break;	/* lsl --> ubfx.  */
    case 514: value = 513; break;	/* ubfx --> ubfiz.  */
    case 513: value = 512; break;	/* ubfiz --> ubfm.  */
    case 536: value = 535; break;	/* cset --> cinc.  */
    case 535: value = 534; break;	/* cinc --> csinc.  */
    case 539: value = 538; break;	/* csetm --> cinv.  */
    case 538: value = 537; break;	/* cinv --> csinv.  */
    case 541: value = 540; break;	/* cneg --> csneg.  */
    case 559: value = 560; break;	/* rev --> rev64.  */
    case 567: value = 566; break;	/* lsl --> lslv.  */
    case 569: value = 568; break;	/* lsr --> lsrv.  */
    case 571: value = 570; break;	/* asr --> asrv.  */
    case 573: value = 572; break;	/* ror --> rorv.  */
    case 583: value = 582; break;	/* mul --> madd.  */
    case 585: value = 584; break;	/* mneg --> msub.  */
    case 587: value = 586; break;	/* smull --> smaddl.  */
    case 589: value = 588; break;	/* smnegl --> smsubl.  */
    case 592: value = 591; break;	/* umull --> umaddl.  */
    case 594: value = 593; break;	/* umnegl --> umsubl.  */
    case 605: value = 604; break;	/* ror --> extr.  */
    case 812: value = 811; break;	/* bic --> and.  */
    case 814: value = 813; break;	/* mov --> orr.  */
    case 817: value = 816; break;	/* tst --> ands.  */
    case 822: value = 821; break;	/* uxtw --> mov.  */
    case 821: value = 820; break;	/* mov --> orr.  */
    case 824: value = 823; break;	/* mvn --> orn.  */
    case 828: value = 827; break;	/* tst --> ands.  */
    case 954: value = 858; break;	/* staddb --> ldaddb.  */
    case 955: value = 859; break;	/* staddh --> ldaddh.  */
    case 956: value = 860; break;	/* stadd --> ldadd.  */
    case 957: value = 862; break;	/* staddlb --> ldaddlb.  */
    case 958: value = 865; break;	/* staddlh --> ldaddlh.  */
    case 959: value = 868; break;	/* staddl --> ldaddl.  */
    case 960: value = 870; break;	/* stclrb --> ldclrb.  */
    case 961: value = 871; break;	/* stclrh --> ldclrh.  */
    case 962: value = 872; break;	/* stclr --> ldclr.  */
    case 963: value = 874; break;	/* stclrlb --> ldclrlb.  */
    case 964: value = 877; break;	/* stclrlh --> ldclrlh.  */
    case 965: value = 880; break;	/* stclrl --> ldclrl.  */
    case 966: value = 882; break;	/* steorb --> ldeorb.  */
    case 967: value = 883; break;	/* steorh --> ldeorh.  */
    case 968: value = 884; break;	/* steor --> ldeor.  */
    case 969: value = 886; break;	/* steorlb --> ldeorlb.  */
    case 970: value = 889; break;	/* steorlh --> ldeorlh.  */
    case 971: value = 892; break;	/* steorl --> ldeorl.  */
    case 972: value = 894; break;	/* stsetb --> ldsetb.  */
    case 973: value = 895; break;	/* stseth --> ldseth.  */
    case 974: value = 896; break;	/* stset --> ldset.  */
    case 975: value = 898; break;	/* stsetlb --> ldsetlb.  */
    case 976: value = 901; break;	/* stsetlh --> ldsetlh.  */
    case 977: value = 904; break;	/* stsetl --> ldsetl.  */
    case 978: value = 906; break;	/* stsmaxb --> ldsmaxb.  */
    case 979: value = 907; break;	/* stsmaxh --> ldsmaxh.  */
    case 980: value = 908; break;	/* stsmax --> ldsmax.  */
    case 981: value = 910; break;	/* stsmaxlb --> ldsmaxlb.  */
    case 982: value = 913; break;	/* stsmaxlh --> ldsmaxlh.  */
    case 983: value = 916; break;	/* stsmaxl --> ldsmaxl.  */
    case 984: value = 918; break;	/* stsminb --> ldsminb.  */
    case 985: value = 919; break;	/* stsminh --> ldsminh.  */
    case 986: value = 920; break;	/* stsmin --> ldsmin.  */
    case 987: value = 922; break;	/* stsminlb --> ldsminlb.  */
    case 988: value = 925; break;	/* stsminlh --> ldsminlh.  */
    case 989: value = 928; break;	/* stsminl --> ldsminl.  */
    case 990: value = 930; break;	/* stumaxb --> ldumaxb.  */
    case 991: value = 931; break;	/* stumaxh --> ldumaxh.  */
    case 992: value = 932; break;	/* stumax --> ldumax.  */
    case 993: value = 934; break;	/* stumaxlb --> ldumaxlb.  */
    case 994: value = 937; break;	/* stumaxlh --> ldumaxlh.  */
    case 995: value = 940; break;	/* stumaxl --> ldumaxl.  */
    case 996: value = 942; break;	/* stuminb --> lduminb.  */
    case 997: value = 943; break;	/* stuminh --> lduminh.  */
    case 998: value = 944; break;	/* stumin --> ldumin.  */
    case 999: value = 946; break;	/* stuminlb --> lduminlb.  */
    case 1000: value = 949; break;	/* stuminlh --> lduminlh.  */
    case 1001: value = 952; break;	/* stuminl --> lduminl.  */
    case 1003: value = 1002; break;	/* mov --> movn.  */
    case 1005: value = 1004; break;	/* mov --> movz.  */
    case 1016: value = 1015; break;	/* sevl --> sev.  */
    case 1015: value = 1014; break;	/* sev --> wfi.  */
    case 1014: value = 1013; break;	/* wfi --> wfe.  */
    case 1013: value = 1012; break;	/* wfe --> yield.  */
    case 1012: value = 1011; break;	/* yield --> nop.  */
    case 1011: value = 1010; break;	/* nop --> hint.  */
    case 1025: value = 1024; break;	/* tlbi --> ic.  */
    case 1024: value = 1023; break;	/* ic --> dc.  */
    case 1023: value = 1022; break;	/* dc --> at.  */
    case 1022: value = 1021; break;	/* at --> sys.  */
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

int
aarch64_extract_operand (const aarch64_operand *self,
			   aarch64_opnd_info *info,
			   aarch64_insn code, const aarch64_inst *inst)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 9:
    case 10:
    case 14:
    case 15:
    case 16:
    case 17:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 35:
    case 36:
      return aarch64_ext_regno (self, info, code, inst);
    case 8:
      return aarch64_ext_regrt_sysins (self, info, code, inst);
    case 11:
      return aarch64_ext_regno_pair (self, info, code, inst);
    case 12:
      return aarch64_ext_reg_extended (self, info, code, inst);
    case 13:
      return aarch64_ext_reg_shifted (self, info, code, inst);
    case 18:
      return aarch64_ext_ft (self, info, code, inst);
    case 28:
    case 29:
    case 30:
      return aarch64_ext_reglane (self, info, code, inst);
    case 31:
      return aarch64_ext_reglist (self, info, code, inst);
    case 32:
      return aarch64_ext_ldst_reglist (self, info, code, inst);
    case 33:
      return aarch64_ext_ldst_reglist_r (self, info, code, inst);
    case 34:
      return aarch64_ext_ldst_elemlist (self, info, code, inst);
    case 37:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
      return aarch64_ext_imm (self, info, code, inst);
    case 38:
    case 39:
      return aarch64_ext_advsimd_imm_shift (self, info, code, inst);
    case 40:
    case 41:
    case 42:
      return aarch64_ext_advsimd_imm_modified (self, info, code, inst);
    case 43:
      return aarch64_ext_shll_imm (self, info, code, inst);
    case 59:
      return aarch64_ext_limm (self, info, code, inst);
    case 60:
      return aarch64_ext_aimm (self, info, code, inst);
    case 61:
      return aarch64_ext_imm_half (self, info, code, inst);
    case 62:
      return aarch64_ext_fbits (self, info, code, inst);
    case 64:
    case 65:
      return aarch64_ext_cond (self, info, code, inst);
    case 71:
    case 77:
      return aarch64_ext_addr_simple (self, info, code, inst);
    case 72:
      return aarch64_ext_addr_regoff (self, info, code, inst);
    case 73:
    case 74:
    case 75:
      return aarch64_ext_addr_simm (self, info, code, inst);
    case 76:
      return aarch64_ext_addr_uimm12 (self, info, code, inst);
    case 78:
      return aarch64_ext_simd_addr_post (self, info, code, inst);
    case 79:
      return aarch64_ext_sysreg (self, info, code, inst);
    case 80:
      return aarch64_ext_pstatefield (self, info, code, inst);
    case 81:
    case 82:
    case 83:
    case 84:
      return aarch64_ext_sysins_op (self, info, code, inst);
    case 85:
    case 86:
      return aarch64_ext_barrier (self, info, code, inst);
    case 87:
      return aarch64_ext_prfop (self, info, code, inst);
    default: assert (0); abort ();
    }
}
