//=========================================================================
///	<summary>
///		mAgicAnimedǗW[
///	</summary>
/// <remarks>
/// </remarks>
/// <history>2006/XX/XX VK쐬</history>
/// <history>2010/05/01 SubversionŊǗ邽ߕsvȃRg폜</history>
//=========================================================================
//#define	BOOTTIMER_RESTART_ALWAYS	// Schedule.iniɃANZX鎞ABootTimerċN
										// (BootTimerLᔽG[ɂȂ̂h~邽)
#define		BOOTTIMER_SUSPEND			// LᔽG[h~邽BootTimerTXyh

using System;
using System.Collections.Generic;
using System.IO;
using System.Threading;
using System.Text;
using System.Runtime.InteropServices;
using System.Diagnostics;
using magicAnime.Properties;
using KernelAPI;

namespace magicAnime
{
	//=========================================================================
	///	<summary>
	///		PCNǗNX
	///	</summary>
	/// <remarks>
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	//=========================================================================
	public class BootManager
	{
		// BootTimer(1.407ȍ~)䃁bZ[W
		const int	BT_MESSAGE_SCHEDULE_UPDATE	= 1125;		// XPW[ēǂݍ
		const int	BT_MESSAGE_CLOSE			= 1126;		// BootTimer

		const int	BootTimerClosingTimeOut = 3000;	// BootTimerI^CAEg

		//=========================================================================
		///	<summary>
		///		ԑуNX
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public class TimeZone
		{
			public DateTime startDateTime;
			public DateTime endDateTime;
			public string	comment;

			// ԑт̃I[o[bv
			public bool IsOverlap(TimeZone target)
			{
				bool a, b;

				a = (this.startDateTime < target.startDateTime)
					&& (this.endDateTime < target.startDateTime);
				b = (target.startDateTime < this.startDateTime)
					&& (target.endDateTime < this.startDateTime);

				return !(a||b);
			}
		}

		//=========================================================================
		///	<summary>
		///		ԑєrRp[^
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public class ITimeZoneComparer : IComparer<TimeZone>
		{
			public int Compare(TimeZone a, TimeZone b)
			{
				if (a.startDateTime == b.startDateTime) return 0;
				return a.startDateTime > b.startDateTime ? 1 : -1;
			}

		}

		//-------------------
		// oϐ
		//-------------------
		const int		maxScheduleCount	= 255;
		List<TimeZone>	timeZoneList;

		//=========================================================================
		///	<summary>
		///		RXgN^
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public BootManager()
		{
			timeZoneList = new List<TimeZone>();
		}

		public void Clear()
		{
			timeZoneList.Clear();
		}

		//=========================================================================
		///	<summary>
		///		PCN`Vbg_E鎞ԑтǉ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Add(
			DateTime bootupDateTime,
			DateTime shutdownDateTime,
			string	comment)
		{
			TimeZone timeZone = new TimeZone();

			if (shutdownDateTime < bootupDateTime)
				throw new Exception("G[: shutdownDateTime < bootupDateTime");

			timeZone.startDateTime	= bootupDateTime;
			timeZone.endDateTime	= shutdownDateTime;
			timeZone.comment		= comment;

			timeZoneList.Add( timeZone );
		}

		public void Sort(ITimeZoneComparer comparer)
		{
			timeZoneList.Sort( comparer );
		}

		//=========================================================================
		///	<summary>
		///		ߐڂNԑт܂Ƃ߂
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Unification()
		{

			if ( timeZoneList.Count < 2 ) return;
			//Properties.Settings.Default.bootupTimeUnification;

			for (int i = 0; i < timeZoneList.Count; ++i)
			{
				uint interval; // [ms]
				TimeZone zone		= timeZoneList[i];
				TimeZone nextZone;

				if (i < timeZoneList.Count - 1)
					nextZone = timeZoneList[i + 1];
				else
					nextZone = timeZoneList[0];

				if (zone.IsOverlap(nextZone))
				{
					//-----------------------------
					// dĂ鎞ԑт𓝍
					//-----------------------------

					timeZoneList.Remove(zone);
					timeZoneList.Remove(nextZone);

					// IԂnextZone̕ꍇ邽
					DateTime endTime	= zone.endDateTime < nextZone.endDateTime
										? nextZone.endDateTime
										: zone.endDateTime;

	 				Add(zone.startDateTime,
						endTime,
						zone.comment + " " + nextZone.comment);

					timeZoneList.Sort(new ITimeZoneComparer());

					Unification();

					break;
				}
				else
				{
					//----------------------------------------
					// ̋NԂ܂ň莞ԈȉȂ瓝
					//----------------------------------------

					interval = (uint)((nextZone.startDateTime.Ticks
										- zone.endDateTime.Ticks) / 10000000);

					if (interval < Properties.Settings.Default.bootupTimeUnification * 60)
					{
						timeZoneList.Remove(zone);
						timeZoneList.Remove(nextZone);

						Add(zone.startDateTime,
							nextZone.endDateTime,
							zone.comment + " " + nextZone.comment);

						timeZoneList.Sort(new ITimeZoneComparer());

						Unification();

						break;
					}
				}

			}

		}

		//=========================================================================
		///	<summary>
		///		BootTimerɋNXPW[o^
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void ApplyBootTimer(
			DateTime now )	// [i] ݎ(ɉ߂XPW[͖)
		{
			List<string> list = new List<string>();
			string	bootTimer, iniFile;
			bool	isModified = false;

			IntPtr	hWindow;

			if( !CheckBootTimer( out hWindow, out bootTimer ) )
			{
				throw new UpdatingException("BootTimer풓Ă܂");
			}


			// }`u[gΉ
			string	multiBootIniPath;
			multiBootIniPath = Path.Combine( Path.GetDirectoryName(bootTimer), @"MultiBoot.ini" );

			if( File.Exists( multiBootIniPath ) )
			{
				PrivateProfile prof = new PrivateProfile();
				prof.Open( multiBootIniPath );
				iniFile = prof.GetKeyString( "MultiBoot", "Path", "" );
				if( !string.IsNullOrEmpty( iniFile ) )
					iniFile = Path.Combine( iniFile, @"Schedule.ini" );
			}
			else
			{
				iniFile = Path.Combine( Path.GetDirectoryName(bootTimer), @"Schedule.ini" );
			}

#if _DEBUG
			Logger.Output("(DEBUG)INIt@C:" + iniFile);
#endif
			if( string.IsNullOrEmpty( iniFile ) ||
				!File.Exists( iniFile ) )
			{
				throw new UpdatingException("Schedule.iniJ܂B");
			}

#if BOOTTIMER_RESTART_ALWAYS
			if( !StopBootTimer( hWindow, BootTimerClosingTimeOut ) )
				throw new UpdatingException("BootTimer̒~Ɏs");
#else
#if BOOTTIMER_SUSPEND
			//--------------------------
			// BootTimerTXyh
			//--------------------------
			int			btmrPid = 0;
			Process		btmrProc;

			KernelAPI.Window.GetWindowThreadProcessId(hWindow, out btmrPid);
			btmrProc = Process.GetProcessById(btmrPid);

			if( btmrProc == null || string.IsNullOrEmpty(btmrProc.ProcessName) )
				throw new UpdatingException("BootTimer풓Ă܂B");

			KernelAPI.WinThread.SuspendResumeAllThread(btmrProc, true);
#endif
#endif
			try
			{
				PrivateProfile profile = new PrivateProfile();
				profile.Open( iniFile );

				//-----------------------------------------
				// mAgicAnimeŊǗȂGgޔ
				//-----------------------------------------
				var	registedEntries = new List<string>(); // mAgicAnimeœo^Gg

				for (uint i = 0; i < maxScheduleCount; ++i)
				{
					string temp;
					string text;
					
					text = string.Format("Schedule{0:0}", i);	// L[
					temp = profile.GetKeyString("Schedule", text, "");
					
					if (temp.Equals(""))
						break;
					else
					{
						if( temp.IndexOf("<mAgicAnime>") == -1 )
							list.Add( temp );
						else
							registedEntries.Add( temp );
					}
				}

				//----------------------------
				// XPW[Ggǉ
				//----------------------------
				var	newEntries = new List<string>();	// o^Gg

				foreach (TimeZone timeZone in timeZoneList)
				{
					string text;

					//-------------------
					// NGg
					//-------------------
					if( Settings.Default.autoBootup )
					{
						DateTime dateTime = timeZone.startDateTime;
						string   comment  = timeZone.comment;
						if (now < dateTime)
						{
							// NԂi߂
							dateTime = dateTime.AddMinutes( -(double)Settings.Default.bootupHasten );

							// NGg(BootTimer 1.407Ή)
							//< >,<I>,<Jԏ>,<(gp)>,<CER}h>,<TuER}h>,
@							// <O[v>,<(gp)>,<(gp)>,<svO>,<>,<l>
							text = dateTime.ToShortDateString() + " " + dateTime.ToShortTimeString() + ":00,";
							text += dateTime.ToShortDateString() + " " + dateTime.ToShortTimeString() + ":00,";
							text += "00000,,0,0,100,,,,,<mAgicAnime>" + comment;
							
							newEntries.Add( text );
						}
					}

					//------------------------
					// Vbg_EGg
					//------------------------
					if( Settings.Default.autoShutdown )
					{
						DateTime dateTime = timeZone.endDateTime;
						string   comment  = timeZone.comment;
						if (now < dateTime)
						{
							// IԂx点
							dateTime = dateTime.AddMinutes( (double)Settings.Default.shutdownPutoff );

							// Vbg_EGg(+I@)
							string dateFormat = "yyyy/MM/dd";
							string timeFormat = "HH:mm";
							text =  dateTime.ToString(dateFormat) + " " + dateTime.ToString(timeFormat) + ":00,";
							text += dateTime.ToString(dateFormat) + " " + dateTime.ToString(timeFormat) + ":00,";
							text += string.Format(
								"00000,,1,{0:0},100,,,,,<mAgicAnime>" + comment ,
								Properties.Settings.Default.shutdownMethod	);
							
							newEntries.Add( text );
						}
					}
				}

				// ύX邩
				if( newEntries.Count == registedEntries.Count )
				{
					try
					{
						for( int i =0 ; i < newEntries.Count ; ++i )
						{
							string newEntry = newEntries[i];
							string regEntry = registedEntries[i];

							DateTime ns = DateTime.Parse( newEntry.Split(',')[0] );
							DateTime ne = DateTime.Parse( newEntry.Split(',')[1] );
							DateTime rs = DateTime.Parse( regEntry.Split(',')[0] );
							DateTime re = DateTime.Parse( regEntry.Split(',')[1] );

							isModified	|= (ns != rs)
										|| (ne != re);
						}
					}
					catch(Exception ex)
					{
						isModified = true;
					}
				}
				else
				{
					isModified = true;
				}

				newEntries.ForEach( entry => list.Add( entry ) );

				//----------------
				// INIɏ߂
				//----------------
				if( isModified )
				{
#if !BOOTTIMER_RESTART_ALWAYS && !BOOTTIMER_SUSPEND
					// BootTimerċN
					if( !StopBootTimer( hWindow, BootTimerClosingTimeOut ) )
						throw new UpdatingException("BootTimer̒~Ɏs");
#endif
					for (int i = 0; i < maxScheduleCount; ++i)
					{
						string keyName;

						keyName = string.Format("Schedule{0:0}", i);	// L[

						profile.WriteKeyString(
							"Schedule"							,
							keyName								,
							(i < list.Count) ? list[i] : null	);
					}

#if !BOOTTIMER_RESTART_ALWAYS && !BOOTTIMER_SUSPEND
					RestartBootTimer( bootTimer );
#endif
					
//#if _DEBUG
					Logger.Output("(BootTimer)NXPW[𔽉f");
//#endif
				}
				else
				{
//#if _DEBUG
					Logger.Output("(BootTimer)NXPW[ύXȂ");
//#endif
				}

				profile.Close();
			}
			catch(Exception ex)
			{
				throw;
			}
			finally
			{
#if BOOTTIMER_RESTART_ALWAYS
			RestartBootTimer( bootTimer );
#endif
#if BOOTTIMER_SUSPEND
			// BootTimerW[
			KernelAPI.WinThread.SuspendResumeAllThread(btmrProc, false);
#endif
			}

#if BOOTTIMER_SUSPEND
			// XPW[ēǂݍ݂
			if( isModified  )
				Window.SendMessage(
					hWindow	,
					BT_MESSAGE_SCHEDULE_UPDATE ,
					IntPtr.Zero	,
					IntPtr.Zero	);
#endif

		}

		//=========================================================================
		///	<summary>
		///		BootTimeȑ풓mF
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2010/01/30 StopBootTimerƕ</history>
		//=========================================================================
		private bool CheckBootTimer(
			out IntPtr	hChild		,
			out string	filePath	)
		{
			IntPtr	hWindow;
			Process	bootTimerProcess;
			int		processId;

			hChild		= IntPtr.Zero;
			filePath	= null;

			try
			{
				//---------------------------
				// BootTimer̃vZXT
				//---------------------------

				// BootTimerMainFormT
				hChild = (IntPtr)Window.FindWindowEx(
					IntPtr.Zero			,
					IntPtr.Zero			,
					null				,
					"BootTimerMainForm"	);

				if( hChild == IntPtr.Zero )
					return false;

				//=======================================
				// EBhEst@CpX𓾂
				//=======================================
				Window.GetWindowThreadProcessId(hChild, out processId);

				bootTimerProcess	= Process.GetProcessById(processId);
				filePath			= bootTimerProcess.MainModule.FileName;

				return true;
			}
			catch(Exception ex)
			{
			}
			return false;
		}

		//=========================================================================
		///	<summary>
		///		BootTimerUI
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2010/01/30 StopBootTimerƕ</history>
		//=========================================================================
		private bool StopBootTimer(
			IntPtr	hWindow	,
			int		timeOut	)	// <ADD> 2010/04/22
		{
			//=======================================
			// BootTimer
			//=======================================
            Window.SendMessage(
                hWindow				,
                BT_MESSAGE_CLOSE	,
                IntPtr.Zero			,
                IntPtr.Zero			);

#if BOOTTIMER_CLOSE_WAIT
// <ADD> 2010/04/22 ۂɏÎҋ@ ->
			int			procID;
			DateTime	startTime = DateTime.Now;

			for(;;)
			{
				Window.GetWindowThreadProcessId(hWindow, out procID);

				if( procID == 0 )
					break;

				if( timeOut <= DateTime.Now.Subtract(startTime).TotalMilliseconds )
					return false;

				Thread.Sleep(50);
			}
// <ADD> 2010/04/22 <-
#endif

			return true;
		}


		//=========================================================================
		///	<summary>
		///		BootTimerN
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		static void RestartBootTimer(string filePath)
		{
			if( string.IsNullOrEmpty( filePath ) )
				return;

			try
			{
				Process proc = Process.Start(filePath);
				// 肷܂ő҂ȂƘAXVBootTimer
				proc.WaitForInputIdle();
			}
			catch (Exception)
			{
			}
		}

		
	}

}
