//=========================================================================
///	<summary>
///		AnimeProgramXg̃\[gRyANX
///	</summary>
/// <remarks>
/// </remarks>
/// <history>2019/11/24 VK쐬</history>
//=========================================================================
using System;
using System.Collections.Generic;
using magicAnime.Properties;

namespace magicAnime
{
    //=========================================================================
    ///	<summary>
    ///		AnimeProgramXg̃\[gRyANX
    ///	</summary>
    /// <remarks>
    /// </remarks>
    /// <history>2019/11/24 VK쐬</history>
    //=========================================================================
    class AnimeSortMod : AnimeSort
    {
        private const int SECONDS_OF_DAY = 86400;
        private const int SECONDS_OF_HOUR = 3600;
        private const int HOURS_OF_DAY = 24;
        private const int DAYS_OF_WEEK = 7;

        private const long TICKS_OF_SECOND = 10000000;

        //=========================================================================
        ///	<summary>
        ///		RXgN^
        ///	</summary>
        /// <remarks>
        /// </remarks>
        /// <history>2019/11/24 VK쐬</history>
        //=========================================================================
        public AnimeSortMod(Order order, OrderOption option) : base(order, option)
        {
        }

        //=========================================================================
        ///	<summary>
        ///		AnimeProgramOXLă\[g\l肷
        ///	</summary>
        ///	<param name="p">ԑg</param>
        ///	<param name="baseTime">\[g</param>
        /// <remarks>
        /// </remarks>
        /// <history>2019/11/24 VK쐬</history>
        //=========================================================================
        public override void PreScan(AnimeProgram p, DateTime baseTime)
        {
            p.mSortRepresentative = DateTime.MaxValue;

            // b0̏ꍇ͑Oɉ
            if ( (p.StoryCount == 0) && (p.SpecialStoryCount == 0) )
            {
                p.mSortRepresentative = DateTime.MinValue;
                return;
            }

            switch (order)
            {
                // jƎ̕ςɃ\[g
                case Order.DayOfWeek:
                    PreScanDayOfWeek(p, baseTime);
                    break;
                // ̕Ń\[g
                default:
                case Order.NextOnair:
                    PreScanNextOnAir(p, baseTime);
                    break;
            }
        }

        private void PreScanDayOfWeek(AnimeProgram p, DateTime baseTime)
        {
            //--------------------------
            // \[gȍ~̕擾
            //iJnȍ~łΊ܂߂j
            //--------------------------
            List<AnimeEpisode> normals = p.NormalEpisodes.FindAll(e => e.HasPlan && e.StartDateTime >= baseTime);
            List<AnimeEpisode> specials = p.SpecialEpisodes.FindAll(e => e.HasPlan && e.StartDateTime >= baseTime);

            // ʏ񂪑݂
            if (normals.Count > 0)
            {
                // ŐV13b݂̂Ŕfꍇ
                if ((orderOption & OrderOption.Limit1CoursOption) != 0)
                {
                    // ʏ14bȏ゠ΐ擪̗]ȕ폜
                    if (normals.Count > 13)
                    {
                        normals.Sort(comp);
                        normals.RemoveRange(0, normals.Count - 13);
                    }
                }

                // ʏ݂̂ŗjƎ̕ςƂ
                long ticks = 0;
                normals.ForEach(e => ticks += ModuloDateTimeOfWeek(e));
                p.mSortRepresentative = new DateTime(ticks / normals.Count * TICKS_OF_SECOND);
            }
            // ԉ̂ݑ݂
            else if (specials.Count > 0)
            {
                // ȍ~ōłԉ̕Jn\lƂ
                // ԉ݂̂̕bō\ꍇAς炸\B
                specials.Sort(comp);
                p.mSortRepresentative = specials[0].StartDateTime;
            }
            // I𖖔ɉ
            else
            {
                AnimeEpisode last = LastEpicode(p);

                // I𖖔ɉ
                if ((orderOption & OrderOption.LastOrder) != 0)
                {
                    // IԍŌɕꂽԂŖɕׂ
                    p.mSortRepresentative = last.StartDateTime;
                    return;
                }
                // ԍŌɕꂽjƎŕׂ
                else
                {
                    p.mSortRepresentative = new DateTime(ModuloDateTimeOfWeek(last) * TICKS_OF_SECOND);
                }
            }
        }

        private void PreScanNextOnAir(AnimeProgram p, DateTime baseTime)
        {
            // ̕
            AnimeEpisode ep;
            AnimeProgram.NextEpisode epType = p.GetNextEpisode(baseTime, out ep);

            // ̕񂪑݂Ȃ
            if (epType != AnimeProgram.NextEpisode.NextDecided)
            {
                // ԍŌɕꂽI
                ep = LastEpicode(p);

                // I𖖔ɉ
                if ((orderOption & OrderOption.LastOrder) != 0)
                {
                    // IԍŌɕꂽԂŖɕׂ
                    // Jn100N𑫂̂\lƂ
                    p.mSortRepresentative = ep.StartDateTime.AddYears(100);
                    return;
                }
            }

            // 擾̕Jn\[g\lƂ
            p.mSortRepresentative = ep.StartDateTime;
        }

        private static long ModuloDateTimeOfWeek(AnimeEpisode e)
        {
            long shiftDayOfWeek = 1;
            return (e.StartDateTime.Ticks / TICKS_OF_SECOND
                    - (Settings.Default.hoursPerDay - HOURS_OF_DAY) * SECONDS_OF_HOUR + SECONDS_OF_DAY * shiftDayOfWeek)
                            % (SECONDS_OF_DAY * DAYS_OF_WEEK);
        }

        private static AnimeEpisode LastEpicode(AnimeProgram p)
        {
            List<AnimeEpisode> episodes = p.Episodes;
            episodes.Sort(comp);

            return episodes[episodes.Count - 1];
        }

        private static Comparison<AnimeEpisode> comp = (x, y) => x.StartDateTime.CompareTo(y.StartDateTime);

        //=========================================================================
        ///	<summary>
        ///		AnimeProgram̕ԃRyA
        ///	</summary>
        /// <remarks>
        /// </remarks>
        /// <history>2019/11/24 VK쐬</history>
        //=========================================================================
        public override int Compare(AnimeProgram x, AnimeProgram y)
        {
            return x.mSortRepresentative.CompareTo(y.mSortRepresentative);
        }
    }
}
