//=========================================================================
///	<summary>
///		mAgicAnimeԑgf[^ W[
///	</summary>
/// <remarks>
/// </remarks>
/// <history>2006/XX/XX VK쐬 Dr.Kurusugawa</history>
/// <history>2010/05/01 SubversionŊǗ邽ߕsvȃRg폜</history>
//=========================================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Text;
using System.IO;
using System.Threading;
using System.Windows.Forms;
using System.Collections;
using System.Runtime.InteropServices;
using System.Drawing.Imaging;
using KernelAPI;
using MakeThumbnail;
using magicAnime.Properties;

namespace magicAnime
{
	//=========================================================================
	///	<summary>
	///		mAgicAnimeԑgf[^ NX
	///	</summary>
	/// <remarks>
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	/// <history>2009/04/30 ^erǂƂڂerǂʂɂ</history>
	//=========================================================================
	public class AnimeProgram
	{
		//---------------------
		// f[^o
		//---------------------
		public class EpisodeList : List<AnimeEpisode> { };

		public		string		title;
		public		 bool		linkOnlineDatabase;	// ICf[^x[X(ڂ)ƘA
		public		int			syoboiTid;			// ڂTID
		public		string		tvStation;			// ^erǖ(^\tg֓nǖ)
		public		string		syoboiTvStation;	// ڂerǖ(f[^߂̋ǖ)
		public		bool		WithoutPower;		// dǗ珜O
		public		long		adjustStartTime		= 0;		// ^Jn+n[]
		public		long		adjustEndTime		= 0;		// ^I+n[]

		// ڂf[^I|V
		public enum SyobocalPolicy
		{
			SpecifyLatest,			// łɕf[^I
			SpecifyNumber,			// nڂ̕f[^I
			SpecifyEarly			// ݂łf[^I
		};

		public		SyobocalPolicy			syobocalPolicy			= SyobocalPolicy.SpecifyEarly;
		// f[^n
		public		int						syobocalSpecifyNumber	= 1;
		public int							priority				= 30;	// Dx(Œ10`ō50)
		public bool							enableFilterKeyword		= false;	// ^t@Cw蕶ŃtB^
		public string						filterKeyword			= "";		// tB^
        // add yossiepon 20191124 begin
        public DateTime                     mSortRepresentative;            // \[gɎgp\
        // add yossiepon 20191124 end

        private int							mStoryCount;
        // add yossiepon 20160806 begin
        private int                         mSpecialStoryCount;
        // add yossiepon 20160806 end
		private	uint						mHashCode			= 0;
		private	AnimeServer					mParent;
		private bool						mIsDirty			= false;	// ύXtO

		private List<Scheduler.Profile>		mSchedulerProfiles;
		private Type						mEncoderType		= null;		// GR[_NXType
		private EncodeProfile				mEncoderProfile		= null;		// GR[_ݒ
		private EpisodeList					mEpisodes;						// ̔ԑg̕Ԃꂽeb(Episode)̏W
        // add yossiepon 20160806 begin
		private EpisodeList					mSpecialEpisodes;				// ̔ԑg̕ԂĂȂeb(Episode)̏W
        // add yossiepon 20160806 end
		private	Mutex						mEpisodeLock		= new Mutex();
		private DateTime					mLastUpdate;                    // f[^x[X̍ŏIXV
        private Image						mThambnailImage		= null;
		private Mutex						mThambnailLock		= new Mutex();


		//=========================================================================
		///	<summary>
		///		RXgN^
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public AnimeProgram( AnimeServer parent )
		{
			this.mParent			= parent;
			this.title				= "";
			this.mStoryCount		= 0;
			this.linkOnlineDatabase	= true;
			this.syoboiTid			= 0;
			this.mLastUpdate		= new DateTime(2000, 1, 1);
			this.mSchedulerProfiles = new List<Scheduler.Profile>();
			this.WithoutPower		= false;

			this.mIsDirty			= true;
		}


		//=========================================================================
		///	<summary>
		///		eIuWFNgԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public		AnimeServer		Parent
		{
			get	{	return mParent; }
		}

		//=========================================================================
		///	<summary>
		///		ύXtO
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal bool Dirty
		{
			get
			{
				bool childDirty = false;

				try
				{
					mEpisodeLock.WaitOne();
					foreach (AnimeEpisode episode in mEpisodes)
						childDirty |= episode.Dirty;
                    // add yossiepon 20160806 begin
                    foreach (AnimeEpisode episode in mSpecialEpisodes)
                        childDirty |= episode.Dirty;
                    // add yossiepon 20160806 end
				}
				finally
				{
					mEpisodeLock.ReleaseMutex();
				}

				return childDirty | mIsDirty;
			}
			set
			{
				if (!value)
				{
					try
					{
						mEpisodeLock.WaitOne();
						foreach (AnimeEpisode episode in mEpisodes)
							episode.Dirty = false;
                        // add yossiepon 20160806 begin
                        foreach (AnimeEpisode episode in mSpecialEpisodes)
                            episode.Dirty = false;
                        // add yossiepon 20160806 end
					}
					finally
					{
						mEpisodeLock.ReleaseMutex();
					}
				}
				mIsDirty = value;
			}
		}

		//=========================================================================
		///	<summary>
		///		b̎擾ƕύX
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public int		StoryCount
		{
			get { return mStoryCount; }
			set
			{
				int i;

				try
				{
					mEpisodeLock.WaitOne();

					this.mIsDirty = true;

					if( mEpisodes == null )
					{
						mEpisodes = new EpisodeList();
					}

					//-----------------------------------
					// EpisodeXgbɂ킹Ċg
					//-----------------------------------
					if( mStoryCount < value )
					{
						for( i = mStoryCount ; i < value ; ++i )
						{
							mEpisodes.Add(new AnimeEpisode(this, i + 1));
						}
					}
					else
					{
						for( i = mStoryCount ; value < i ; --i )
						{
							mEpisodes.RemoveAt( i - 1 );
						}
					}

					mStoryCount = value;
				}
				finally
				{
					mEpisodeLock.ReleaseMutex();
				}
			}
		}

        // add yossiepon 20160806 begin
        //=========================================================================
        ///	<summary>
        ///		b̎擾ƕύX
        ///	</summary>
        /// <remarks>
        /// </remarks>
        /// <history>2006/XX/XX VK쐬</history>
        //=========================================================================
        public int SpecialStoryCount
        {
            get { return mSpecialStoryCount; }
            set
            {
                int i;

                try
                {
                    mEpisodeLock.WaitOne();

                    this.mIsDirty = true;

                    if (mSpecialEpisodes == null)
                    {
                        mSpecialEpisodes = new EpisodeList();
                    }

                    //-----------------------------------
                    // EpisodeXgbɂ킹Ċg
                    //-----------------------------------
                    if (mSpecialStoryCount < value)
                    {
                        for (i = mSpecialStoryCount; i < value; ++i)
                        {
                            mSpecialEpisodes.Add(new AnimeEpisode(this, -(i + 1)));
                        }
                    }
                    else
                    {
                        for (i = mSpecialStoryCount; value < i; --i)
                        {
                            mSpecialEpisodes.RemoveAt(i - 1);
                        }
                    }

                    mSpecialStoryCount = value;
                }
                finally
                {
                    mEpisodeLock.ReleaseMutex();
                }
            }
        }
        // add yossiepon 20160806 end

		//=========================================================================
		///	<summary>
		///		ԑgƂ̘^ݒ
		///	</summary>
		/// <remarks>
		///		(XPW[Ƃɐݒێ)
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public Scheduler.Profile SchedulerProfile( Type profType )
		{
			if (profType == null)
				return null;

			if (!profType.IsSubclassOf(typeof(Scheduler.Profile)))
				throw new Exception();

			foreach ( Scheduler.Profile prof in mSchedulerProfiles )
			{
				if ( prof.GetType() == profType )
					return prof;
			}

			// ȂΒǉ
			Scheduler.Profile newProf = Activator.CreateInstance( profType ) as Scheduler.Profile;
			if ( newProf != null )
			{
				mSchedulerProfiles.Add( newProf );
				return newProf;
			}
			return null;
		}

		//=========================================================================
		///	<summary>
		///		GR[_ʂԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public Type EncoderType
		{
			get { return mEncoderType; }
			set
			{
				if (value != null)
				{
					Encoder encoder;

					if (value != mEncoderType)
					{
						encoder = (Encoder)Activator.CreateInstance(value);

						// GR[_ύXꂽvt@CIuWFNg蒼
						mEncoderProfile = (EncodeProfile)Activator.CreateInstance(encoder.ProfileType);
						mEncoderType = value;
					}
				}
				else {
					mEncoderProfile = null;
					mEncoderType = null;
				}
			}
		}

		//=========================================================================
		///	<summary>
		///		GR[_vt@CԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public EncodeProfile EncoderProfile
		{
			get{ return mEncoderProfile; }
			set
			{
				if (value != null)
				{
					Encoder encoder;

					encoder = (Encoder)Activator.CreateInstance(EncoderType);

					if (value.GetType() != encoder.ProfileType)
						throw new Exception("G[: EncoderProfileقȂ܂B");
				}
				mEncoderProfile = value;
			}
		}

		//=========================================================================
		///	<summary>
		///		SGs\[h̃XgԂ
		///	</summary>
		/// <remarks>
		///		XgIuWFNg̃Rs[ԂB
		///		ʂXgύXẴf[^ɉeȂB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public EpisodeList Episodes
		{
			get
			{
				try
				{
					mEpisodeLock.WaitOne();

					EpisodeList coppied = new EpisodeList();
					
                    foreach (AnimeEpisode ep in mEpisodes)
                        coppied.Add(ep);
                    // add yossiepon 20160806 begin
                    foreach (AnimeEpisode ep in mSpecialEpisodes)
                        coppied.Add(ep);
                    // add yossiepon 20160806 end

                    return coppied;
                }
                finally
                {
                    mEpisodeLock.ReleaseMutex();
                }
            }
        }

        // add yossiepon 20160924 begin
        //=========================================================================
        ///	<summary>
        ///		ʏGs\[h̃XgԂ
        ///	</summary>
        /// <remarks>
        ///		XgIuWFNg̃Rs[ԂB
        ///		ʂXgύXẴf[^ɉeȂB
        /// </remarks>
        /// <history>2006/XX/XX VK쐬</history>
        //=========================================================================
        public EpisodeList NormalEpisodes
        {
            get
            {
                try
                {
                    mEpisodeLock.WaitOne();

                    EpisodeList coppied = new EpisodeList();

                    foreach (AnimeEpisode ep in mEpisodes)
                        coppied.Add(ep);

					return coppied;
				}
				finally
				{
					mEpisodeLock.ReleaseMutex();
				}
			}
		}

		//=========================================================================
		///	<summary>
        ///		ԃGs\[h̃XgԂ
        ///	</summary>
        /// <remarks>
        ///		XgIuWFNg̃Rs[ԂB
        ///		ʂXgύXẴf[^ɉeȂB
        /// </remarks>
        /// <history>2006/XX/XX VK쐬</history>
        //=========================================================================
        public EpisodeList SpecialEpisodes
        {
            get
            {
                try
                {
                    mEpisodeLock.WaitOne();

                    EpisodeList coppied = new EpisodeList();

                    foreach (AnimeEpisode ep in mSpecialEpisodes)
                        coppied.Add(ep);

                    return coppied;
                }
                finally
                {
                    mEpisodeLock.ReleaseMutex();
                }
            }
        }
        // add yossiepon 20160924 end

        //=========================================================================
        ///	<summary>
		///		ԑgŗLIDԂ
		///	</summary>
		/// <remarks>
		///		ڂTIDƂ͈قȂ
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public uint UniqueID
		{
			get
			{
				if (mHashCode == 0)
				{
					Guid newGuid = System.Guid.NewGuid();
					mHashCode = (uint)newGuid.GetHashCode();
				}

				return mHashCode;
			}
		}

		//=========================================================================
		///	<summary>
		///		ŏIXVԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public DateTime LastUpdate
		{
			get { return mLastUpdate; }
		}

		//=========================================================================
		///	<summary>
		///		TlCppXԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		// 
		static internal string ThambnailPath
		{
			get
			{
                return Path.Combine( Program.AppDataPath, "Thumbnails" );
			}
		}

		//=========================================================================
		///	<summary>
		///		TlCt@CԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal string ThambnailFile
		{
			get
			{
				return ThambnailPath + @"\" + this.UniqueID.ToString() + ".png";
			}
		}

		//=========================================================================
		///	<summary>
		///		TlCC[WTCYԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal Size ThambnailSize
		{
			get
			{
				return new Size(120,90);
			}
		}

		//=========================================================================
		///	<summary>
		///		TlCC[WԂ
		///	</summary>
		/// <remarks>
		///		TlC͔ԑgƂɒP̃t@Cŕێ
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2010/01/02 C[W쐬̏ꍇnullԂ</history>
		//=========================================================================
		public Image ThambnailImage
		{
			get
			{
				if( mThambnailLock.WaitOne( 0 ) )
				{
					try
					{
						if (mThambnailImage!=null)
							return mThambnailImage;

						//-----------------------------
						// TlCi[tH_
						//-----------------------------
						if (!Directory.Exists( ThambnailPath ))
							Directory.CreateDirectory( ThambnailPath );

						//-------------------------
						// TlCt@C
						//-------------------------
						if( File.Exists(ThambnailFile))
						{
							//------------------------
							// K̃t@CJ
							//------------------------
							mThambnailImage = new Bitmap( ThambnailFile );
						}
						else
						{
							//---------------
							// VK쐬
							//---------------
							mThambnailImage = new Bitmap(1, 1);
							mThambnailImage.Save(
								ThambnailFile							,
								System.Drawing.Imaging.ImageFormat.Png	);	// pngŕۑ

							foreach( AnimeEpisode episode in Episodes )
							{
								episode.ThumbnailMaked = false;				// TlC쐬σtONA
							}
						}

						return mThambnailImage;
					}
					finally
					{
						mThambnailLock.ReleaseMutex();
					}
				}
				else
				{
					return null;
				}
			}
		}

		// del yossiepon 20160806 begin
        ////=========================================================================
        /////	<summary>
        /////		nb̃Gs\[h擾(1`)
        /////	</summary>
        ///// <remarks>
        ///// </remarks>
        ///// <history>2006/XX/XX VK쐬</history>
        ////=========================================================================
        //public AnimeEpisode this[int storyNumber]
        //{
        //    get
        //    {
        //        if (storyNumber < 1 || mStoryCount < storyNumber)
        //            throw new Exception("G[: b͈͊Oł");
        //        return (AnimeEpisode)mEpisodes[storyNumber - 1];
        //    }
        //}
		// del yossiepon 20160806 end

		public delegate void EnumRecordCallBack(AnimeEpisode record, object param);

		//=========================================================================
		///	<summary>
		///		SEpisode񋓂
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public int EnumEpisodes(EnumRecordCallBack callBack, object param)
		{
			foreach (AnimeEpisode episode in this.Episodes)
			{
				callBack(episode, param);
			}

            // mod yossiepon 20160806 begin
            // return mEpisodes.Count;
            return mEpisodes.Count + mSpecialEpisodes.Count;
            // mod yossiepon 20160806 end
		}


		//=========================================================================
		///	<summary>
		///		
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <returns>
		///			0	擾
		///			-1	s
		///			-2	Ȃ(I)
		///	</returns>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public enum NextEpisode
		{
			NextDecided	,
			NextUnknown	,
			EndProgram	,
		};


		//=========================================================================
		///	<summary>
		///		t擾
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal NextEpisode GetNextEpisode(
			DateTime			dateTime	,
			out AnimeEpisode	earlyOnAir	)
		{
			earlyOnAir = null;

			//----------------------------------
			// ŏIbȍ~̓tȂI
			//----------------------------------
			if( Episodes.Count == 0 )
				return NextEpisode.NextUnknown;

			// del by 7sh 2.0.14.10 2012-03-30 begin
            /* ڃJ́Aׂēo^Ăȏꍇ
			AnimeEpisode lastEpisode = Episodes[Episodes.Count-1];

			if ( lastEpisode.HasPlan &&
				 lastEpisode.StartDateTime < dateTime)
			{
				earlyOnAir	= null;
				return NextEpisode.EndProgram;
			}
            */
			// del by 7sh 2.0.14.10 2012-03-30 end
			
			//
			// dateTimeȍ~AXg̒ōłEpisode
			//
			foreach (AnimeEpisode episode in Episodes)
			{
				if( episode.HasPlan &&
					dateTime <= episode.StartDateTime)
				{
					if (earlyOnAir != null)
					{
						if( episode.StartDateTime < earlyOnAir.StartDateTime )
						{
							earlyOnAir = episode;
						}
					}
					else
					{
						earlyOnAir = episode;
					}
				}
				
			}

			if (earlyOnAir==null)
				// mod by 7sh 2.0.14.10 2012-03-30 begin
				// return NextEpisode.NextUnknown;
                return NextEpisode.EndProgram;
				// mod by 7sh 2.0.14.10 2012-03-30 end

			return NextEpisode.NextDecided;
		}

		//=========================================================================
		///	<summary>
		///		^EpisodȅԂXV
		///	</summary>
		/// <remarks>
		///		ItCł̏ԕωXV
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal void UpdateState( DateTime now , string []files )
		{
			foreach (AnimeEpisode animeRecord in Episodes)
			{
				animeRecord.UpdateState(now,files);
			}
		}

		//=========================================================================
		///	<summary>
		///		vXV
		///	</summary>
		/// <remarks>
		///		Ԃ̎擾łȂAbꍇ̒ǉsB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal uint UpdatePlan(DateTime lastUpdate)	// [i] XV
		{
			SyoboiCalender syoboiCalender = mParent.mSyoboiCalender;
			List<SyoboiCalender.SyoboiRecord> syoboiList = null;
			uint updateCount = 0;

			if ( syoboiTid				== 0		) return 0;
			if ( linkOnlineDatabase		== false	) return 0;

			try{
				string			title;
				List<String>	sourcePage;

				syoboiList = syoboiCalender.DownloadOnAirList( syoboiTid, out title, out sourcePage );

#if DEBUG		// f[^̏ꍇ̃eXg
				if( Program.DebugOption.mForceEmpty )
					syoboiList.Clear();
#endif

				//--------------------------------
				// bꍇ̓Xgg[
				//--------------------------------
				int maxNumber = 0;
                // add yossiepon 20160808 begin
                int minNumber = 0;
                // add yossiepon 20160808 end

                // mod yossiepon 20160808 begin
                // foreach (SyoboiCalender.SyoboiRecord record in syoboiList)
                //     maxNumber = System.Math.Max(maxNumber, record.number);
				foreach (SyoboiCalender.SyoboiRecord record in syoboiList)
                {
                    if (syoboiTvStation == record.tvStation)
                    {
						maxNumber = System.Math.Max(maxNumber, record.number);
                        minNumber = System.Math.Min(minNumber, record.number);
                    }
                }
                // mod yossiepon 20160808 end

				if (StoryCount < maxNumber)
					StoryCount = maxNumber;	// bꍇ₷

                // add yossiepon 20160808 begin
                if (SpecialStoryCount < -minNumber)
                    SpecialStoryCount = -minNumber; // ԉ񂪑ꍇ₷
                // add yossiepon 20160808 end

				//-------------------------------
				// Gs\[hƕf[^XV
				//-------------------------------
				bool isPlanAbnormal = false;

				foreach (AnimeEpisode episode in Episodes)
				{
					bool abnormal;
					episode.UpdatePlan( syoboiList, out abnormal );
					isPlanAbnormal |= abnormal;
				}

				// ُ픭AڂTIDy[WobNAbv
				if( isPlanAbnormal )
				{
					string	strDateTime;
					string	fileName;
					string	filePath;
					
					strDateTime = string.Format(	"{0:D4}{1:D2}{2:D2}",
													DateTime.Now.Year	,
													DateTime.Now.Month	,
													DateTime.Now.Day	);

					fileName = String.Format("AbnormalData_tid{0}_{1}.html", syoboiTid, strDateTime);
					filePath = Path.Combine(Program.AppDataPath, fileName);

					var writer = new StreamWriter(filePath, true, Encoding.Unicode);
					sourcePage.ForEach( line => writer.WriteLine(line) );
					writer.Close();

					Logger.Output("ُf[^܂TIDy[Wۑ܂B(" + filePath + ")");
				}

				this.mLastUpdate = lastUpdate;
			}
			catch (Exception e)
			{
				throw new Exception(
					"ICf[^|x[X̃_E[hɎs܂\n"
					+ e.Message + "\n" + title);
			}

			return updateCount;
		}

		//=========================================================================
		///	<summary>
		///		TlCXV
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2010/01/02 MakeThumbnail𕪗</history>
		//=========================================================================
		internal void UpdateThumbnail()
		{
			List<AnimeEpisode>	targets = new List<AnimeEpisode>();

			foreach (AnimeEpisode episode in Episodes)
				if (!episode.ThumbnailMaked)
					targets.Add( episode );


			foreach(AnimeEpisode episode in targets)
			{
				try
				{
					MakeThumbnail( episode );
				}
				catch(UpdatingException ex)
				{
					Logger.Output( "(TlC) " + ex.Message + "(" + episode.ToString() + ")" );
				}
			}
		}

		//=========================================================================
		///	<summary>
		///		w肵Gs\[h̃TlC쐬
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2010/01/02 MakeThumbnail𕪗</history>
		//=========================================================================
		private bool MakeThumbnail(AnimeEpisode episode)
		{
			bool	bMake = false;

			// uăGR[hɃTlC쐬vIvV
			if( Properties.Settings.Default.makeThumbnailAfterEncode )
			{
				bMake = episode.HasFile && episode.IsEncoded;
			}
			else
			{
				bMake = episode.HasFile;
			}

			if( bMake )
			{
				Process		prc;
				string		args;

				if (File.Exists(episode.FilePath))
				{
					bool fileUsed = false;

					//-----------------------------
					// ^撆ł邱Ƃ𔻒
					//-----------------------------
					try
					{
						FileStream openTest = new FileStream(
							episode.FilePath	,
							FileMode.Open		, 
							FileAccess.Read		,
							FileShare.None		);

						openTest.Close();
					}
					catch(IOException e)
					{
						fileUsed = true;	// t@CgpŊJȂ
					}

					if(!fileUsed)
					{
						MemoryStream bmpImage;

						try
						{
							using( VideoImage videoImg = new VideoImage( episode.FilePath ) )
							{
								bmpImage = videoImg.GetFrameImage( Settings.Default.thumbnailSecond );
							}
						}
						catch(VideoImage.CannotOpenException ex)
						{
							throw new UpdatingException("TlC쐬G[(t@CJȂ)");
						}
						catch(VideoImage.RenderFailedException ex)
						{
							throw new UpdatingException("TlC쐬G[(C[W؂oȂ)");
						}
						catch(Exception ex)
						{
							throw new UpdatingException("TlC쐬G[");
						}

						//----------------------------------------------
						// ԑgTlCt@CփC[WA
						//----------------------------------------------
						try
						{
							mThambnailLock.WaitOne();

							if ( ThambnailImage == null )
								throw new UpdatingException( "G[(UpdateThumbnail)" );

							int oldw = mThambnailImage.Width;								// TlC̕
							int imgw = Math.Max(
											ThambnailSize.Width * episode.StoryNumber,
											oldw									);		// VTlC̕
							int imgx = ThambnailSize.Width * ( episode.StoryNumber - 1 );	// TlCǉXW

							// ƈȂ̂Ń~bg
							if (32000 < imgx)
							{
								Logger.Output("TlCt@C傫邽ߒǉł܂B");
								return false;
							}
							Image newimg = new Bitmap(imgw, ThambnailSize.Height);		// VTlC
							Image tmpimg = new Bitmap(bmpImage);

							Graphics g = Graphics.FromImage( newimg );

							g.DrawImage( mThambnailImage,
								0									,
								0									,
								new Rectangle(
									0							,
									0							,
									oldw						,
									mThambnailImage.Size.Height ),
								GraphicsUnit.Pixel					);						// TlCRs[

							g.DrawImage(
								tmpimg						,
								new Rectangle(
									imgx				,
									0					,
									ThambnailSize.Width	,
									ThambnailSize.Height)	,
								new Rectangle(
									0					,
									0					,
									tmpimg.Size.Width	,
									tmpimg.Size.Height	)	,	// VTlCɒǉ
								GraphicsUnit.Pixel			);

							mThambnailImage.Dispose();										// XVÕC[Wj

							newimg.Save(
								ThambnailFile	,
								ImageFormat.Png	);

							tmpimg.Dispose();

							mThambnailImage = newimg;										// VC[Wɒu

							episode.ThumbnailMaked = true;

							this.mIsDirty = true;
						}
						finally
						{
							mThambnailLock.ReleaseMutex();
						}
					}
				}
			
			}
				
			return true;
		}

		//=========================================================================
		///	<summary>
		///		ԑgVK\E\ύXE\mF
		///	</summary>
		/// <remarks>
		///		̕\Sė\ςɂB(VK\܂͗\ύX)
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal void CheckReserve(ReserveManager manager)
		{
			foreach (AnimeEpisode episode in Episodes)
			{
				if( episode.IsReserved )
				{
					episode.CheckReserve(manager);
				}
			}
		}


		//=========================================================================
		///	<summary>
		///		ԑgf[^XMLɏo
		///	</summary>
		/// <remarks>
		///		(AnimeServer)SaveĂ΂
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Write(System.Xml.XmlWriter xw)
		{
			xw.WriteStartElement("ProgramInformation");

			// ԑg̏o

			xw.WriteElementString("Hash"				, Convert.ToString(mHashCode));

			xw.WriteElementString("Title"				, title);
			xw.WriteElementString("StoryCount"			, Convert.ToString(mStoryCount));
            // add yossiepon 20160808 begin
            xw.WriteElementString("SpecialStoryCount"   , Convert.ToString(mSpecialStoryCount));
            // add yossiepon 20160808 end
			xw.WriteElementString("LinkOnlineDatabase"	, linkOnlineDatabase ? "1" : "0");
			xw.WriteElementString("SyoboiTID"			, Convert.ToString(syoboiTid));
			
			xw.WriteElementString("TvStation"			, tvStation);
			xw.WriteElementString("SyoboiTvStation"		, syoboiTvStation);

			xw.WriteElementString("LastUpdate"			, Convert.ToString(mLastUpdate.Ticks));
			xw.WriteElementString("WithoutPower"		, WithoutPower? "1" : "0");
			xw.WriteElementString("AdjustStartTime"		, adjustStartTime.ToString()	);
			xw.WriteElementString("AdjustEndTime"		, adjustEndTime.ToString()		);
			xw.WriteElementString("SyobocalPolicy"		, Enum.GetName( syobocalPolicy.GetType(), syobocalPolicy)	);
			xw.WriteElementString("SyobocalSpecifyNumber", syobocalSpecifyNumber.ToString()							);
			xw.WriteElementString("EnableFilterKeyword"	, Convert.ToString( enableFilterKeyword )	);
			xw.WriteElementString("FilterKeyword"		, filterKeyword								);
			xw.WriteElementString("Priority"			, Convert.ToString(priority)				);

			// ԑgebf[^̏o

			foreach (AnimeEpisode episode in Episodes)
				episode.Write( xw );

			// GR[h̏o

			if (mEncoderType != null)
			{
				xw.WriteElementString("EncodeClass", mEncoderType.FullName);

				xw.WriteStartElement(mEncoderProfile.TagName);

				mEncoderProfile.Write(xw);
				
				xw.WriteEndElement();
			}
			else
				xw.WriteElementString("EncodeClass", null);

			// XPW[̏o
			foreach ( Scheduler.Profile prof in mSchedulerProfiles )
			{
				xw.WriteStartElement( "SchedulerProfile" );
				xw.WriteAttributeString( "Type", prof.GetType().FullName );
				xw.WriteAttributeString( "Assembly", prof.GetType().Assembly.FullName );

				prof.Export( xw );
				
				xw.WriteEndElement();
			}

			xw.WriteEndElement();
		}

		//=========================================================================
		///	<summary>
		///		XMLǂݍ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Read(System.Xml.XmlReader xr)
		{
			mSchedulerProfiles.Clear();

			mEpisodes = new EpisodeList();
            // add yossiepon 20160808 begin
            mSpecialEpisodes = new EpisodeList();
            // add yossiepon 20160808 end
			mEncoderProfile	= null;
			int	length = 0;

			while (xr.Read())
			{

				if (xr.NodeType == System.Xml.XmlNodeType.Element)
				{

					if (xr.LocalName.Equals("Title"))
						title = xr.ReadString();
					else if (xr.LocalName.Equals("StoryCount"))
						mStoryCount = xr.ReadElementContentAsInt();
                    // add yossiepon 20160808 begin
                    else if (xr.LocalName.Equals("SpecialStoryCount"))
                        mSpecialStoryCount = xr.ReadElementContentAsInt();
                    // add yossiepon 20160808 end
					else if (xr.LocalName.Equals("Length"))
						length = xr.ReadElementContentAsInt();
					else if (xr.LocalName.Equals("LinkOnlineDatabase"))
						linkOnlineDatabase = xr.ReadElementContentAsInt() == 1 ? true : false;
					else if (xr.LocalName.Equals("SyoboiTID"))
						syoboiTid = xr.ReadElementContentAsInt();
					else if (xr.LocalName.Equals("TvStation"))
						tvStation = xr.ReadElementContentAsString();
					else if (xr.LocalName.Equals("SyoboiTvStation"))
						syoboiTvStation = xr.ReadElementContentAsString();
					else if (xr.LocalName.Equals("Hash"))
						mHashCode = (uint)xr.ReadElementContentAsDecimal();
					else if (xr.LocalName.Equals("LastUpdate"))
					{
						string strDateTime = xr.ReadElementContentAsString();
						mLastUpdate = new DateTime(Convert.ToInt64(strDateTime));
					}
					else if (xr.LocalName.Equals("WithoutPower"))
						WithoutPower = xr.ReadElementContentAsInt() == 1 ? true : false;
					else if (xr.LocalName.Equals("AdjustStartTime"))
						adjustStartTime = xr.ReadElementContentAsLong();
					else if (xr.LocalName.Equals("AdjustEndTime"))
						adjustEndTime = xr.ReadElementContentAsLong();
					else if (xr.LocalName.Equals("SyobocalPolicy"))
						syobocalPolicy = (SyobocalPolicy)Enum.Parse(syobocalPolicy.GetType(), xr.ReadElementContentAsString());
					else if (xr.LocalName.Equals("SyobocalSpecifyNumber"))
						syobocalSpecifyNumber = xr.ReadElementContentAsInt();
					else if (xr.LocalName.Equals("EnableFilterKeyword"))
						enableFilterKeyword = bool.Parse(xr.ReadElementContentAsString());
					else if (xr.LocalName.Equals("FilterKeyword"))
						filterKeyword = xr.ReadElementContentAsString();
					else if(xr.LocalName.Equals("Priority"))
						priority = xr.ReadElementContentAsInt();
					else if (xr.LocalName.Equals("Records"))
					{
						AnimeEpisode episode;

						// StoryCount++;
						episode = new AnimeEpisode(this, 0);

						episode.Read(xr);

                        // mod yossiepon 20160808 begin
                        // mEpisodes.Add(episode);
                        if(episode.StoryNumber > 0)
                        {
							mEpisodes.Add(episode);
						}
                        else
                        {
                            mSpecialEpisodes.Add(episode);
                        }
                        // mod yossiepon 20160808 begin
                    }
					else if (xr.LocalName.Equals("EncodeClass"))
					{
						Encoder encoder;
						string typeName;

						typeName = xr.ReadElementString();

						mEncoderType = EncodeManager.FindEncoder(typeName);

						if (mEncoderType != null)
						{
							encoder = (Encoder)Activator.CreateInstance(mEncoderType);
							mEncoderProfile = Activator.CreateInstance(encoder.ProfileType) as EncodeProfile;
						}
					}
					else if (mEncoderProfile != null
						   && xr.LocalName.Equals(mEncoderProfile.TagName))
					{
						mEncoderProfile.Read(xr);
					}
					// XPW[ݒǂݍ
					else if (xr.LocalName.Equals("SchedulerProfile"))
					{
						string profType = xr.GetAttribute("Type");
						string assemName = xr.GetAttribute("Assembly");

						if (profType != null && assemName != null)
						{
							Scheduler.Profile prof;
							System.Runtime.Remoting.ObjectHandle obj;

							try
							{
								if ((obj = Activator.CreateInstance(assemName, profType)) != null)
								{
									if ((prof = obj.Unwrap() as Scheduler.Profile) != null)
									{
										prof.Import(xr);
										mSchedulerProfiles.Add(prof);
									}
								}
							}
							catch (TypeLoadException ex)
							{
							}
						}
					}
				}
				else if (xr.NodeType == System.Xml.XmlNodeType.EndElement)
					if (xr.LocalName.Equals("ProgramInformation"))
						break;
			}

			// ver1.9.02ȑÕf[^ڍsp
			// uڂerǖv΁u^erǖv
			if (string.IsNullOrEmpty(syoboiTvStation))
			{
				syoboiTvStation = tvStation;
			}

			if( 0 < length )
			{
				foreach( AnimeEpisode ep in this.Episodes )
					ep.Length = length;
			}

		}

	}


}
