//=========================================================================
///	<summary>
///		Gs\[hf[^NX
///	</summary>
/// <remarks>
///		Ajeb̘^ԂǗA\EGR[h̏s
/// </remarks>
/// <history>2006/XX/XX VK쐬 Dr.Kurusugawa</history>
/// <history>2007/08/16	ԑgƂ̃XPW[ݒɑΉ</history>
/// <history>2007/11/11	State̕ύXproperty setSetState\bhɕύX</history>
/// <history>2009/12/28	ÂCRg폜</history>
/// <history>2010/05/01 SubversionŊǗ邽ߕsvȃRg폜</history>
//=========================================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Collections;
using System.Runtime.InteropServices;
using KernelAPI;
using magicAnime.Properties;
using magicAnime.OnLine_DataBase;
using Helpers;
//using Microsoft.VisualBasic.FileIO;

namespace magicAnime
{
	public class EpisodeMethodException : Exception
	{
		public EpisodeMethodException(string mes)
			: base(mes)
		{
		}
	};

	//=========================================================================
	///	<summary>
	///		Ajeb̘^ԂǗ
	///	</summary>
	/// <remarks>
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	//=========================================================================
	public class AnimeEpisode
	{
		//---------------------------
		// 񋓎q̒`
		//---------------------------

		//=========================================================================
		///	<summary>
		///		Gs\[h̏
		///	</summary>
		/// <remarks>
		///		Ver1.9.18ȍ~Ȁ͕\Ɏĝ݂
		///		̉۔fɎgpĂ͂ȂȂB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//========================================================================
		public enum State
		{
			Notfound	,	// ^t@CȂ
			Planned		,	// vm
			Recorded	,	// ^
			Encoded		,	// ăGR[h
			Stored		,	// ۑ
			Scheduling	,	// ^\
			Encoding	,	// GR[h
			Undecided	,	// 
			Changed		,	// ԕύX
			DontCare	,	// Ȃ
			LostSchedule,	// \
			Busy		,	// 
		};

		//---------------------------
		// oϐ
		//---------------------------
		private	AnimeProgram	mParent;                            // ԑgIuWFNg
		private bool			mHasPlan		= false;			// XPW[m
		private	DateTime		mStartTime;                         // Jn
		private int				mLength			= 0;				// [min]
		private bool			mIsReserved		= false;			// \σtO
		private DateTime		mReserveStartTime;					// ^\tgɗ\񂵂ĂJn
		private bool			mHasFile		= false;			// t@C
		private string			mFilePath;							// t@CpX
		private	bool			mThumbnailMaked	= false;            // TlC쐬σtO
		private bool			mIsUnread		= true;				// ǃtO
		private bool			mIsReserveError	= false;			// \G[tO
		private bool			mIsEncoded		= false;			// ăGR[h
		private bool			mIsStored		= false;			// ۑɓ]
		private bool			mIsBusy			= false;			// tO
		public	string			mSubTitle		= "";				// Tu^Cg
		private bool			mIsDirty		= false;			// f[^ύXtO
		private	int				mStoryNumber	= 0;				// Gs\[hԍ
		// add yossiepon 20150705 begin
		private	string			mStoryNoStr		= "";				// Gs\[hԍ
		// add yossiepon 20150705 end
		private int				mRepeatNumber	= -1;				// nڂ̕
		private bool			mPlanError		= false;			// vf[^ُ

		private	Encoder			encoding		= null;				// GR[h̃GR[_IuWFNg

		//=========================================================================
		///	<summary>
		///		RXgN^
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public AnimeEpisode( AnimeProgram animeProgram, int storyNumber )
		{
			this.mFilePath	= null;
			this.mSubTitle	= "";
			
			this.mParent	= animeProgram;
			
			this.mStoryNumber = storyNumber;

			this.Dirty = true;
		}


		//=========================================================================
		///	<summary>
		///		eIuWFNgւ̎QƂԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public AnimeProgram Parent	{ get { return mParent; } }

		//=========================================================================
		///	<summary>
		///		ύXtO
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal bool Dirty
		{
			get { return mIsDirty; }
			set { mIsDirty = value; }
		}

		//=========================================================================
		///	<summary>
		///		ǃtO
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal bool Unread
		{
			get { return this.mIsUnread; }
			set
			{
				this.mIsUnread = value;
				this.mIsDirty = true;
			}
		}

		internal bool IsReserved
		{
			get{ return mIsReserved; }
			set{ mIsReserved = value; }
		}

		// \񂵂Ă鎞ƕقȂ邩
		internal bool JudgeTimeChanged
		{
			get
			{
				if( this.mHasPlan && this.mIsReserved )
					return (this.StartRecordDateTime != this.mReserveStartTime);
				return false;
			}
		}

		internal bool HasPlan
		{
			get { return mHasPlan; }
			set
			{
				mHasPlan	= value;
				Dirty		= true;
			}
		}

		internal bool HasFile
		{
			get { return mHasFile; }
			set
			{
				mHasFile	= value;
				Dirty		= true;
			}
		}

		internal bool IsEncoded
		{
			get{ return mIsEncoded; }
			set
			{
				mIsEncoded	= value;
				Dirty		= true;
			}
		}

		internal bool IsStored
		{
			get { return mIsStored; }
			set
			{
				mIsStored	= value;
				Dirty		= true;
			}
		}

		internal bool IsBusy
		{
			get{ return mIsBusy; }
		}

		internal DateTime ReserveDateTime
		{
			get{ return mReserveStartTime; }
			set
			{
				mReserveStartTime	= value;
				Dirty				= true;
			}
		}

		internal bool IsReserveError
		{
			get{ return mIsReserveError; }
			set
			{
				mIsReserveError	= value;
				Dirty			= true;
			}
		}

		// ԂIĂ邩
		internal bool JudgeTimeEnd(DateTime now)
		{
			if( mHasPlan )
				return EndDateTime < now;
			return false;
		}

		// \^KvƂ邩Ԃ(ɘ^悳Ăfalse)
		internal bool IsRecordRequired
		{
			get{ return !mHasFile; }
		}
		internal int Length
		{
			get{ return mLength; }
			set
			{
				mLength = value;
			}
		}
		internal int RepeatNumber
		{
			get{ return mRepeatNumber; }
		}
		// \^撆͘^ł邩Ԃ
		internal bool IsRecorded
		{
			get
			{
				if( this.HasPlan && this.IsReserved )
					return (this.StartDateTime <= DateTime.Now);
				else if( this.HasFile )
					return true;
				return false;
			}
		}
		// JnԂ߂Ԃ
		internal bool IsStartedOnair
		{
			get
			{
				if( this.HasPlan )
					return (this.StartDateTime <= DateTime.Now);
				return false;
			}
		}
		// vf[^ُ̗L
		internal bool PlanError
		{
			get{ return mPlanError; }
			set
			{
				mPlanError		= value;
				Dirty			= true;
			}
		}
		
		//=========================================================================
		///	<summary>
		///		JnԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public DateTime StartDateTime
		{
			get
			{
				return mStartTime;
			}
			set
			{
				mStartTime	= value;
				Dirty		= true;
			}
		}

		//=========================================================================
		///	<summary>
		///		IԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public DateTime EndDateTime
		{
			get
			{
				return mStartTime.AddMinutes(mLength);
			}
		}

		//=========================================================================
		///	<summary>
		///		^JnԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public DateTime StartRecordDateTime
		{
			get
			{
				return mStartTime.AddMinutes( Settings.Default.reserveStart
											+ Parent.adjustStartTime );
			}
		}

		//=========================================================================
		///	<summary>
		///		^IԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public DateTime EndRecordDateTime
		{
			get
			{
				return EndDateTime.AddMinutes( Settings.Default.reserveEnd
											 + Parent.adjustEndTime );
			}
		}

		//=========================================================================
		///	<summary>
		///		݂̃Gs\[hԂԂ
		///	</summary>
		/// <remarks>
		///		Ver1.9.18ȍ~AԂ̒l͕ێȂB
		///		etOԂ߂ĂԂ̂݁B
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public State CurrentState
		{
			get
			{
				if( IsBusy )
					return State.Busy;

				if( HasFile )
				{
					if( IsStored )
						return State.Stored;
					if( IsEncoded && !IsStored )
						return State.Encoded;
					return State.Recorded;
				}

				if( !HasPlan )
					return State.Undecided;
				else
				{
					if( JudgeTimeChanged )
						return State.Changed;
					else
					{
						if( IsReserveError )
							return State.LostSchedule;
						if( IsReserved )
							if( JudgeTimeEnd( DateTime.Now ) )
								return State.Notfound;
							else
								return State.Scheduling;
						else
							if( JudgeTimeEnd( DateTime.Now ) )
								return State.Notfound;
							else
								return State.Planned;
					}
				}
			}
		}

		//=========================================================================
		///	<summary>
		///		Ή铮t@CpXԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public string FilePath	
		{
			get
			{
				return mHasFile ? mFilePath : "";
			}
			set
			{
				mFilePath	= value;
				this.Dirty	= true;
			}
		}

		public int StoryNumber		{ get { return mStoryNumber;  } }
		// add yossiepon 20150705 begin
		public string StoryNoStr	{ get { return mStoryNoStr; } }
        // add yossiepon 20150705 end

		//=========================================================================
		///	<summary>
		///		Đ\
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public bool IsPlayable
		{
			get
			{
				return mHasFile && !mIsBusy;
			}
		}

		//=========================================================================
		///	<summary>
		///		ۑɓ]\
		///	</summary>
		/// <remarks>
		///		GR[hρA͘^ςōăGR[hȂȂTRUE
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal bool IsStorable
		{
			get
			{
				if( mHasFile )
				{
					if( mIsEncoded )
						return true;
					if( !mIsEncoded	&&
						Parent.EncoderProfile == null	)
						return true;
				}
				return false;
			}
		}

		//=========================================================================
		///	<summary>
		///		TlC쐬ς݂Ԃ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal bool ThumbnailMaked
		{
			get { return mThumbnailMaked;  }
			set { mThumbnailMaked = value;  }
		}

		//=========================================================================
		///	<summary>
		///		ɏd邩Ԃ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal bool IsDoubleBooking()
		{
			List<AnimeEpisode>	conflicts = Parent.Parent.DoubleBookingEpisodes;
			if( conflicts != null )
			{
				return conflicts.Contains( this );
			}
			return false;
		}


		//=========================================================================
		///	<summary>
		///		vXV
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2007/05/06 XV̏ύX</history>
		/// <history>2009/01/04 \bhύX</history>
		/// <history>2010/04/17 ÂRg폜</history>
		//=========================================================================
		internal void UpdatePlan(
			List<SyoboiCalender.SyoboiRecord>	syoboiList	,	// [i] ڂf[^
			out bool							abnormal	)	// [o] true:f[^Ɉُo
		{
			DateTime					now			 = DateTime.Now;
			SyoboiCalender.SyoboiRecord	syoboiRecord = null;

			abnormal = false;

			//-----------------------------
			// f[^XV
			//-----------------------------
			// ύXł̂͗\^悪JnO܂
			bool isRecording	= this.IsReserved && this.IsStartedOnair;
			bool isRecorded		= this.HasFile;

			bool dontCare		= this.mIsBusy || (isRecording || isRecorded);

			//------------------------------------
			// YGs\[h̃f[^
			//------------------------------------

			var records = SyoboiRecordFilter.EpisodeAndStationFilter(
				syoboiList,
				mStoryNumber,
				mParent.syoboiTvStation);

			// {ƍĕ̃f[^

			if(Parent.syobocalPolicy == AnimeProgram.SyobocalPolicy.SpecifyLatest)
			{
				// ł̕I
				syoboiRecord = SyoboiRecordFilter.LatestPlanFilter( records, out mRepeatNumber );
			}
			else if (Parent.syobocalPolicy == AnimeProgram.SyobocalPolicy.SpecifyNumber)
			{
				// nڂ̕I
				syoboiRecord = SyoboiRecordFilter.NumberPlanFilter(
					records,
					Parent.syobocalSpecifyNumber,
					out mRepeatNumber);
			}
			else if (Parent.syobocalPolicy == AnimeProgram.SyobocalPolicy.SpecifyEarly)
			{
				// łI
				bool	keep = false;

				// ݎɉđIvς邪
				// \^Jnɂ͕ςȂB
				if( this.HasPlan && this.IsReserved )
					keep = (this.StartDateTime <= now);

                // mod yossiepon 20191123 begin
                // ^抮keepfalseɂȂ̂ŁAdontCareĂȂmSubTitle㏑\B
                // F^ɘAb̍ĕ񂪓o^ꂽꍇɃTu^Cgu#mm`#nnvŏ㏑
                // ]āAdontCaretruȅꍇvύXȂ悤ɂď㏑B
                //if (keep)
                if (keep || dontCare)
                // mod yossiepon 20191123 end
				{
					// ^Jn̓vύXȂ
					if( 0 <= mRepeatNumber )
						syoboiRecord = SyoboiRecordFilter.NumberPlanFilter(
							records,
                            // mod yossiepon 20191123 begin
                            // NumberPlanFilter ̑21n܂肾AmRepeatNumber0n܂Ȃ̂ŏC
                            //mRepeatNumber,
                            mRepeatNumber + 1,
                            // mod yossiepon 20191123 end
                            out mRepeatNumber );
					else
						records = null;
				}
				else
				{
					syoboiRecord = SyoboiRecordFilter.EarlytPlanFilter(
						records,
						now,
						out mRepeatNumber );

					if( syoboiRecord == null  )
					{
						// ̕Ȃꍇ͍Ō̕IĂ
						syoboiRecord = SyoboiRecordFilter.LatestPlanFilter(
							records,
							out mRepeatNumber );
					}
				}
			}

			if (syoboiRecord != null)
			{
				//-------------------------------------------------------------
				// ICDBɍXVꍇA[Jf[^XV
				//-------------------------------------------------------------
				if( mPlanError )
				{
					Logger.Output("T[o[̕f[^Ă܂ - " + this.ToString());
					mPlanError	= false;
				}

				// Tu^CgZbg
				if( !string.IsNullOrEmpty(syoboiRecord.subtitle) &&
					(mSubTitle != syoboiRecord.subtitle)		 )
				{
					mSubTitle	= syoboiRecord.subtitle;
					Dirty		= true;
				}

				if( !dontCare )
				{
					// 擾vŏ㏑
					if( !mHasPlan
					||	(mStartTime	!= syoboiRecord.onAirDateTime)
					||	(mLength	!= syoboiRecord.length)
					// add yossiepon 20150705 begin
					||	!mStoryNoStr.Equals(syoboiRecord.episode)	)
                    // add yossiepon 20150705 end
					{
                        // mod yossiepon 20150705 begin
						// mHasPlan	= true;
						mHasPlan	= syoboiRecord.length != 0;
                        // mod yossiepon 20150705 end
						mStartTime	= syoboiRecord.onAirDateTime;
						mLength		= syoboiRecord.length;
						// add yossiepon 20150705 begin
						mStoryNoStr	= syoboiRecord.episode;
                        // add yossiepon 20150705 begin
						Dirty		= true;
					}

				}
			}
			else
			{
				//--------------------------------------
				// f[^[x[Xɏ񂪂Ȃꍇ
				//--------------------------------------
				if( !dontCare )
				{
					if( mHasPlan && Settings.Default.keepPlan )
					{
						// 炩̌łڂ邩f[^ĂĂ͎cĂ
						if( !mPlanError )
						{
							mPlanError	= true;
							Dirty		= true;
							Logger.Output("T[o[̕f[^Ă܂̃f[^ێ܂ - " + this.ToString());
							abnormal	= true;
						}
					}
					else
					{
						mHasPlan	= false;
					}
					Dirty		= true;

					if( IsReserved )
					{
						Logger.Output("\σGg̕f[^ȂĂ܂ - " + this.ToString());
						abnormal	= true;
					}
				}
			}
		}

		//=========================================================================
		///	<summary>
		///		^Ԃ̍XV^t@CΉt
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal void UpdateState(
			DateTime	now			,	// XV
			string[]	movieFiles	)	// ^t@CXg
		{
			if( mHasPlan && !mHasFile )
			{
				{
					//----------------------------------------
					// Ԃɍv^t@C
					//----------------------------------------
					string	filterKeyword;
					filterKeyword	= Parent.enableFilterKeyword ?
										Parent.filterKeyword : null;

					string filename = AnimeServer.FindCapturedFile(
								GetUniqueString()	,
								StartDateTime		,
								EndDateTime			,
								movieFiles			,
								filterKeyword		);

					if ( filename != null ) // t@CΘ^ςɂ
					{
						this.mHasFile	= true;
						this.mFilePath	= filename;
						this.mIsUnread	= true;
						this.mIsEncoded	= false;	// t@ĆuăGRρvu]ρvł͂Ȃ
						this.mIsStored	= false;
						this.Dirty		= true;
					}
				}
			}
		
			if( !mHasFile )
			{
				//-----------------------------
				// ۑσt@C
				//-----------------------------
				try
				{
					bool		isExist		= false;
					string		targetDir	= Settings.Default.saveFolder;
					
					if( !string.IsNullOrEmpty(targetDir)	&&
						Directory.Exists( targetDir )		)
					{
						if( Settings.Default.classificatePrograms )
							targetDir = Path.Combine( targetDir, PathHelper.ToFileTitle( mParent.title ) );

						isExist = Directory.Exists( targetDir );

						if( isExist )
						{
							string[]	files;
							string		pattern = GetFormattedFileName() + ".*";

							files = Directory.GetFiles( targetDir, pattern );

							if( files.Length == 1 )
							{
								this.mHasFile	= true;
								this.mFilePath	= files[0];
								this.mIsEncoded	= false;
								this.mIsStored	= true;
								this.Dirty		= true;
							}
						}
					}
				}
				catch(Exception ex)
				{
				}
			}
		}

		//=========================================================================
		///	<summary>
		///		̃Gs\[h̘^\ɗpӂȕԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public string GetUniqueString()
		{
			string unique;

			unique = mParent.UniqueID.ToString() + "_";			// 
			unique += mStoryNumber.ToString();

			return unique;
		}

		//=========================================================================
		///	<summary>
		///		̃Gs\[h̗\ׂۗf
		///	</summary>
		/// <remarks>
		///		Dx͏falseԂB
		///		ʑł͂̌ʂReserveĂяofׂB
		///		(蓮ŋ\񂵂ꍇ͂̌ł͂Ȃ)
		/// </remarks>
		/// <history>2009/11/23 VK쐬</history>
		//=========================================================================
		internal bool IsReservePending()
		{
			if( Settings.Default.enablePriority )
			{
				AnimeServer server = Parent.Parent;
					
				server.CheckDoubleBooking();

				return server.DoubleBookingEpisodes.Contains(this);
			}
			else
				return false;
		}

		//=========================================================================
		///	<summary>
		///		̃Gs\[h^\tgɗ\
		///	</summary>
		/// <remarks>
		///		ɗ\񂳂Ăꍇ͉ȂB
		///		Ԃ̕ύX\ɔfB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2009/06/28 ^\tg"Ȃ"͗\񎸔s</history>
		//=========================================================================
		internal bool Reserve(
			ReserveManager		manager			,	// [i] ^\}l[W
			out string			errorMessage	)	// [o] \񎸔sڍ
		{
			string descript;

			descript = string.Format("{0:0} {1:0}b", Parent.title, StoryNumber);

			if( !IsReserved || JudgeTimeChanged )
			{
				DateTime	start	= DateTime.Now;
				int			length	= 0;

				//-----------------------------------
				// ^JnƘ^IvZ
				//-----------------------------------
				try
				{
					start	= this.StartRecordDateTime;
					length	= (int)(this.EndRecordDateTime - start).TotalMinutes;

					if( length <= 0 )
						throw new Scheduler.ZeroLengthScheduleTimeException();

					//-------------------------------
					// ԑg̗\vt@C擾
					//-------------------------------
					Scheduler.Profile prof = null;

					if (ReserveManager.DefaultScheduler				!= null		&&
						ReserveManager.DefaultScheduler.ProfileType != null		)
					{
						prof = Parent.SchedulerProfile( ReserveManager.DefaultScheduler.ProfileType );
					}

					if( !IsReserved )
					{
						//--------------------------------------
						// ̕E\񂪏  VK\
						//--------------------------------------
						if (manager.MakeReservation(
								descript,
								GetUniqueString(),
								Parent.tvStation,
								start,
								(uint)length,
								Parent.UniqueID,
								prof))
						{
							this.mIsReserved		= true;
							this.mIsReserveError	= false;
							this.mReserveStartTime	= start;
							this.Dirty				= true;
						}
						else
						{
							this.mIsReserved		= false;
							this.mIsReserveError	= true;
							this.Dirty				= true;
							errorMessage = "^\tgw肳Ă܂B(IvVʂőIĉ)";
							return false;
						}
					}
					else if( JudgeTimeChanged )
					{
						ReserveManager.ChangeResult res;
						
						//--------------------------------------
						// ԕύX  ԕύXs
						//--------------------------------------
						res = manager.ChangeReservation(
								descript				,
								GetUniqueString()		,
								Parent.tvStation		,
								start					,
								(uint)length			,
								Parent.UniqueID			,
								prof					);
						
						if ( res == ReserveManager.ChangeResult.OK )				// ύXɐH
						{
							this.mIsReserved		= true;
							this.mIsReserveError	= false;
							this.mReserveStartTime	= start;
							this.Dirty				= true;
						}
						else if ( res == ReserveManager.ChangeResult.Lost )			// \񂪎ꂽH
						{
							this.mIsReserved		= false;
							this.mIsReserveError	= true;
							this.Dirty				= true;
						}
					}

				}
				catch (Scheduler.DoubleBookingException e)										// \񂪏dH
				{
					Logger.Output( "(\Ǘ)\񂪏d邽߁A\o^ł܂B " + start.ToString() + " - " + descript );
					this.mIsReserved		= false;
					this.mIsReserveError	= true;
					this.Dirty				= true;
					errorMessage = "\񂪏d邽߁A\o^ł܂B " + start.ToString() + " - " + descript;
					return false;
				}
				catch(Scheduler.SchedulerBaseExecption e)
				{
					object		[]objAttributes;
					string		errorDetail			= "\񎞂ɃG[܂B";

					objAttributes = e.GetType().GetCustomAttributes(
						typeof(Scheduler.SchedulerExceptionAtribute), true );

					if( objAttributes != null )
					{
						Scheduler.SchedulerExceptionAtribute	exceptionAtrribute;
						exceptionAtrribute = objAttributes[0] as Scheduler.SchedulerExceptionAtribute;

						if( exceptionAtrribute != null )
							errorDetail = exceptionAtrribute.Description;
					}

					Logger.Output( "(\Ǘ)"
						+ errorDetail
						+ " "
						+ start.ToString()
						+ "`"
						+ EndDateTime.ToString()
						+ " - "
						+ descript				);

					this.mIsReserved		= false;
					this.mIsReserveError	= true;
					this.Dirty				= true;

					errorMessage = errorDetail + " " + descript;
					Logger.Output( "(\Ǘ)" + errorMessage );
					return false;
				}
				catch(System.Exception ex)
				{
					this.mIsReserved		= false;
					this.mIsReserveError	= true;
					this.Dirty				= true;

					errorMessage = ex.Message + " " + descript;
					Logger.Output( "(\Ǘ)" + errorMessage );
					return false;
				}

			}

			errorMessage = "";
			return true;
		}

		//=========================================================================
		///	<summary>
		///		^\tgɗ\񂪓Ă邩mF
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2008/10/21 \mFɕs\ȃvOCȂ疳</history>
		//=========================================================================
		internal void CheckReserve(ReserveManager manager)
		{
			string descript;

			descript = string.Format("{0:0} {1:0}b", Parent.title, StoryNumber);

			bool	evaluated;
			bool	exist;

			if( IsReserved )
			{
				//------------------------------
				// \񂪏ĂȂ`FbN
				//------------------------------
				evaluated = manager.ExistReservation( descript, GetUniqueString(), out exist);

				if( evaluated && !exist )
				{
					this.mIsReserved		= false;
					this.mIsReserveError	= true;
					this.Dirty				= true;
				}
			}
			else
			{
				//------------------------------------
				// \񂪕Ă邩`FbN
				//------------------------------------
                evaluated = manager.ExistReservation(descript, GetUniqueString(), out exist);

                if ( evaluated && exist )
                {
					this.mIsReserved		= true;
					this.mIsReserveError	= false;
					this.mReserveStartTime	= this.mStartTime;	// <PENDING> 2009/12/28
					this.Dirty				= true;
                }
			}
		}

		//=========================================================================
		///	<summary>
		///		^\tg̗\LZ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2008/10/22 VK쐬</history>
		//=========================================================================
		internal bool CancelReserve(ReserveManager manager)
		{
			string		descript;

			descript = string.Format("{0:0} {1:0}b", Parent.title, StoryNumber);

			if( !IsReserved )
				return false;

			try
			{
				if( !manager.CancelReservation( descript, GetUniqueString() ) )
					return false;
			}
			catch(Exception ex)
			{
				return false;
			}

			this.mIsReserved	= false;
			this.Dirty			= true;

			return true;
		}


		//=========================================================================
		///	<summary>
		///		̃Gs\[h̘^t@CăGR[h
		///	</summary>
		/// <remarks>
		///		GR[hI܂Ő͖߂ȂB
		///		EncodeJobNX𗘗pĔ񓯊ŎsB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal void Encode()
		{
			Encoder	encoder		= null;

			if( !mHasFile )
				throw new EpisodeMethodException("t@Cw肳ĂȂ");
			if( mIsEncoded )
				throw new EpisodeMethodException("ɃGR[hĂ");
			if( mIsBusy )
				throw new EpisodeMethodException("̂߃GR[hJnłȂ");

			if (Properties.Settings.Default.encodedFolder.Equals(""))
				throw new EpisodeMethodException("GR[ho͐tH_ݒ肳Ă܂");

			if (Parent.EncoderType == null)
				throw new EpisodeMethodException("GR[hvt@Cw肳Ă܂");

			if (!File.Exists(mFilePath))
				throw new EpisodeMethodException("GR[h̃t@C܂" + mFilePath);

			try
			{
				string encodedFile;

				encodedFile = Path.Combine(
								Settings.Default.encodedFolder	,
								GetFormattedFileName()			);

				//----------------------
				// encodingԂɕύX
				//----------------------
				this.mIsBusy	= true;
				this.mIsDirty	= true;

				//----------------------
				// \ǉ̏
				//----------------------
				Encoder.TvProgramAdditionalInfo ai = new Encoder.TvProgramAdditionalInfo();

				ai.Title		= PathHelper.ToFileTitle(Parent.title);
				ai.StoryNumber	= this.StoryNumber.ToString();
				ai.Subtitle		= PathHelper.ToFileTitle(this.mSubTitle);
				ai.TvStation	= Parent.tvStation;
				ai.StartDate	= this.StartDateTime.ToShortDateString();
				ai.StartTime	= this.StartDateTime.ToShortTimeString();

				//----------------------
				// GR[_̏
				//----------------------
				encoder = (Encoder)Activator.CreateInstance(Parent.EncoderType);

				encodedFile += encoder.Extension;

				encoding = encoder;

				//--------------------
				// GR[_s
				//--------------------

				encoder.DoEncode(
					FilePath				,
					ref encodedFile			,
					Parent.EncoderProfile	,
					ai						);							// GR[_vOCĂяo

				//----------------------------------------
				// GR[hA̘^t@C폜
				//----------------------------------------
				if ( Settings.Default.removeSourceWhenEncoded )
				{
					try
					{
						File.Delete( mFilePath + "." );

						//
						// ꏊK̘^tH_ȂTufBNgƍ폜
						//
						if (Settings.Default.captureSubDir)
						{
							string subFolder, parentFolder;

							subFolder		= Path.GetDirectoryName( mFilePath + "." );
							parentFolder	= Directory.GetParent( subFolder ).FullName;

							if (Settings.Default.captureFolder.Equals(parentFolder))
							{
								string[] files;

								// ܂fBNg̃t@CSč폜Ă
								files = Directory.GetFiles(subFolder);
								foreach (string f in files)
									File.Delete(f);

								Directory.Delete(subFolder, true);
							}
						}

					}
					catch (Exception e)
					{
						Logger.Output(e.Message);
					}

				}

				//-----------------------
				// GR[hϏԂ
				//-----------------------
				this.FilePath	= encodedFile;
				this.mIsEncoded	= true;
			}
			catch (AbortException x)
			{
				this.mIsBusy	= false;
				throw x;
			}
			catch (Exception x)
			{
				this.mIsBusy	= false;
				throw x;
			}
			finally
			{
				this.encoding	= null;
				this.mIsBusy	= false;
				this.mIsDirty	= true;
			}
		}

		//=========================================================================
		///	<summary>
		///		GR[h𒆒f
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void CancelEncode()
		{
			if (encoding!=null)
			{
				encoding.AbortEncodeProcess();
			}
		}


		//=========================================================================
		///	<summary>
		///		tH[}bgꂽt@C擾
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public string GetFormattedFileName()
		{
			string formattedName, titleName, subTitleName;

			titleName		= PathHelper.ToFileTitle(mParent.title);
			subTitleName	= PathHelper.ToFileTitle(mSubTitle);

			try
			{
				string	dateStr = "";
				string	timeStr = "";
				string	station	= "";

				if(this.HasPlan)
				{
					var helper = new DateTimeHelper(
						this.StartDateTime,
						Settings.Default.hoursPerDay - 24);
					
					dateStr	= helper.ToShortDateString().Replace("/", "");
					timeStr	= helper.ToShortTimeString().Replace(":", "");
				}

				station = Parent.tvStation;

				formattedName = string.Format(
					Settings.Default.saveNameFormat,
					titleName,
					mStoryNumber,
					subTitleName,
					dateStr,
					timeStr,
                    // mod yossiepon 20150705 begin
					// station);
					station,
					mStoryNoStr.Length > 0 ? mStoryNoStr : mStoryNumber.ToString(Settings.Default.storyNoFormat));
					// mod yossiepon 20150705 end
			}
			catch(Exception ex)
			{
				throw new UpdatingException("ۑt@C܂B");
			}

			return formattedName;
		}

		//=========================================================================
		///	<summary>
		///		tH[}bgꂽԑgGs\[hԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public override string ToString()
		{
			string myName;

			try
			{
				string	dateStr = "";
				string	timeStr = "";
				string	station	= "";

				if(this.HasPlan)
				{
					var helper = new DateTimeHelper(
						this.StartDateTime,
						Settings.Default.hoursPerDay - 24);
					
					dateStr	= helper.ToShortDateString();
					timeStr	= helper.ToShortTimeString();
				}

				station = Parent.tvStation;

				myName = string.Format(
					Settings.Default.saveNameFormat,
					mParent.title,
					mStoryNumber,
					mSubTitle,
					dateStr,
					timeStr,
                    // mod yossiepon 20150705 begin
					// station);
					station,
					mStoryNoStr.Length > 0 ? mStoryNoStr : mStoryNumber.ToString(Settings.Default.storyNoFormat));
					// mod yossiepon 20150705 end
			}
			catch(Exception ex)
			{
				throw new UpdatingException("ۑt@C܂B");
			}

			return myName;
		}

		//=========================================================================
		///	<summary>
		///		̃Gs\[h̘^t@Cۑֈړ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Store()
		{
			string		storeName, storeDir;

			if( !mHasFile )
				throw new EpisodeMethodException("t@Cw肳ĂȂ");
			if( mIsStored )
				throw new EpisodeMethodException("ɓ]");
			if( mIsBusy )
				throw new EpisodeMethodException("̂ߓ]łȂ");

			try
			{
				//----------------------
				// ԂɑJ
				//----------------------
				this.mIsBusy	= true;
				this.mIsDirty	= true;

				if (Settings.Default.saveFolder.Trim().Equals(""))
					throw new EpisodeMethodException("IvVōŏIۑ悪ݒ肳Ă܂B");

				if ( !File.Exists( mFilePath ) )
					throw new EpisodeMethodException("t@C݂Ȃ߁A]ł܂B" + mFilePath);

				storeDir = Settings.Default.saveFolder;	// ۑtH_

				//----------------------------------
				// ^CgƂ̃TutH_쐬
				//----------------------------------
				if (Settings.Default.classificatePrograms)
				{
					string subDir;

					subDir		= PathHelper.ToFileTitle(mParent.title);

					storeDir	= Path.Combine( storeDir, subDir );

					if (!Directory.Exists(storeDir))
						Directory.CreateDirectory(storeDir);
				}

				storeName = Path.Combine( storeDir, GetFormattedFileName() + Path.GetExtension(mFilePath) );

				File.Move( mFilePath + ".", storeName );

				//----------------------------------
				// tt@CꏏɈړ
				//----------------------------------
				if ( Settings.Default.copyWithOthers )
				{
					string []files;

					files = Directory.GetFiles(
								Path.GetDirectoryName( mFilePath ) + ".",
								Path.GetFileNameWithoutExtension( mFilePath ) + ".*" );
				
					foreach( string f in files )
					{
						// t@C"A.B.C"̂dgq".B.C"؂o
						string	fname;
						string	multiExt;
						for(fname = f;;)
						{
							if( string.IsNullOrEmpty( Path.GetExtension( fname ) ) )
								break;
							fname = Path.GetFileNameWithoutExtension(fname);
						}
						multiExt = Path.GetFileName(f).Substring( fname.Length );

						File.Move( f, Path.Combine( storeDir, GetFormattedFileName() + multiExt ) );
					}
				
				}

				//----------------------------------
				// ̃TufBNg폜
				//----------------------------------
				if ( Settings.Default.captureSubDir &&
					 Settings.Default.removeSubdir )
				{
					// ꏊK̘^tH_`FbN
					string subFolder, parentFolder;

					subFolder		= Path.GetDirectoryName( mFilePath + "." ) + ".";
					parentFolder	= Directory.GetParent( subFolder ).FullName;

					if ( Settings.Default.captureFolder.Equals( parentFolder ) )
					{
						string[] files;

						// ܂fBNg̃t@CSč폜Ă
						files = Directory.GetFiles( subFolder );
						foreach ( string f in files )
							File.Delete( f + "." );

						Directory.Delete( subFolder, true );
					}
				}

				this.mIsStored	= true;
				this.FilePath	= storeName;
			}
			catch (Exception ex)
			{
				throw;
			}
			finally
			{
				this.mIsBusy	= false;
				this.Dirty		= true;
			}
		}

		//=========================================================================
		///	<summary>
		///		t@CK̃t@CɃl[
		///	</summary>
		/// <remarks>
		///		ۑւ̈ړ͍sȂB
		/// </remarks>
		/// <history>2008/10/22 VK쐬</history>
		//=========================================================================
		public bool RenameFile( out string newName )
		{
			string		storeName;

			newName = null;

			if( !mHasFile )
				return false;

			if( !File.Exists( mFilePath ) )
				return false;

			try
			{
				string subDir = Path.GetDirectoryName(mFilePath);

				newName = Path.Combine(subDir, GetFormattedFileName() + Path.GetExtension(mFilePath));

				File.Move(mFilePath + ".", newName);

				mFilePath = newName;

			}
			catch (Exception)
			{
				newName = null;
				return false;
			}
			finally
			{
				this.Dirty = true;
			}

			return true;
		}

		//=========================================================================
		///	<summary>
		///		XML֏o
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Write(System.Xml.XmlWriter xw)
		{
			xw.WriteStartElement("Records");

			xw.WriteElementString("StoryNumber"		, Convert.ToString(mStoryNumber));
			// add yossiepon 20150705 begin
			xw.WriteElementString("StoryNoStr"		, mStoryNoStr);
            // add yossiepon 20150705 end
			xw.WriteElementString("FilePath"		, mFilePath);
			xw.WriteElementString("DateTime"		, Convert.ToString(mStartTime.Ticks));
			xw.WriteElementString("SubTitle"		, mSubTitle);
			xw.WriteElementString("Unread"			, mIsUnread ? "1":"0" );

			xw.WriteElementString("ThumbnailMaked"	, mThumbnailMaked ?"1":"0");

			xw.WriteElementString("HasPlan"			, mHasPlan.ToString()		);
			xw.WriteElementString("IsReserved"		, mIsReserved.ToString()	);
			xw.WriteElementString("ReserveStartTime", Convert.ToString(mReserveStartTime.Ticks));
			xw.WriteElementString("HasFile"			, mHasFile.ToString()		);
			xw.WriteElementString("IsReserveError"	, mIsReserveError.ToString());
			xw.WriteElementString("IsEncoded"		, mIsEncoded.ToString()		);
			xw.WriteElementString("IsStored"		, mIsStored.ToString()		);
			xw.WriteElementString("Length"			, mLength.ToString()		);
			xw.WriteElementString("RepeatNumber"	, mRepeatNumber.ToString()	);
			xw.WriteElementString("PlanError"		, mPlanError.ToString()		);

			xw.WriteEndElement();
		}

		//=========================================================================
		///	<summary>
		///		XMLǂݍ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Read(System.Xml.XmlReader xr)
		{
			while (xr.Read())
			{
				if (xr.NodeType == System.Xml.XmlNodeType.Element)
				{
					if (xr.LocalName.Equals("StoryNumber"))
						mStoryNumber = xr.ReadElementContentAsInt();
					// add yossiepon 20150705 begin
					else if (xr.LocalName.Equals("StoryNoStr"))
						mStoryNoStr = xr.ReadElementContentAsString();
                    // add yossiepon 20150705 end
					else if (xr.LocalName.Equals("FilePath"))
						mFilePath = xr.ReadElementContentAsString();
					// Ver1.9.18ȑÖȍ~
					else if (xr.LocalName.Equals("State"))
						MigrationState( (State)xr.ReadElementContentAsInt() );
					else if (xr.LocalName.Equals("SubTitle"))
						mSubTitle = xr.ReadElementContentAsString();
					else if (xr.LocalName.Equals("Unread"))
						mIsUnread = xr.ReadElementContentAsInt() == 1 ? true : false;
					else if (xr.LocalName.Equals("ThumbnailMaked"))
						mThumbnailMaked = xr.ReadElementContentAsInt() == 1 ? true : false;
					else if (xr.LocalName.Equals("DateTime"))
					{
						string strDateTime = xr.ReadElementContentAsString();
						mStartTime = new DateTime(Convert.ToInt64(strDateTime));
					}
					else if (xr.LocalName.Equals("HasPlan"))
						mHasPlan			= bool.Parse( xr.ReadElementContentAsString() );
					else if (xr.LocalName.Equals("IsReserved"))
						mIsReserved			= bool.Parse( xr.ReadElementContentAsString() );
					else if (xr.LocalName.Equals("ReserveStartTime"))
						mReserveStartTime	= new DateTime( Convert.ToInt64( xr.ReadElementContentAsString() ) );
					else if (xr.LocalName.Equals("HasFile"))
						mHasFile			= bool.Parse( xr.ReadElementContentAsString() );
					else if (xr.LocalName.Equals("IsReserveError"))
						mIsReserveError		= bool.Parse( xr.ReadElementContentAsString() );
					else if (xr.LocalName.Equals("IsEncoded"))
						mIsEncoded			= bool.Parse( xr.ReadElementContentAsString() );
					else if (xr.LocalName.Equals("IsStored"))
						mIsStored			= bool.Parse( xr.ReadElementContentAsString() );
					else if (xr.LocalName.Equals("Length"))
						mLength				= xr.ReadElementContentAsInt();
					else if (xr.LocalName.Equals("RepeatNumber"))
						mRepeatNumber		= xr.ReadElementContentAsInt();
					else if (xr.LocalName.Equals("PlanError"))
						PlanError			= bool.Parse( xr.ReadElementContentAsString() );
				}
				else if (xr.NodeType == System.Xml.XmlNodeType.EndElement)
					if (xr.LocalName.Equals("Records"))
						break;
			}

			// add yossiepon 20150705 begin
			if (mStoryNoStr.Length == 0)
			{
				mStoryNoStr = mStoryNumber.ToString(Settings.Default.storyNoFormat);
			}
			// add yossiepon 20150705 end
		}

		// Ver1.9.18ȑÕf[^ڍsp
		private void MigrationState( State state )
		{
			this.mHasPlan		= false;
			this.mHasFile		= false;
			this.mIsReserved	= false;
			this.mIsReserveError= false;
			this.mIsEncoded		= false;
			this.mIsStored		= false;

			switch( state )
			{
			case State.Notfound:
				this.mHasPlan		= true;
				break;
			case State.Planned:
				this.mHasPlan		= true;
				break;
			case State.Recorded:
				this.mHasPlan		= true;
				this.mHasFile		= true;
				break;
			case State.Encoded:
				this.mHasPlan		= true;
				this.mHasFile		= true;
				this.mIsEncoded		= true;
				break;
			case State.Stored:
				this.mHasPlan		= true;
				this.mHasFile		= true;
				this.mIsStored		= true;
				break;
			case State.Scheduling:
				this.mHasPlan		= true;
				this.mHasPlan		= true;
				this.mIsReserved	= true;
				break;
			case State.Changed:
				this.mHasPlan		= true;
				this.mIsReserved	= true;
				this.mReserveStartTime = DateTime.MinValue;	// <PENDING> 2009/12/28
				break;
			case State.LostSchedule:
				this.mHasPlan			= true;
				this.mIsReserveError	= true;
				break;
			}

		}
	}


}
