//=========================================================================
///	<summary>
///		mAgicAnimegCACR W[
///	</summary>
/// <remarks>
/// </remarks>
/// <history>2006/XX/XX VK쐬</history>
/// <history>2010/05/31 SubversionŊǗ邽ߌÂRg폜</history>
//=========================================================================
using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Collections;
using System.Threading;
using System.Runtime.InteropServices;
using System.Management;
using System.IO;
using magicAnime.Properties;
using Helpers;

namespace magicAnime.UserInterface
{
	//=========================================================================
	///	<summary>
	///		mAgicAnimegCACR NX
	///	</summary>
	/// <remarks>
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	//=========================================================================
	internal class TrayIcon
	{
		const	int		maxUnreadCount	= 10;	// o[ɕ\ő喢ǐ

		//-----------------
		// oϐ
		//-----------------
		internal NotifyIcon				mNotifyIcon;
		internal ContextMenuStrip		mTrayMenu;
		
		internal ToolStripSeparator		mTrayMenuUnreadSeparetor;
		private ToolStripMenuItem		mTrayRefreshMenu;
		private ToolStripSeparator		mToolStripMenuItem;
		private ToolStripMenuItem		mTrayExitMenu;
		private ToolStripMenuItem		mOpenWindowToolMenu;
		private System.Windows.Forms.Timer	mRefreshTimer;

		//=========================================================================
		///	<summary>
		///		gCACȐ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal void Initialize()
		{
			//---------------------------
			// gCACR̍쐬
			//---------------------------
			mNotifyIcon					= new NotifyIcon();
			mNotifyIcon.Icon			= Resources.mAigcAnimeLogo;
			mNotifyIcon.Visible			= Settings.Default.inTaskTray;
			mNotifyIcon.DoubleClick		+= notifyIcon_DoubleClick;
			mNotifyIcon.BalloonTipIcon	= ToolTipIcon.Info;
			mNotifyIcon.BalloonTipTitle	= "mAgicAnime";
			mNotifyIcon.Text			= "mAgicAnime Ver.7sh mod. yossiepon_20170930";
//			trayIcon.Icon = ((System.Drawing.Icon)(resources.GetObject( "notifyIcon.Icon" )));

			//---------------------------
			// gCj[̍쐬
			//---------------------------
			mTrayMenu				= new ContextMenuStrip();
			mTrayMenu.Opening		+= new System.ComponentModel.CancelEventHandler( trayMenu_Opening );
			this.mTrayMenu.SuspendLayout();

			mTrayMenuUnreadSeparetor	= new ToolStripSeparator();
			mTrayRefreshMenu			= new ToolStripMenuItem();
			mToolStripMenuItem		= new ToolStripSeparator();
			mOpenWindowToolMenu		= new ToolStripMenuItem();
			mTrayExitMenu			= new ToolStripMenuItem();

			mNotifyIcon.ContextMenuStrip	= mTrayMenu;

			// 
			// trayMenu
			// 
			this.mTrayMenu.Items.AddRange(
				new ToolStripItem[]
				{
					this.mTrayMenuUnreadSeparetor	,
					this.mTrayRefreshMenu			,
					this.mToolStripMenuItem			,
					this.mOpenWindowToolMenu			,
					this.mTrayExitMenu
				});
			this.mTrayMenu.Name = "trayMenu";
			this.mTrayMenu.Size = new System.Drawing.Size( 168, 82 );
			// 
			// trayMenuUnreadSeparetor
			// 
			this.mTrayMenuUnreadSeparetor.Name = "trayMenuUnreadSeparetor";
			this.mTrayMenuUnreadSeparetor.Size = new System.Drawing.Size( 164, 6 );
			// 
			// trayRefreshMenu
			// 
			this.mTrayRefreshMenu.Name = "trayRefreshMenu";
			this.mTrayRefreshMenu.Size = new System.Drawing.Size( 167, 22 );
			this.mTrayRefreshMenu.Text = "ŐVɍXV(&R)";
			this.mTrayRefreshMenu.Click += new System.EventHandler( this.RefreshMenu_Clicked );
			this.mTrayRefreshMenu.DropDownOpening += new System.EventHandler( this.RefreshMenu_DropDownOpening );
			// 
			// ToolStripMenuItem
			// 
			this.mToolStripMenuItem.Name = "ToolStripMenuItem";
			this.mToolStripMenuItem.Size = new System.Drawing.Size( 164, 6 );
			// 
			// openWindowToolMenu
			// 
			this.mOpenWindowToolMenu.Name = "openWindowToolMenu";
			this.mOpenWindowToolMenu.Size = new System.Drawing.Size( 167, 22 );
			this.mOpenWindowToolMenu.Text = "EBhEJ(&O)";
			this.mOpenWindowToolMenu.Click += new System.EventHandler( this.openWindowToolMenu_Clicked );
			// 
			// trayExitMenu
			// 
			this.mTrayExitMenu.Name = "trayExitMenu";
			this.mTrayExitMenu.Size = new System.Drawing.Size( 167, 22 );
			this.mTrayExitMenu.Text = "I(&X)";
			this.mTrayExitMenu.Click += new System.EventHandler( this.ExitMenu_Click );

			this.mTrayMenu.ResumeLayout();

			//---------------------------
			// ̑̏
			//---------------------------
			AnimeServer server = AnimeServer.GetInstance();

			server.mPopupSoonBallon += PopupSoonBalloon;

			//----------------
			// XV^C}
			//----------------
			mRefreshTimer			= new System.Windows.Forms.Timer();
			mRefreshTimer.Interval	= 100;
			mRefreshTimer.Enabled	= true;
			mRefreshTimer.Tick += delegate (object sender, EventArgs args)
			{
				AnimeServer				animServer = AnimeServer.GetInstance();
				AnimeServer.MyStatus	stat	   = animServer.GetStatus();

				// f[^XV̓gCACRύX
				mNotifyIcon.Icon	= stat.updateSequenceBusy
								? Resources.mAigcAnimeLogoBusy
								: Resources.mAigcAnimeLogo;
			};

			RefreshUnread();
		}

		//=========================================================================
		///	<summary>
		///		gCACR̃N[Abv
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2008/10/01 VK쐬</history>
		//=========================================================================
		internal void Cleanup()
		{
			AnimeServer server = AnimeServer.GetInstance();

			server.mPopupSoonBallon -= PopupSoonBalloon;
		}


		//=========================================================================
		///	<summary>
		///		gCj[Jꂽ̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		void trayMenu_Opening( object sender, System.ComponentModel.CancelEventArgs e )
		{
//			e.Cancel = true;
//			OnUpdateDocument();
		}


		//=========================================================================
		///	<summary>
		///		^XNACR_uNbNꂽAEBhE\
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void notifyIcon_DoubleClick(object sender, EventArgs e)
		{
			// ^XNgCACR畜A
			Program.ShowMainForm();
		}


		//=========================================================================
		///	<summary>
		///		[ŐVɍXV]j[̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void RefreshMenu_Clicked(object sender, EventArgs e)
		{
			AnimeServer.GetInstance().BeginUpdate(0);
		}

		private void RefreshMenu_DropDownOpening(object sender, EventArgs e)
		{

		}

		//=========================================================================
		///	<summary>
		///		[EBhEJ]j[̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void openWindowToolMenu_Clicked( object sender, EventArgs e )
		{
			Program.ShowMainForm();
		}

		//=========================================================================
		///	<summary>
		///		[I]j[̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void ExitMenu_Click(object sender, EventArgs e)
		{
			// IĂ悢Aeɖ₢킹
			if( Program.QueryClose() )
			{
				Application.Exit();
			}
		}

		//=========================================================================
		///	<summary>
		///		ǃj[ڂNbNꂽ̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void playUnreadMenu_DropDownItemClicked( object sender, EventArgs ar )
		{
			AnimeEpisode episode;

			try
			{
				ToolStripDropDownItem	dropItem = (ToolStripDropDownItem)sender;

				episode	= (AnimeEpisode)dropItem.Tag;

				Program.mMainForm.PlayMovie( episode.FilePath );

				episode.Unread = false;
			}
			catch (Exception ex)
			{
				MessageBox.Show(	null				,
									ex.Message			,
									"G["			,
									MessageBoxButtons.OK,
									MessageBoxIcon.Error);
			}
		}

		//=========================================================================
		///	<summary>
		///		ǃXgj[XV
		///	</summary>
		/// <remarks>
		///		f[^ύXCxggKƂĎsB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2008/05/03 \bhύX</history>
		//=========================================================================
		internal void RefreshUnread()
		{
			lock( this )
			{
				//----------------------------
				// j[̖ǈꗗNA
				//----------------------------

				int bottom = mTrayMenu.Items.IndexOf( mTrayMenuUnreadSeparetor );

				for ( int i = 0; i < bottom; ++i )
				{
					mTrayMenu.Items.RemoveAt( 0 );
				}

				if( !Settings.Default.disableUnread )
				{
					//--------------------------
					// ǈꗗj[ɒǉ
					//--------------------------
					uint count = 0;

					AnimeProgram.EnumRecordCallBack callBack
						= delegate(AnimeEpisode r, object param)
					{
						if (r.Unread && r.IsPlayable)
						{
							ToolStripItem item;

							if ( count < maxUnreadCount )	// \𐧌
							{
								try
								{
									item			= new ToolStripMenuItem( r.ToString() );
									item.Click		+= playUnreadMenu_DropDownItemClicked;
									item.Tag		= r;
									item.Visible	= true;
									mTrayMenu.Items.Insert( 0, item );

									count++;
								}
								catch(Exception ex)
								{
								}
							}
						}
					};

					AnimeServer.GetInstance().EnumAllEpisodes(callBack, null);	// ǂ񋓂

					if ( count == 0 )
					{
						//---------------------------------
						// gCj[(ǂȂ)ǉ
						//---------------------------------
						ToolStripMenuItem item;
						item			= new ToolStripMenuItem( "(ǂȂ)" );
						item.Enabled	= false;
						mTrayMenu.Items.Insert( 0, item );
					}
				}
			}
		}

		//=========================================================================
		///	<summary>
		///		ǃo[|bvAbv
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2007/12/23 MainFormړ</history>
		//=========================================================================
		internal void PopupUnreadBalloon()
		{
			List<AnimeEpisode> unreads = new List<AnimeEpisode>();

			// ǂ
			unreads = AnimeServer.GetInstance().QueryEpisode(
						ep => ep.Unread && ep.IsPlayable );

			//------------------------------
			// o[ɖǏԂ\
			//------------------------------
			{
				if( (0 < unreads.Count) && mNotifyIcon.Visible )
				{
				    string t = string.Format("ǂ̃Aj {0:0}{ ܂B\n", unreads.Count);

				    foreach ( AnimeEpisode r in unreads )
				    {
				        t += "\n" + r.ToString();
				    }
				    mNotifyIcon.BalloonTipText = t;
				    mNotifyIcon.ShowBalloonTip(3000);
				}
			}

		}

		//=========================================================================
		///	<summary>
		///		u܂Ȃԁvo[|bvAbv
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2008/10/01 VK쐬</history>
		//=========================================================================
		internal void PopupSoonBalloon(
			AnimeEpisode	episode )	// [i] Gs\[h
		{
			if( mNotifyIcon.Visible)
			{
				string  t;

				if( !episode.HasPlan )
					return;

				DateTimeHelper	dateTime = new DateTimeHelper(
					episode.StartDateTime				,
					Settings.Default.hoursPerDay -24	);

				t = "܂ȂԂł\n\n"
					+ dateTime.ToShortTimeString()
					+ " "
					+ episode.ToString();
				
			    mNotifyIcon.BalloonTipText = t;
			    mNotifyIcon.ShowBalloonTip(3000);
			}

		}

	}
}

