//=========================================================================
///	<summary>
///		ob`}l[W
///	</summary>
/// <remarks>
/// </remarks>
/// <history>2006/XX/XX VK쐬	Dr.Kurusugawa</history>
//=========================================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.IO;
using System.Threading;
using System.Windows.Forms;
using System.Collections;
using System.Diagnostics;

namespace magicAnime
{
	//=========================================================================
	///	<summary>
	///		ob`WuIuWFNg
	/// </summary>
	/// <remarks>
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	//=========================================================================
	public abstract class BatchJob
	{
		public abstract	void Do();				// Wȕs[]
		public virtual		void Cancel() {}		// WȕɃLZ[񓯊]
	}

	//=========================================================================
	///	<summary>
	///		ob`Wu}l[W
	/// </summary>
	/// <remarks>
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	/// <history>2008/11/16 oSstatic폜</history>
	//=========================================================================
// <MOD> 2008/11/16 ->
	public class BatchManager
//	public static class BatchManager
// <MOD> 2008/11/16 <-
	{
		//-------------------------
		// o
		//-------------------------
// <MOD> 2008/11/16 ->
		private BatchJob[]				currentJobs;		// s̃WuXg
		private List<Thread>			execThreadList;		// WuspXbhXg
		private List<AutoResetEvent>	stoppedFlags;		// XbhItOXg
//		private BatchJob				currentJob;			// s̃Wu
//		private static Thread			backGroundThread;	// WuspXbh
// <MOD> 2008/11/16 <-
		private bool					abortFlag;			// A{[gtO
		private Queue<BatchJob>		jobQueue;			// WuL[
		private readonly int			concurrentNums;		// ss
// <ADD> 2008/11/16 ->
		private Mutex					lockCallback;		// ʂւ̃R[obNr(1ɐ)
// <ADD> 2008/11/16 <-

// <MOD> 2008/11/16 Ō̃WutOǉ ->
		public delegate void OnProcessedEvent(BatchJob job,bool last);
		public event OnProcessedEvent ProcessedEvent;				// Wu̒ʒmCxg
// <MOD> 2008/11/16 <-
		public delegate void OnJobErrorEvent(string t);			// WuG[̒ʒmCxg
		public event OnJobErrorEvent JobErrorEvent;

		//-------------------------
		// \bh
		//-------------------------

// <MOD> 2008/11/16 ->
		internal BatchManager( int nums )
//		static BatchManager()
// <MOD> 2008/11/16 <-
		{
			jobQueue = new Queue<BatchJob>();
			abortFlag = false;

// <MOD> 2008/11/16 ->
			concurrentNums = nums;

			currentJobs		= new BatchJob[concurrentNums];

			execThreadList	= new List<Thread>();
			stoppedFlags	= new List<AutoResetEvent>();

			lockCallback	= new Mutex();

			//-----------------------------
			// n{̎spXbh
			//-----------------------------
			for( int i = 0 ; i < concurrentNums ; ++i )
			{
				int							threadNumber		= i;
				ParameterizedThreadStart	paramedThread;
				Thread						newThread;

				paramedThread	= new ParameterizedThreadStart( JobProc );
				newThread		= new Thread( paramedThread );

				execThreadList.Add( newThread );
				stoppedFlags.Add( new AutoResetEvent( false ) );
			}

			for( int i = 0 ; i < concurrentNums ; ++i )
			{
				execThreadList[ i ].Start( i );
			}
//			backGroundThread = new Thread(new ThreadStart(BackGroundProc));
//			backGroundThread.Start();
// <MOD> 2008/11/16 <-
		}

		//=========================================================================
		///	<summary>
		///		ob`}l[WI
		/// </summary>
		/// <remarks>
		///		SWuLZB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Finalize()
		{
#if DEBUG
			Logger.Output("Finalize");
#endif
			abortFlag = true;
// <MOD> 2008/11/16 ->
				CancelJobs();
//// <MOD> 2008/07/10 ->
//            CancelJobs();
//            CancelCurrentJob();
//            //lock (jobQueue)
//            //{
//            //    jobQueue.Clear();
//            //}
//// <MOD> 2008/07/10 <-
// <MOD> 2008/11/16 <-

			// Wusp̃Xbh҂킹
// <MOD> 2008/11/16 ->
			List<WaitHandle>	waits = new List<WaitHandle>();

			foreach( AutoResetEvent eve in stoppedFlags )
				waits.Add( eve );

// <PENDING> 2008/11/16 STAXbhŕnhWaitT|[gȂ ->
			foreach( WaitHandle handle in waits )
				handle.WaitOne();
//			WaitHandle.WaitAll( waits.ToArray() );
// <PENDING> 2008/11/16 <-

//			backGroundThread.Join();
// <MOD> 2008/11/16 <-
		}

		//=========================================================================
		///	<summary>
		///		ob`Xbh vV[W
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2008/11/16 WusΉ</history>
		//=========================================================================
		private void JobProc( object param )
//		private void BackGroundProc()
		{
			BatchJob	job;
			int			threadNumber = (int)param;

#if DEBUG
			Logger.Output("JobProc Jn");
			Logger.Output(string.Format("...threadNumber[{0:0}]", threadNumber));
#endif

			while( !abortFlag )
			{
				Thread.Sleep( 200 );

				job = PeekJob();

				while(job != null)
				{
					try
					{
						lock( currentJobs )
						{
							currentJobs[threadNumber] = job;
						}
//						currentJob = job;

						// fL[Wus
						job.Do();
					}
					catch (Exception e)
					{
						// ob`WułȏAO̓bZ[W\Oɏoׂ͂
						JobErrorEvent("(ob`WuG[) " + e.Message);
					}
					finally
					{
						lock( currentJobs )
						{
							currentJobs[threadNumber] = null;
						}
					}

					if ( !abortFlag )						// LZProcesedCxgsȂ
					{
						//-------------------------
						// ʂփWuʒm
						//-------------------------
// <MOD> 2008/11/16 ->
						if( lockCallback.WaitOne() )		// ʂւ̃R[obN͎ނ킸ɍsȂ
						{
							//------------------------------
							// Ō̃Wu𔻒
							//------------------------------
							bool	last		=	false;
							bool	executing	=	false;

							// Ɏs̃Wu邩
							lock( currentJobs )
							{
								for( int i = 0 ; i < concurrentNums ; ++i )
									executing |= (currentJobs[i] != null);
							}

							// uҋ@WuȂvusWuȂvȂ犮
							last = (JobCount == 0) && !executing;

							ProcessedEvent( job, last );

							lockCallback.ReleaseMutex();
						}
//						ProcessedEvent( job );			// WuʂR[obN
// <MOD> 2008/11/16 <-

						job = PeekJob();
					}
				}
			}

#if DEBUG
			Logger.Output(string.Format("JobProc({0}) ItOo", threadNumber));
#endif

			// XbhItOnm
			stoppedFlags[threadNumber].Set();
		}

		//=========================================================================
		///	<summary>
		///		Wu𓊓
		/// </summary>
		/// <remarks>
		///		WuIuWFNg͖邪AWu̓eǂ
		///		ʑŕۏႷ邱ƁB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void AddJob(BatchJob job)
		{
#if DEBUG
			Logger.Output("BatchManager::AddJob");
			Logger.Output(string.Format("...job:{0:0}", job.ToString()));
#endif
			lock (jobQueue)
			{
				// dēȂ悤`FbN
				// (Wuȅd`FbNBatchManagaer.ContainsōsĂ)
				if (!jobQueue.Contains(job))
					jobQueue.Enqueue(job);
// <ADD> 2008/08/09 ->
				else
					Logger.Output( "(G[) dWuIuWFNg̓" );
// <ADD> 2008/08/09 <-
			}

			Logger.Output("Wu - " + job.ToString());
		}

		//=========================================================================
		///	<summary>
		///		SWuLZ[]
		/// </summary>
		/// <remarks>
		///		SĂ̎s̃WuƑҋ@WuLZB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2008/11/16 CancelCurrentJobƓB</history>
		//=========================================================================
		public void CancelJobs()
		{
#if DEBUG
			Logger.Output("BatchManager::CancelJob");
#endif
			//----------------------------
			// ҋ@̃WuNA
			//----------------------------
			if (0 < jobQueue.Count)
				Logger.Output("ҋ@̑SWuLZ܂");

			lock (jobQueue)
			{
				jobQueue.Clear();
			}

			//------------------------------
			// s̃Wuɒ~
			//------------------------------
			BatchJob[]	cancelJobs;
			bool		executing	= false;

			lock( currentJobs )
			{
				cancelJobs = currentJobs;
			}

			foreach( BatchJob job in currentJobs )
				executing |= (job != null);

			if( executing )
			{
				Logger.Output("s̃WuLZĂ܂...");

				for( int i = 0 ; i < concurrentNums ; ++i )
				{
					BatchJob	job = cancelJobs[ i ];

					if( job != null )
					{
						Logger.Output( string.Format( "...Wu:{0}", job.ToString() ) );
						job.Cancel();

						//----------------------------
						// Wu~̂ҋ@
						//----------------------------
						bool		stopped		= false;
						DateTime	baseTime	= DateTime.Now;
		
						Logger.Output( "......Wu~҂" );

						for(;;)
						{
							lock( currentJobs )
							{
								stopped =	(currentJobs[ i ] != job)
										||	(currentJobs[ i ] == null);
							}
							if( stopped )
							{
								Logger.Output( ".........OK" );
								break;
							}

							long passage = (long)DateTime.Now.Subtract( baseTime ).TotalMilliseconds;
							if( 5000 < passage )
							{
							    Logger.Output( ".........^CAEg" );
							    break;
							}

							Thread.Sleep( 100 );
						}
					}
				}
			}

		}

// <DEL> 2008/11/16 ->
		////=========================================================================
		/////	<summary>
		/////		s̃WuLZ
		///// </summary>
		///// <remarks>
		///// </remarks>
		///// <history>2006/XX/XX VK쐬</history>
		////=========================================================================
		//public void CancelCurrentJob()
		//{
		//    if ( currentJob != null )
		//    {
		//        currentJob.Cancel();
		//    }
		//}
// <DEL> 2008/11/16 <-

		//=========================================================================
		///	<summary>
		///		WuIuWFNgL[o
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private BatchJob PeekJob()
		{
			BatchJob job;

			lock (jobQueue)
			{
				if (jobQueue.Count > 0)
					job = jobQueue.Dequeue();
				else
					job = null;
			}

			//Console.WriteLine("GR[hWu擾܂");

			return job;
		}

		//=========================================================================
		///	<summary>
		///		L[COĂWu̐Ԃ
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public int JobCount
		{
			get
			{
				lock (jobQueue)
				{
					return jobQueue.Count;
				}
			}
		}

		//=========================================================================
		///	<summary>
		///		L[COĂWũXgԂ
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public BatchJob[] GetQueueingJobs()
		{
			BatchJob[] jobs;
			lock (jobQueue)
			{
				jobs = new BatchJob[jobQueue.Count];
				jobs = jobQueue.ToArray();
			}
			return jobs;
		}

		//=========================================================================
		///	<summary>
		///		s̃WuԂ
		/// </summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2008/11/16 ss̃WuĂɕԂ</history>
		//=========================================================================
		public BatchJob[] GetCurrentJob()
		{
			BatchJob[] jobs;
			lock( currentJobs )
			{
				jobs = currentJobs;
			}
			return jobs;
		}

		//=========================================================================
		///	<summary>
		///		WuIuWFNgɃL[COĂ邩Ԃ
		/// </summary>
		/// <remarks>
		///		Wu̓eł邩͍̔sȂB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public bool Contains(BatchJob target)
		{
			lock (jobQueue)
			{
				foreach (BatchJob job in jobQueue)
				{
					if (job.Equals(target))
					{
						return true;
					}
				}
			}
			return false;
		}

	}
}
