﻿using CleanAuLait.Domain.Service;
using CleanAuLait.UseCase.Interactor;
using CleanAuLait.UseCase.Response;
using TestNarou3.Domain.Boundary.Service;
using TestNarou3.Domain.Model.Entity;
using TestNarou3.UseCase.Boundary.Interactor;
using TestNarou3.UseCase.Boundary.Presenter;
using TestNarou3.UseCase.Request;
using TestNarou3.UseCase.Response;

namespace TestNarou3.UseCase.Interactor
{
    internal class NarouRefreshBookmarkDetailListInteractor
            : AbstractUseCaseInteractor<
                    NarouRefreshBookmarkDetailListRequest,
                    NarouRefreshBookmarkDetailListResponse>
            , INarouRefreshBookmarkDetailListInteractor
    {
        private readonly INarouService service;
        private readonly INarouRefreshBookmarkDetailListPresenter presenter;

        public NarouRefreshBookmarkDetailListInteractor(
                INarouService service,
                INarouRefreshBookmarkDetailListPresenter presenter)
        {
            this.service = service;
            this.presenter = presenter;
        }

        public override NarouRefreshBookmarkDetailListResponse
                Interact(NarouRefreshBookmarkDetailListRequest req)
        {
            try
            {
                BookmarkDetailList list = this.service.GetBookmarkDetailList(req.CategoryNo);

                NarouRefreshBookmarkDetailListResponse res = new(list);

                return presenter.Present(req, res);
            }
            catch (ServiceException e)
            {
                return UseCaseResponse.Abort<NarouRefreshBookmarkDetailListResponse>(e.Message);
            }
        }

    }
}
