﻿using NLog;
using ObservableCollections;
using System;
using System.Collections.Generic;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Domain.Model.Entity
{
    public record class BookmarkCategory(
        ObservableList<BookmarkCategoryRow> Rows
    ) : IDisposable
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        private bool disposedValue;

        public BookmarkCategory() : this(
            Rows: new()
        )
        {
        }

        public void Refresh(IEnumerable<BookmarkCategoryRow> rows)
        {
            this.Rows.Clear();
            this.Rows.AddRange(rows);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    foreach (var row in Rows)
                    {
                        row.Dispose();
                    }

                    logger.Trace("BookmarkCategory disposed.");
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }
    }
}
