﻿using AutoMapper;
using Reactive.Bindings;
using System;
using System.Linq;
using System.Reactive.Linq;

namespace TestNarou3.Adaptor.Translator.Converter
{
    internal class FlagConverter
            : IValueConverter<IObservable<int>, ReadOnlyReactiveProperty<string>>
    {
        private readonly string on;
        private readonly string off;

        public FlagConverter(string on) : this(on, null)
        {
        }

        public FlagConverter(string on, string off)
        {
            this.on = on ?? string.Empty;
            this.off = off ?? string.Empty;
        }

        public ReadOnlyReactiveProperty<string> Convert(
                IObservable<int> sourceMember, ResolutionContext context)
        {
            return sourceMember
                    .Select(v => v == 1 ? this.on : this.off)
                    .ToReadOnlyReactiveProperty();
        }
    }
}
