﻿using AutoMapper;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel.Child;
using TestNarou3.Adaptor.Gateway.ViewModel.Child;
using TestNarou3.Adaptor.Translator.Converter;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Adaptor.Translator
{
    internal class BookmarkDetailListRowViewModelTranslator
            : IBookmarkDetailListRowViewModelTranslator
    {
        private readonly IMapper mapper;

        public BookmarkDetailListRowViewModelTranslator(IMapper mapper)
        {
            this.mapper = mapper;
        }

        public IBookmarkDetailListRowViewModel Translate(
                BookmarkDetailListRow row, IBookmarkDetailListViewModel parent)
        {
            IBookmarkDetailListRowViewModel rowVm = row != null
                    ? mapper.Map(row, new BookmarkDetailListRowViewModel(row, parent))
                    : null;

            return rowVm;
        }

        internal static void ConfigureMapper(
                IMappingExpression<BookmarkDetailListRow, BookmarkDetailListRowViewModel> mappingExpression)
        {
            mappingExpression
                    .ForMember(d => d.NCode,
                            opts => opts.MapFrom(s => s.NCode))
                    .ForMember(d => d.Summary,
                            opts => opts.MapFrom<SummaryResolver>())
                    .ForMember(d => d.Title,
                            opts => opts.MapFrom(s => s.Title
                                    .ToReadOnlyReactiveProperty(null, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.Writer,
                            opts => opts.MapFrom(s => s.Writer
                                    .ToReadOnlyReactiveProperty(null, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.End,
                            opts => opts.ConvertUsing(new FlagConverter(null, "✓"), s => s.End))
                    .ForMember(d => d.GeneralAllNo,
                            opts => opts.MapFrom(s => s.GeneralAllNo
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.Time,
                            opts => opts.ConvertUsing(new MinToHourConverter(), s => s.Time))
                    .ForMember(d => d.IsStop,
                            opts => opts.ConvertUsing(new FlagConverter("✓"), s => s.IsStop))
                    .ForMember(d => d.GlobalPoint,
                            opts => opts.MapFrom(s => s.GlobalPoint
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.MinPerAllNo,
                            opts => opts.MapFrom<MinPerAllNoResolver>())
                    .ForMember(d => d.PointPerMin,
                            opts => opts.MapFrom<PointPerMinResolver>())
                    .ForMember(d => d.DailyPoint,
                            opts => opts.MapFrom(s => s.DailyPoint
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.WeeklyPoint,
                            opts => opts.MapFrom(s => s.WeeklyPoint
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.MonthlyPoint,
                            opts => opts.MapFrom(s => s.MonthlyPoint
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.QuarterPoint,
                            opts => opts.MapFrom(s => s.QuarterPoint
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.YearlyPoint,
                            opts => opts.MapFrom(s => s.YearlyPoint
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.FavNovelCnt,
                            opts => opts.MapFrom(s => s.FavNovelCnt
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.ImpressionCnt,
                            opts => opts.MapFrom(s => s.ImpressionCnt
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.ReviewCnt,
                            opts => opts.MapFrom(s => s.ReviewCnt
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.AllPoint,
                            opts => opts.MapFrom(s => s.AllPoint
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.AllHyokaCnt,
                            opts => opts.MapFrom(s => s.AllHyokaCnt
                                    .ToReadOnlyReactiveProperty(0, ReactivePropertyMode.Default, null, null)))
                    .ForMember(d => d.GeneralFirstUp,
                            opts => opts.ConvertUsing(new SubstringConverter(10), s => s.GeneralFirstUp))
                    .ForMember(d => d.GeneralLastUp,
                            opts => opts.ConvertUsing(new SubstringConverter(10), s => s.GeneralLastUp))
                    .ForMember(d => d.NovelUpdatedAt,
                            opts => opts.ConvertUsing(new SubstringConverter(10), s => s.NovelUpdatedAt))
                    .ForMember(d => d.Parent,
                            opts => opts.Ignore())
                    .ForMember(d => d.Source,
                            opts => opts.Ignore())

                    .DisableCtorValidation()
                    .AfterMap<BookmarkDetailListRowViewModel.AfterMap>();
        }
    }
}
