﻿using TestNarou3.Adaptor.Boundary.Controller;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.UseCase.Boundary.Presenter;
using TestNarou3.UseCase.Request;
using TestNarou3.UseCase.Response;

namespace TestNarou3.Adaptor.Presenter
{
    internal class NarouRefreshBookmarkDetailListPresenter
            : INarouRefreshBookmarkDetailListPresenter
    {
        private readonly IBookmarkDetailListViewModel vm;

        public NarouRefreshBookmarkDetailListPresenter(
                IBookmarkDetailListViewModel vm
        )
        {
            this.vm = vm;
        }

        public NarouRefreshBookmarkDetailListResponse Present(
                NarouRefreshBookmarkDetailListRequest req,
                NarouRefreshBookmarkDetailListResponse res
        )
        {
            this.vm.SynchronizeWith(res.DetailList);

            return res;
        }
    }
}
