﻿using CleanAuLait.Adaptor.Boundary.Controller;
using CleanAuLait.Adaptor.Controller;
using CleanAuLait.Adaptor.Controller.DI;
using NLog;
using Prism.Regions;
using TestNarou3.Adaptor.Boundary.Controller;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Domain.Model.Entity;
using TestNarou3.UseCase.Request;

namespace TestNarou3.Adaptor.Controller
{
    internal class AppWindowController
            : AbstractWindowController, IAppWindowController
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        private readonly IRegionManager rm;

        public AppWindowController(
                IRequestScopeGenerator scopedGenerator,
                IHandlerContextFactory contextFactory,
                IRegionManager rm)
                        : base(scopedGenerator, contextFactory)
        {
            this.rm = rm;
        }

        public void NavigateLoginFormView()
        {
            logger.Trace("NavigateLoginFormView");

            this.rm.RequestNavigate(
                    IMainWindowViewModel.REGION_NAME, ILoginFormViewModel.URI);
        }

        public void NavigateBookmarkView()
        {
            logger.Trace("NavigateBookmarkView");

            this.rm.RequestNavigate(
                    IMainWindowViewModel.REGION_NAME, IBookmarkViewModel.URI);
        }

        public void NavigateBookmarkListView(int categoryNo)
        {
            logger.Trace("NavigateBookmarkListView: categoryNo {0}", categoryNo);

            NarouRefreshBookmarkDetailListRequest req = new(categoryNo);

            _ = Execute(req);
        }

    }
}
