﻿using CleanAuLait.Adaptor.Boundary.Controller.Router;
using CleanAuLait.Adaptor.Controller;
using CleanAuLait.Adaptor.Controller.Handler;
using CleanAuLait.Adaptor.Controller.Router;
using NLog;
using Prism.Ioc;
using Prism.Modularity;
using TestNarou3.Adaptor.Boundary.Controller;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Adaptor.Controller;
using TestNarou3.Adaptor.Gateway.ViewModel;
using TestNarou3.Adaptor.Presenter;
using TestNarou3.Adaptor.Translator;
using TestNarou3.UseCase.Boundary.Presenter;

namespace TestNarou3.Adaptor
{
    public class AdaptorModule : IModule
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        public static readonly string ENSURE_STRONG_REFERRENCE = "";

        public void RegisterTypes(IContainerRegistry containerRegistry)
        {
            //
            // Controller
            //

            containerRegistry.RegisterSingleton<IAppWindowController, AppWindowController>();

            //
            // Handler Context Factory
            //

            HandlerContextFactoryRegistrar handlerContextFactoryRegistrar = new(containerRegistry);

            handlerContextFactoryRegistrar.Add(AppWindowController.DEFAULT_HANDLER_QUEUE, new Type[]
            {
                typeof(SimpleUserDialogErrorHandler),
                typeof(IUseCaseRouter),
            });

            handlerContextFactoryRegistrar.Register();

            //
            // Handler
            //

            containerRegistry.RegisterSingleton<SimpleUserDialogErrorHandler>();

            //
            // Router
            //

            containerRegistry.RegisterSingleton<IUseCaseRouter, UseCaseRouter>();

            //
            // ViewModels
            //

            containerRegistry.RegisterSingleton<IMainWindowViewModel, MainWindowViewModel>();

            containerRegistry.RegisterSingleton<ILoginFormViewModel, LoginFormViewModel>();
            containerRegistry.RegisterSingleton<IBookmarkViewModel, BookmarkViewModel>();

            containerRegistry.RegisterSingleton<IBookmarkCategoryViewModel, BookmarkCategoryViewModel>();
            containerRegistry.RegisterSingleton<IBookmarkDetailListViewModel, BookmarkDetailListViewModel>();

            //
            // Translators
            //

            containerRegistry.RegisterSingleton<IBookmarkCategoryRowViewModelTranslator, BookmarkCategoryRowViewModelTranslator>();
            containerRegistry.RegisterSingleton<IBookmarkDetailListRowViewModelTranslator, BookmarkDetailListRowViewModelTranslator>();

            //
            // Presenters
            //

            containerRegistry.RegisterSingleton<IAppConfigLoadPresenter, AppConfigLoadPresenter>();

            containerRegistry.RegisterSingleton<INarouLoginPresenter, NarouLoginPresenter>();
            containerRegistry.RegisterSingleton<INarouRefreshBookmarkDetailListPresenter, NarouRefreshBookmarkDetailListPresenter>();

            logger.Trace("RegisterTypes end");
        }

        public void OnInitialized(IContainerProvider containerProvider)
        {
        }
    }
}
