//******************************************************************************
//
// MIDITrail / MTPianoKeyboardDesignMod
//
// sAmL[{[hfUCModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "DXColorUtil.h"
#include "MTConfFile.h"
#include "MTPianoKeyboardDesignMod.h"


//******************************************************************************
// p[^`
//******************************************************************************
//eNX`WZoFrbg}bvTCY = 562 x 562
#define TEXTURE_POINT(x, y)  (D3DXVECTOR2((float)x/561.0f, (float)y/561.0f))

//******************************************************************************
// RXgN^
//******************************************************************************
MTPianoKeyboardDesignMod::MTPianoKeyboardDesignMod(void)
{
	//_Initialize()ŊNX̏Ă΂邽߁ANX̃RXgN^͌ĂяoȂ
	_Initialize();
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTPianoKeyboardDesignMod::~MTPianoKeyboardDesignMod(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int MTPianoKeyboardDesignMod::Initialize(
		const TCHAR* pSceneName,
		SMSeqData* pSeqData
	)
{
	int result = 0;

	//NX̏Ăяo
	MTPianoKeyboardDesign::Initialize(pSceneName, pSeqData);

	//ݒt@Cǂݍ
	result = _LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTPianoKeyboardDesignMod::_Initialize()
{
	unsigned long i = 0;

	//NX̏Ăяo
	MTPianoKeyboardDesign::_Initialize();

	for (i = 0; i < 16; i++) {
		m_ActiveKeyColorList[i] = DXColorUtil::MakeColorFromHexRGBA(_T("FF0000FF")); //ݒt@C
	}

	return;
}

//******************************************************************************
// |[g_YW擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetPortOriginY(
		unsigned char portNo
	)
{
	return 0;
}

//******************************************************************************
// |[g_ZW擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetPortOriginZ(
		unsigned char portNo
	)
{

	return 0;
}

//******************************************************************************
// `lԊu擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetChStep()
{
	return m_ChStep;
}

//******************************************************************************
// L[J[擾
//******************************************************************************
D3DXCOLOR MTPianoKeyboardDesignMod::GetActiveKeyColor(
		unsigned char chNo,
		unsigned char noteNo,
		unsigned long elapsedTime,
		D3DXCOLOR* pNoteColor
	)
{
	D3DXCOLOR color;
	float r,g,b,a = 0.0f;
	float rate = 0.0f;
	unsigned long duration = 0;

	//          on     off
	//    |---+......+---- offɂȂ甒̐Fɖ߂
	//      |   :      :
	//      |   :  +---+     offɂȂ܂ŒԐF̂܂
	//      |   : /:   :
	//      |   :/ :   :
	//    |   +  :   :     L[̐Fiԁj
	//      |   :\ :   :
	//      |   : \:   :
	//      |   :  +---+     offɂȂ܂ŒԐF̂܂
	//      |   :  :   :
	//    |---+  :   +---- offɂȂ獕̐Fɖ߂
	//   ---+---*------*-------> +t
	//      |   on :   off
	//          <-->duration

	if ((pNoteColor != NULL) && (m_ActiveKeyColorType == NoteColor)) {
		//m[gFw肳Ăꍇ
		color = *pNoteColor;
	}
	else {
		//ȊO̓ftHgFƂ
		color = m_ActiveKeyColorList[chNo];
	}

	duration = (unsigned long)m_ActiveKeyColorDuration;
	rate     = m_ActiveKeyColorTailRate;

	if (elapsedTime < duration) {
		rate = ((float)elapsedTime / (float)duration) * m_ActiveKeyColorTailRate;
	}

	if (GetKeyType(noteNo) == KeyBlack) {
		r = color.r - ((color.r) * rate);
		g = color.g - ((color.g) * rate);
		b = color.b - ((color.b) * rate);
		a = color.a;
	}
	else {
		r = color.r + ((1.0f - color.r) * rate);
		g = color.g + ((1.0f - color.g) * rate);
		b = color.b + ((1.0f - color.b) * rate);
		a = color.a;
	}
	color = D3DXCOLOR(r, g, b, a);

	return color;
}

//******************************************************************************
// L[{[hW擾
//******************************************************************************
D3DXVECTOR3 MTPianoKeyboardDesignMod::GetKeyboardBasePos(
		unsigned char portNo,
		unsigned char chNo,
		float scale
	)
{
	float ox, oy, oz = 0.0f;

	//|[gPʂ̌_W
	ox = GetPortOriginX(portNo);
	oy = GetPortOriginY(portNo);
	oz = GetPortOriginZ(portNo);

	return D3DXVECTOR3(ox, oy, oz);
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTPianoKeyboardDesignMod::_LoadConfFile(
		const TCHAR* pSceneName
	)
{
	int result = 0;
	TCHAR key[21] = {_T('\0')};
	TCHAR hexColor[16] = {_T('\0')};
	unsigned long i = 0;
	MTConfFile confFile;

	//NX̓ǂݍݏĂяo
	result = MTPianoKeyboardDesign::_LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

	//ݒt@CJ
	result = confFile.Initialize(pSceneName);
	if (result != 0) goto EXIT;

	//----------------------------------
	//XP[
	//----------------------------------
	result = confFile.SetCurSection(_T("Scale"));
	if (result != 0) goto EXIT;
	result = confFile.GetFloat(_T("ChStep"), &m_ChStep, 0.5f);
	if (result != 0) goto EXIT;

	//----------------------------------
	//F
	//----------------------------------
	result = confFile.SetCurSection(_T("PianoKeyboard"));
	if (result != 0) goto EXIT;

	//̃L[F擾
	for (i = 0; i < 16; i++) {
		_stprintf_s(key, 21, _T("Ch-%02d-ActiveKeyColor"), i+1);
		result = confFile.GetStr(key, hexColor, 16, _T("FF0000FF"));
		if (result != 0) goto EXIT;

		m_ActiveKeyColorList[i] = DXColorUtil::MakeColorFromHexRGBA(hexColor);
	}

EXIT:;
	return result;
}


