//******************************************************************************
//
// Simple MIDI Library / SMRcpConv
//
// RCPt@CϊNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "shlwapi.h"
#include "YNBaseLib.h"
#include "SMRcpConv.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMRcpConv::SMRcpConv(void)
{
	m_hModule = NULL;
	m_pFuncConvertFile = NULL;
	m_pFuncSaveSMF = NULL;
	m_pFuncDeleteObject = NULL;
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMRcpConv::~SMRcpConv(void)
{
	_Release();
}

//******************************************************************************
// 
//******************************************************************************
int SMRcpConv::Initialize()
{
	int result = 0;
	TCHAR dllFilePath[_MAX_PATH] = {_T('\0')};

	_Release();

	//vZXst@CfBNgpX擾
	result = YNPathUtil::GetModuleDirPath(dllFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	//DLLt@CpX
	_tcscat_s(dllFilePath, _MAX_PATH, _T("RCPCV.DLL"));

	//DLL݊mF
	if (!PathFileExists(dllFilePath)) {
		//DLL݂Ȃ̂ŉI
		goto EXIT;
	}

	//DLLǂݍ
	//  LoadLibrary / FreeLibrary APIŎQƃJEgǗ邽
	//  {NX̃CX^X݂ĂȂ
	m_hModule = LoadLibrary(dllFilePath);
	if (m_hModule == NULL) {
		result = YN_SET_ERR("LoadLibrary Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

	//֐|C^擾FrcpcvConvertFile
	m_pFuncConvertFile = (RCPCV_ConvertFile)GetProcAddress(m_hModule, "rcpcvConvertFile");
	if (m_pFuncConvertFile == NULL) {
		result = YN_SET_ERR("GetProcAddress Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

	//֐|C^擾FrcpcvSaveSMF
	m_pFuncSaveSMF = (RCPCV_SaveSMF)GetProcAddress(m_hModule, "rcpcvSaveSMF");
	if (m_pFuncSaveSMF == NULL) {
		result = YN_SET_ERR("GetProcAddress Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

	//֐|C^擾FrcpcvDeleteObject
	m_pFuncDeleteObject = (RCPCV_DeleteObject)GetProcAddress(m_hModule, "rcpcvDeleteObject");
	if (m_pFuncDeleteObject == NULL) {
		result = YN_SET_ERR("GetProcAddress Error. (rcpcv.dll)", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	if (result != 0) {
		_Release();
	}
	return result;
}

//******************************************************************************
// gp۔
//******************************************************************************
bool SMRcpConv::IsAvailable()
{
	bool isAvailable = false;

	if (m_hModule != NULL) {
		isAvailable = true;
	}

	return isAvailable;
}

//******************************************************************************
// t@Cϊ
//******************************************************************************
int SMRcpConv::Convert(
		const TCHAR* pRCPPath,
		const TCHAR* pSMFPath
	)
{
	int result = 0;
	int apiresult = 0;
	DWORD hRCPCV = 0;

	if (!IsAvailable()) {
		result = YN_SET_ERR("Program Error.", 0, 0);
		goto EXIT;
	}

	try {

		//RCPt@Cǂݍ
		hRCPCV = (*m_pFuncConvertFile)(
						pRCPPath,	//t@CpX
						0,			//R[obNʁFȂ
						NULL,		//R[obN֐^EBhEnhFȂ
						0,			//EBhEbZ[WFȂ
						0			//CX^XʗpIDFȂ
					);
		if (hRCPCV == 0) {
			result = YN_SET_ERR("File read error.", 0, 0);
			goto EXIT;
		}

		//SMFo
		apiresult = (*m_pFuncSaveSMF)(hRCPCV, pSMFPath);
		if (apiresult != 1) {
			result = YN_SET_ERR("File save error.", apiresult, 0);
			goto EXIT;
		}

	}
	catch (...) {
		result = YN_SET_ERR("Exception occurred. (rcpcv.dll)", 0, 0);
		goto EXIT;
	}

EXIT:;
	if (hRCPCV != 0) {
		(*m_pFuncDeleteObject)(hRCPCV);
	}
	return result;
}

//******************************************************************************
// [X
//******************************************************************************
void SMRcpConv::_Release()
{
	if (m_hModule != NULL) {
		FreeLibrary(m_hModule);
		m_hModule = NULL;
	}
}

//******************************************************************************
// gqɂT|[gΏۃt@C
//******************************************************************************
bool SMRcpConv::IsSupportFileExt(
		const TCHAR* pFilePath
	)
{
	bool isSupport = false;

	if (YNPathUtil::IsFileExtMatch(pFilePath, ".rcp")
	 || YNPathUtil::IsFileExtMatch(pFilePath, ".r36")
	 || YNPathUtil::IsFileExtMatch(pFilePath, ".g36")) {
		isSupport = true;
	}

	return isSupport;
}

//******************************************************************************
// GetOpenFileNamept@CtB^擾
//******************************************************************************
const TCHAR* SMRcpConv::GetOpenFileNameFilter()
{
	TCHAR* pFilter =
		_T("MIDI File (*.mid *.rcp *.r36 *.g36)\0*.mid;*.rcp;*.r36;*.g36\0")
		_T("Standard MIDI File (*.mid)\0*.mid\0")
		_T("Recomposer Data File (*.rcp *.r36 *.g36)\0*.rcp;*.r36;*.g36\0")
		_T("\0");
	return pFilter;
}

} // end of namespace

