//******************************************************************************
//
// MIDITrail / MTPictBoard
//
// sN`{[h`NX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// sN`{[h`悷B
// 摜t@C .bmp .dds .dib .jpg .png .tga w\B
// iD3DXCreateTextureFromFile T|[gĂ摜j

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesign.h"

using namespace SMIDILib;


//******************************************************************************
//  sN`{[h`NX
//******************************************************************************
class MTPictBoard
{
public:

	//RXgN^^fXgN^
	MTPictBoard(void);
	virtual ~MTPictBoard(void);

	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, SMSeqData* pSeqData);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, D3DXVECTOR3 camVector, float rollAngle);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
	void Reset();

	//tJnI
	void OnPlayStart();
	void OnPlayEnd();

	//\ݒ
	void SetEnable(bool isEnable);

private:

	DXPrimitive m_Primitive;
	LPDIRECT3DTEXTURE9 m_pTexture;
	D3DXIMAGE_INFO m_ImgInfo;
	unsigned long m_CurTickTime;
	bool m_isPlay;
	bool m_isEnable;
	MTNoteDesign m_NoteDesign;

	//_obt@\
	struct MTPICTBOARD_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
		D3DXVECTOR2 t;	//eNX`摜ʒu
	};

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1); }

	int _CreateVertexOfBoard(
			MTPICTBOARD_VERTEX* pVertex,
			unsigned long* pIbIndex
		);

	int _LoadTexture(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName);

};

