//******************************************************************************
//
// MIDITrail / MTPianoKeyboardCtrlMod
//
// sAmL[{[hModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTPianoKeyboardCtrl.h"
#include "MTPianoKeyboardDesignMod.h"
#include "MTNoteDesignMod.h"


//******************************************************************************
// sAmL[{[hModNX
//******************************************************************************
class MTPianoKeyboardCtrlMod : public MTPianoKeyboardCtrl
{
public:

	//RXgN^^fXgN^
	MTPianoKeyboardCtrlMod(void);
	virtual ~MTPianoKeyboardCtrlMod(void);

	//
	virtual int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			SMSeqData* pSeqData,
			MTNotePitchBend* pNotePitchBend,
			bool isSingleKeyboard
		);

	//XV
	int Transform(
			LPDIRECT3DDEVICE9 pD3DDevice,
			D3DXVECTOR3 camVector,
			D3DXVECTOR3 lookVector,
			float rollAngle
		);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//Zbg
	void Reset();

protected:

	int _CreateKeyboards(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, SMSeqData* pSeqData);

private:

	//m[gfUC
	MTNoteDesignMod m_NoteDesignMod;

	//L[{[hfUC
	MTPianoKeyboardDesignMod m_KeyboardDesignMod;

	//ANeBu|[gtO
	bool m_isActivePort[SM_MAX_PORT_NUM];

	//L[z
	float m_KeyDownRateMod[SM_MAX_CH_NUM][SM_MAX_CH_NUM][SM_MAX_NOTE_NUM];

	virtual int _UpdateNoteStatus(
				unsigned long playTimeMSec,
				unsigned long keyDownDuration,
				unsigned long keyUpDuration,
				SMNote note,
				NoteStatus* pNoteStatus
			);
	virtual int _UpdateVertexOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);

	float _GetMaxPitchBendShift(int keyboardIndex);
	float _GetMaxPitchBendShift(int keyboardIndex, float max);
};


