//******************************************************************************
//
// MIDITrail / MTNoteRainLive
//
// Cuj^pm[gC`NX
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// Cuj^pm[gC`悷B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesign.h"
#include "MTNotePitchBend.h"
#include "MTPianoKeyboardDesign.h"


//******************************************************************************
// p[^`
//******************************************************************************
//ő唭m[g`搔
#define MTNOTERAIN_MAX_LIVENOTE_NUM  (2048)

// TODO: őm[g`搔ςɂ

//******************************************************************************
// Cuj^pm[gC`NX
//******************************************************************************
class MTNoteRainLive
{
public:
	
	//RXgN^^fXgN^
	MTNoteRainLive(void);
	virtual ~MTNoteRainLive(void);
	
	//
	int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			MTNotePitchBend* pNotePitchBend
		);
	
	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);
	
	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//
	void Release();
	
	//Zbg
	void Reset();
	
	//m[gONo^
	void SetNoteOn(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo,
			unsigned char velocity
		);
	
	//m[gOFFo^
	void SetNoteOff(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo
		);
	
	//Sm[gOFF
	void AllNoteOff();
	void AllNoteOffOnCh(unsigned char portNo, unsigned char chNo);
	
private:
	
	//m[g\
	struct NoteStatus {
		bool isActive;
		unsigned char portNo;
		unsigned char chNo;
		unsigned char noteNo;
		unsigned long startTime;
		unsigned long endTime;
	};
	
	//_obt@\
	struct MTNOTERAIN_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
	};
	
private:
	
	//m[gfUC
	MTNoteDesign m_NoteDesign;
	
	//L[{[hfUC
	MTPianoKeyboardDesign m_KeyboardDesign;
	
	//m[gC
	DXPrimitive m_PrimitiveNotes;
	unsigned long m_NoteNum;
	NoteStatus* m_pNoteStatus;
	
	//sb`xh
	MTNotePitchBend* m_pNotePitchBend;
	
	//Cuj^\ԁi~bj
	unsigned long m_LiveMonitorDisplayDuration;
	
	//_obt@FVFtH[}bg
	unsigned long _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }
	
	int _CreateNoteRain(LPDIRECT3DDEVICE9 pD3DDevice);
	int _CreateNoteStatus();
	
	int _CreateVertexOfNote(
			NoteStatus noteStatus,
			MTNOTERAIN_VERTEX* pVertex,
			unsigned long vertexOffset,
			unsigned long* pIbIndex,
			unsigned long curTime,
			bool isEnablePitchBend = false
		);
	
	void _MakeMaterial(D3DMATERIAL9* pMaterial);
	
	int _TransformNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateStatusOfNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateVertexOfNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	
	void _ClearOldestNoteStatus(unsigned long* pCleardIndex);
	
};


