//******************************************************************************
//
// MIDITrail / MTNoteBoxLive
//
// Cuj^pm[g{bNX`NX
//
// Copyright (C) 2012-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// Cuj^pm[g{bNX`悷B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "DXPrimitive.h"
#include "MTNoteDesign.h"
#include "MTNotePitchBend.h"


//******************************************************************************
// p[^`
//******************************************************************************
//ő唭m[g`搔
#define MTNOTEBOX_MAX_LIVENOTE_NUM  (2048)

// TODO: őm[g`搔ςɂ

//******************************************************************************
// Cuj^pm[g{bNX`NX
//******************************************************************************
class MTNoteBoxLive
{
public:
	
	//RXgN^^fXgN^
	MTNoteBoxLive(void);
	virtual ~MTNoteBoxLive(void);
	
	//
	int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			MTNotePitchBend* pNotePitchBend
		);
	
	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);
	
	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//
	void Release();
	
	//Zbg
	void Reset();
	
	//m[gONo^
	void SetNoteOn(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo,
			unsigned char velocity
		);
	
	//m[gOFFo^
	void SetNoteOff(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo
		);
	
	//Sm[gOFF
	void AllNoteOff();
	void AllNoteOffOnCh(unsigned char portNo, unsigned char chNo);
	
protected:
	
	//m[g\
	struct NoteStatus {
		bool isActive;
		unsigned char portNo;
		unsigned char chNo;
		unsigned char noteNo;
		unsigned long startTime;
		unsigned long endTime;
	};
	
	//_obt@\
	struct MTNOTEBOX_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
	};
	
protected:
	
	//m[gfUC
	MTNoteDesign* m_pNoteDesign;
	
	//m[g{bNX
	DXPrimitive m_PrimitiveNotes;
	unsigned long m_NoteNum;
	NoteStatus* m_pNoteStatus;
	
	//sb`xh
	MTNotePitchBend* m_pNotePitchBend;
	
	//Cuj^\ԁi~bj
	unsigned long m_LiveMonitorDisplayDuration;
	
	//_obt@FVFtH[}bg
	unsigned long _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }
	
	virtual int _CreateNoteDesign();
	int _CreateNoteBox(LPDIRECT3DDEVICE9 pD3DDevice);
	int _CreateNoteStatus();
	
	int _CreateVertexOfNote(
			NoteStatus noteStatus,
			MTNOTEBOX_VERTEX* pVertex,
			unsigned long vertexOffset,
			unsigned long* pIbIndex,
			unsigned long curTime,
			bool isEnablePitchBend = false
		);
	unsigned long _GetVertexIndexOfNote(unsigned long index);
	
	void _MakeMaterial(D3DMATERIAL9* pMaterial);
	
	int _TransformNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateStatusOfNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateVertexOfNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	
	void _ClearOldestNoteStatus(unsigned long* pCleardIndex);
	
};


