//******************************************************************************
//
// Simple MIDI Library / SMPortList
//
// |[gXgNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMPortList.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMPortList::SMPortList(void)
 : m_List(sizeof(unsigned char), 10)
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMPortList::~SMPortList(void)
{
	Clear();
}

//******************************************************************************
// NA
//******************************************************************************
void SMPortList::Clear(void)
{
	m_List.Clear();
}

//******************************************************************************
// |[gǉ
//******************************************************************************
int SMPortList::AddPort(
		unsigned char portNo
	)
{
	return m_List.AddItem(&portNo);
}

//******************************************************************************
// |[g擾
//******************************************************************************
int SMPortList::GetPort(
		unsigned long index,
		unsigned char* pPortNo
	)
{
	return m_List.GetItem(index, pPortNo);
}

//******************************************************************************
// |[g擾
//******************************************************************************
unsigned long SMPortList::GetSize()
{
	return m_List.GetSize();
}

//******************************************************************************
// XgRs[
//******************************************************************************
int SMPortList::CopyFrom(
		SMPortList* pSrcList
	)
{
	return m_List.CopyFrom(&(pSrcList->m_List));
}

} // end of namespace

