//******************************************************************************
//
// Simple MIDI Library / SMNoteList
//
// m[gXgNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "SMSimpleList.h"

namespace SMIDILib {


//******************************************************************************
// m[g\
//******************************************************************************
//m[g
typedef struct {
	unsigned char portNo;
	unsigned char chNo;
	unsigned char noteNo;
	unsigned char velocity;
	unsigned long startTime;
	unsigned long endTime;
} SMNote;

//******************************************************************************
// m[gXgNX
//******************************************************************************
class SMIDILIB_API SMNoteList
{
public:

	//RXgN^^fXgN^
	SMNoteList(void);
	virtual ~SMNoteList(void);

	//NA
	void Clear();

	//m[gǉ
	int AddNote(SMNote note);

	//m[g擾
	int GetNote(unsigned long index, SMNote* pNote);

	//m[go^i㏑j
	int SetNote(unsigned long index, SMNote* pNote);

	//m[g擾
	unsigned long GetSize();

	//Rs[
	int CopyFrom(SMNoteList* pSrcList);

private:

	SMSimpleList m_List;

	//ƃRs[RXgN^̋֎~
	void operator=(const SMNoteList&);
	SMNoteList(const SMNoteList&);

};

} // end of namespace

