/**
 * jQuery WS Ring Select Plugin v1.0
 *
 * The MIT License
 *
 * Copyright (c) 2012 ykojima
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function() {
	var PREFIX = 'ws-ring-select';
	var WRAPPER = PREFIX + '-wrapper';
	var LIST = PREFIX + '-list';
	var ITEM = PREFIX + '-item';
	var ACTIVE = PREFIX + '-active';
	var SELECTED = PREFIX + '-selected';
	var SELECTED_TEXT = SELECTED + '-text';
	var SELECTED_ARROW = SELECTED + '-arrow';
	var SELECTED_ARROW_ACTIVE = SELECTED_ARROW + '-active';

	jQuery.fn.wsRingSelect = function(config) {
		config = jQuery.extend({

		}, config);
		$(this).each(function() {
			var src = $(this);
			var wrapper = $('<div></div>');
			var selected = $('<div></div>');
			var list = $('<ul></ul>');
			var f = {
					show: function(e) {
						e.stopPropagation();
						setTimeout(function() {
							$(document).click(function() {
								f.hide(e);
								return false;
							});
						}, 0);
						list.slideDown();
						selected.unbind('click').click(function(e) {
							f.hide(e);
						});
					},
					hide: function(e) {
						e.stopPropagation();
						$(document).unbind('click');
						list.slideUp();
						selected.unbind('click').click(function(e) {
							f.show(e);
						});
					},
					select: function(e, option) {
						e.stopPropagation();
						f.hide(e);
						selected.children('.' + SELECTED_TEXT).text(option.text());
						src.val(option.attr('value'));
					}
				};
			src.change(function(e) {
				f.select(e, $(this).children(':selected'));
			});
			wrapper.addClass(WRAPPER);
			selected.addClass(SELECTED)
				.click(function(e) {
					f.show(e);
				}).mouseover(function() {
					$(this).addClass(ACTIVE);
					$(this).children('.' + SELECTED_ARROW).addClass(SELECTED_ARROW_ACTIVE);
				}).mouseout(function() {
					$(this).removeClass(ACTIVE);
					$(this).children('.' + SELECTED_ARROW).removeClass(SELECTED_ARROW_ACTIVE);
				})
				.append($('<div></div>').addClass(SELECTED_TEXT)
						.text($(this).children(':selected').text()))
				.append($('<div></div>').addClass(SELECTED_ARROW));
			list.addClass(LIST)
				.hide();
			$(this).children('option').each(function() {
				var item = $('<li></li>')
					.addClass(ITEM)
					.attr('value', $(this).val())
					.text($(this).text())
					.click(function(e) {
						f.select(e, $(this));
					}).mouseover(function() {
						$(this).addClass(ACTIVE);
					}).mouseout(function() {
						$(this).removeClass(ACTIVE);
					});
				list.append(item);
			});
			wrapper.append(selected);
			wrapper.append(list);
			$(this)/*.hide()*/.after(wrapper);
		});
	};
})(jQuery);
