package net.waltzstudio.base.generator.service;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.waltzstudio.base.generator.model.java.EntityModel;
import net.waltzstudio.base.generator.util.TemplateUtil;

public class GenerateJavaService {

	public void main(Map<String, Object> databaseDefinitionMap) {
		List<EntityModel> entityModels = getEntityModel(databaseDefinitionMap);
		for (EntityModel entityModel : entityModels) {
			Map<String, Object> rootMap = new HashMap<String, Object>();
			rootMap.put("entity", entityModel);
			Writer out = new OutputStreamWriter(System.out);
			TemplateUtil.process("/net/waltzstudio/base/generator/template", "java/DaoBase.ftl", rootMap, out);
		}
	}

	private List<EntityModel> getEntityModel(Map<String, Object> databaseDefinitionMap) {
		List<EntityModel> entityModels = new ArrayList<EntityModel>();
		entityModels.add(new EntityModel().setPackageName("hoge"));
		return entityModels;
	}

}
