package net.waltzstudio.montecarlo.dao.ticketInbox;

import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.List;
import net.waltzstudio.base.framework.dao.AuditDao;
import net.waltzstudio.base.framework.types.DeleteFlg;
import net.waltzstudio.montecarlo.entity.ticketInbox.TicketInbox;
import net.waltzstudio.montecarlo.entity.ticketInbox.TicketInboxName;

/**
 * チケットトレイDaoBase
 */
public abstract class TicketInboxDaoBase extends AuditDao<TicketInbox> implements TicketInboxName {

	public TicketInbox findById(Long id) {
		return select().id(id).where(eq($DELETE_FLG, DeleteFlg.NORMAL)).getSingleResult();
	}

	public List<TicketInbox> findAllOrderById() {
		return select().where(eq($DELETE_FLG, DeleteFlg.NORMAL)).orderBy(asc($ID)).getResultList();
	}

}
