/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.EntityMapper;
import org.seasar.extension.jdbc.IterationCallback;
import org.seasar.extension.jdbc.IterationContext;
import org.seasar.extension.jdbc.MappingContext;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.handler.AbstractBeanAutoResultSetHandler;

public class BeanIterationAutoResultSetHandler
extends AbstractBeanAutoResultSetHandler {
    protected int limit;
    protected IterationCallback callback;

    public BeanIterationAutoResultSetHandler(ValueType[] valueTypes, EntityMapper entityMapper, String sql, int limit, IterationCallback callback) {
        super(valueTypes, entityMapper, sql);
        this.limit = limit;
        this.callback = callback;
    }

    public Object handle(ResultSet rs) throws SQLException {
        MappingContext mappingContext = new MappingContext();
        IterationContext iterationContext = new IterationContext();
        Object entity = null;
        Object previousKey = null;
        Object result = null;
        for (int i = 0; (this.limit <= 0 || i < this.limit) && rs.next(); ++i) {
            Object[] values = this.getValues(rs);
            Object key = this.entityMapper.getKey(values);
            if (key != null && key.equals(previousKey)) {
                this.entityMapper.map(values, mappingContext);
                continue;
            }
            if (entity != null) {
                result = this.callback.iterate(entity, iterationContext);
                if (iterationContext.isExit()) {
                    return result;
                }
                mappingContext.clear();
            }
            entity = this.entityMapper.map(values, mappingContext);
            previousKey = key;
        }
        if (entity != null) {
            result = this.callback.iterate(entity, iterationContext);
        }
        return result;
    }
}

