/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.SelectForUpdateType;
import org.seasar.extension.jdbc.dialect.StandardDialect;
import org.seasar.framework.util.tiger.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db2Dialect
extends StandardDialect {
    protected static final String uniqueConstraintViolationCode = "23505";

    @Override
    public String getName() {
        return "db2";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getRowNumberFunctionName() {
        return "rownumber()";
    }

    @Override
    public String convertLimitSql(String sql, int offset, int limit) {
        if (offset > 0) {
            return this.convertLimitSqlByRowNumber(sql, offset, limit);
        }
        return this.convertLimitOnlySql(sql, limit);
    }

    protected String convertLimitOnlySql(String sql, int limit) {
        StringBuilder buf = new StringBuilder(sql.length() + 30);
        buf.append(sql);
        buf.append(" fetch first ");
        buf.append(limit);
        buf.append(" rows only");
        return buf.toString();
    }

    @Override
    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "values nextval for " + sequenceName;
    }

    @Override
    public String getForUpdateString(SelectForUpdateType type, int waitSeconds, Pair<String, String> ... aliases) {
        return " for update with rs";
    }

    @Override
    public boolean supportsInnerJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean isUniqueConstraintViolation(Throwable t) {
        String state = this.getSQLState(t);
        return uniqueConstraintViolationCode.equals(state);
    }
}

