/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.tx.adapter;

import com.ibm.wsspi.uow.UOWAction;
import com.ibm.wsspi.uow.UOWActionException;
import com.ibm.wsspi.uow.UOWException;
import com.ibm.wsspi.uow.UOWManager;
import javax.transaction.TransactionRolledbackException;
import org.seasar.extension.tx.TransactionCallback;
import org.seasar.extension.tx.TransactionManagerAdapter;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.log.Logger;

public class WAS6TransactionManagerAdapter
implements TransactionManagerAdapter {
    protected static final int GLOBAL_TX = 1;
    protected static final int LOCAL_TX = 0;
    protected static final boolean JOIN_TX = true;
    protected static final boolean NEW_TX = false;
    private static final Logger logger = Logger.getLogger((Class)WAS6TransactionManagerAdapter.class);
    protected final UOWManager uowManager;

    public WAS6TransactionManagerAdapter(UOWManager uowManager) {
        this.uowManager = uowManager;
    }

    public Object required(TransactionCallback callback) throws Throwable {
        return this.executeCallback(callback, 1, true);
    }

    public Object requiresNew(TransactionCallback callback) throws Throwable {
        return this.executeCallback(callback, 1, false);
    }

    public Object mandatory(TransactionCallback callback) throws Throwable {
        if (!this.hasTransaction()) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        return callback.execute(this);
    }

    public Object notSupported(TransactionCallback callback) throws Throwable {
        return this.executeCallback(callback, 0, false);
    }

    public Object never(TransactionCallback callback) throws Throwable {
        if (this.hasTransaction()) {
            throw new SIllegalStateException("ESSR0317", null);
        }
        return callback.execute(this);
    }

    public void setRollbackOnly() {
        try {
            if (this.uowManager.getUOWStatus() == 0) {
                this.uowManager.setRollbackOnly();
            }
        }
        catch (Exception e) {
            logger.log("ESSR0017", new Object[]{e.getMessage()}, (Throwable)e);
        }
    }

    protected Object executeCallback(TransactionCallback callback, int transactionType, boolean joinTransaction) throws Throwable {
        try {
            UOWActionImpl action = new UOWActionImpl(callback);
            this.uowManager.runUnderUOW(transactionType, joinTransaction, (UOWAction)action);
            return action.getResult();
        }
        catch (UOWActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof WrappedException) {
                throw cause.getCause();
            }
            throw cause;
        }
        catch (UOWException e) {
            TransactionRolledbackException ex = new TransactionRolledbackException(e.getMessage());
            ex.detail = e;
            throw ex;
        }
    }

    protected boolean hasTransaction() {
        return this.uowManager.getUOWStatus() != 5;
    }

    public static class WrappedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public WrappedException(Throwable cause) {
            super(cause);
        }
    }

    public class UOWActionImpl
    implements UOWAction {
        protected TransactionCallback callback;
        protected Object result;

        public UOWActionImpl(TransactionCallback callback) {
            this.callback = callback;
        }

        public void run() throws Exception {
            try {
                this.result = this.callback.execute(WAS6TransactionManagerAdapter.this);
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        }

        public Object getResult() {
            return this.result;
        }
    }
}

