/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;

public class UnaryPlusEval
implements OperationEval {
    private UnaryPlusPtg delegate;

    public UnaryPlusEval(Ptg ptg) {
        this.delegate = (UnaryPlusPtg)ptg;
    }

    public Eval evaluate(Eval[] operands, int srcRow, short srcCol) {
        ValueEval retval = null;
        switch (operands.length) {
            default: {
                retval = ErrorEval.UNKNOWN_ERROR;
                break;
            }
            case 1: {
                if (operands[0] instanceof RefEval) {
                    RefEval re = (RefEval)operands[0];
                    retval = re.getInnerValueEval();
                    break;
                }
                if (operands[0] instanceof AreaEval) {
                    AreaEval ae = (AreaEval)operands[0];
                    if (ae.contains(srcRow, srcCol)) {
                        retval = ErrorEval.CIRCULAR_REF_ERROR;
                        break;
                    }
                    if (ae.isRow()) {
                        if (ae.containsColumn(srcCol)) {
                            ValueEval ve = ae.getValueAt(ae.getFirstRow(), srcCol);
                            if (ve instanceof RefEval) {
                                ve = ((RefEval)ve).getInnerValueEval();
                            }
                            retval = ve;
                            break;
                        }
                        retval = ErrorEval.VALUE_INVALID;
                        break;
                    }
                    if (ae.isColumn()) {
                        if (ae.containsRow(srcRow)) {
                            ValueEval ve = ae.getValueAt(ae.getFirstRow(), srcCol);
                            if (ve instanceof RefEval) {
                                ve = ((RefEval)ve).getInnerValueEval();
                            }
                            retval = ve;
                            break;
                        }
                        retval = ErrorEval.VALUE_INVALID;
                        break;
                    }
                    retval = ErrorEval.VALUE_INVALID;
                    break;
                }
                retval = (ValueEval)operands[0];
            }
        }
        if (retval instanceof BlankEval) {
            retval = new NumberEval(0.0);
        }
        return retval;
    }

    public int getNumberOfOperands() {
        return this.delegate.getNumberOfOperands();
    }

    public int getType() {
        return this.delegate.getType();
    }
}

