/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.contrib.view;

import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.util.HSSFColor;

public class SVTableUtils {
    private static final Hashtable colors = HSSFColor.getIndexHash();
    public static final Color black = SVTableUtils.getAWTColor(new HSSFColor.BLACK());
    public static final Color white = SVTableUtils.getAWTColor(new HSSFColor.WHITE());
    public static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public static Font makeFont(HSSFFont font) {
        int fontheight;
        boolean isbold = font.getBoldweight() > 400;
        boolean isitalics = font.getItalic();
        int fontstyle = 0;
        if (isbold) {
            fontstyle = 1;
        }
        if (isitalics) {
            fontstyle |= 2;
        }
        if ((fontheight = font.getFontHeightInPoints()) == 9) {
            fontheight = 10;
        }
        return new Font(font.getFontName(), fontstyle, fontheight);
    }

    public static final Color getAWTColor(int index, Color deflt) {
        HSSFColor clr = (HSSFColor)colors.get(new Integer(index));
        if (clr == null) {
            return deflt;
        }
        return SVTableUtils.getAWTColor(clr);
    }

    public static final Color getAWTColor(HSSFColor clr) {
        short[] rgb = clr.getTriplet();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }
}

