/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFileSupport {
    public List<String> createSqlFilePathList(File classpathDir, Set<File> sqlFileSet) {
        ArrayList<String> sqlFilePathList = new ArrayList<String>();
        Set<String> dbmsNameSet = this.getDbmsNameSet();
        String basePath = FileUtil.getCanonicalPath(classpathDir) + File.separator;
        for (File sqlFile : sqlFileSet) {
            String resourcePath;
            String path = FileUtil.getCanonicalPath(sqlFile);
            if (!path.startsWith(basePath)) continue;
            if ((path = path.substring(basePath.length())).endsWith(".sql")) {
                path = path.substring(0, path.length() - 4);
            }
            for (String dbmsName : dbmsNameSet) {
                if (!path.endsWith("_" + dbmsName)) continue;
                path = path.substring(0, path.length() - dbmsName.length() - 1);
                break;
            }
            if (sqlFilePathList.contains(resourcePath = path.replace(File.separator, "/") + ".sql")) continue;
            sqlFilePathList.add(resourcePath);
        }
        Collections.sort(sqlFilePathList);
        return sqlFilePathList;
    }

    protected Set<String> getDbmsNameSet() {
        DbmsDialect[] dialects;
        if (!SingletonS2ContainerFactory.hasContainer()) {
            return Collections.emptySet();
        }
        HashSet<String> dbmsNameSet = new HashSet<String>();
        S2Container container = SingletonS2ContainerFactory.getContainer();
        for (DbmsDialect dialect : dialects = (DbmsDialect[])container.findAllComponents(DbmsDialect.class)) {
            String name = dialect.getName();
            if (name == null) continue;
            dbmsNameSet.add(name);
        }
        return dbmsNameSet;
    }
}

