/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import javax.annotation.Generated;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.internal.model.ClassModelSupport;
import org.seasar.extension.jdbc.gen.internal.model.GeneratedModelSupport;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.ConditionAssociationModel;
import org.seasar.extension.jdbc.gen.model.ConditionAssociationModelFactory;
import org.seasar.extension.jdbc.gen.model.ConditionAttributeModel;
import org.seasar.extension.jdbc.gen.model.ConditionAttributeModelFactory;
import org.seasar.extension.jdbc.gen.model.ConditionModel;
import org.seasar.extension.jdbc.gen.model.ConditionModelFactory;
import org.seasar.extension.jdbc.where.ComplexWhere;
import org.seasar.extension.jdbc.where.condition.AbstractEntityCondition;

public class ConditionModelFactoryImpl
implements ConditionModelFactory {
    protected ConditionAttributeModelFactory conditionAttributeModelFactory;
    protected ConditionAssociationModelFactory conditionAssociationModelFactory;
    protected String packageName;
    protected String conditionClassNameSuffix;
    protected ClassModelSupport classModelSupport = new ClassModelSupport();
    protected GeneratedModelSupport generatedModelSupport = new GeneratedModelSupport();

    public ConditionModelFactoryImpl(ConditionAttributeModelFactory conditionAttributeModelFactory, ConditionAssociationModelFactory conditionAssociationModelFactory, String packageName, String conditionClassNameSuffix) {
        if (conditionAttributeModelFactory == null) {
            throw new NullPointerException("conditionAttributeModelFactory");
        }
        if (conditionAssociationModelFactory == null) {
            throw new NullPointerException("conditionAssociationModelFactory");
        }
        if (conditionClassNameSuffix == null) {
            throw new NullPointerException("conditionClassNameSuffix");
        }
        this.conditionAttributeModelFactory = conditionAttributeModelFactory;
        this.conditionAssociationModelFactory = conditionAssociationModelFactory;
        this.packageName = packageName;
        this.conditionClassNameSuffix = conditionClassNameSuffix;
    }

    public ConditionModel getConditionModel(EntityMeta entityMeta) {
        ConditionModel conditionModel = new ConditionModel();
        conditionModel.setPackageName(this.packageName);
        conditionModel.setShortClassName(entityMeta.getName() + this.conditionClassNameSuffix);
        conditionModel.setShortEntityClassName(entityMeta.getEntityClass().getSimpleName());
        for (int i = 0; i < entityMeta.getPropertyMetaSize(); ++i) {
            PropertyMeta propertyMeta = entityMeta.getPropertyMeta(i);
            if (propertyMeta.isTransient()) continue;
            if (propertyMeta.isRelationship()) {
                this.doConditionMethodModel(conditionModel, propertyMeta);
                continue;
            }
            this.doConditionAttributeModel(conditionModel, propertyMeta);
        }
        this.doImportName(conditionModel, entityMeta);
        this.doGeneratedInfo(conditionModel, entityMeta);
        return conditionModel;
    }

    protected void doConditionAttributeModel(ConditionModel conditionModel, PropertyMeta propertyMeta) {
        ConditionAttributeModel attributeModel = this.conditionAttributeModelFactory.getConditionAttributeModel(propertyMeta);
        conditionModel.addConditionAttributeModel(attributeModel);
    }

    protected void doConditionMethodModel(ConditionModel conditionModel, PropertyMeta propertyMeta) {
        ConditionAssociationModel methodModel = this.conditionAssociationModelFactory.getConditionAssociationModel(propertyMeta);
        conditionModel.addConditionAssociationModel(methodModel);
    }

    protected void doImportName(ConditionModel conditionModel, EntityMeta entityMeta) {
        this.classModelSupport.addImportName((ClassModel)conditionModel, Generated.class);
        this.classModelSupport.addImportName((ClassModel)conditionModel, ComplexWhere.class);
        this.classModelSupport.addImportName((ClassModel)conditionModel, AbstractEntityCondition.class);
        for (ConditionAttributeModel attributeModel : conditionModel.getConditionAttributeModelList()) {
            this.classModelSupport.addImportName((ClassModel)conditionModel, attributeModel.getAttributeClass());
            this.classModelSupport.addImportName((ClassModel)conditionModel, attributeModel.getConditionClass());
        }
    }

    protected void doGeneratedInfo(ConditionModel conditionModel, EntityMeta entityMeta) {
        this.generatedModelSupport.fillGeneratedInfo(this, conditionModel);
    }
}

