/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.meta;

import com.sun.tools.javadoc.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.EntityMetaFactory;
import org.seasar.extension.jdbc.gen.internal.exception.DocletUnavailableRuntimeException;
import org.seasar.extension.jdbc.gen.internal.exception.EntityClassNotFoundRuntimeException;
import org.seasar.extension.jdbc.gen.internal.meta.CommentDoclet;
import org.seasar.extension.jdbc.gen.internal.meta.CommentDocletContext;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.extension.jdbc.gen.meta.EntityMetaReader;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMetaReaderImpl
implements EntityMetaReader {
    protected static Logger logger = Logger.getLogger(EntityMetaReaderImpl.class);
    protected static boolean docletAvailable;
    protected File classpathDir;
    protected String packageName;
    protected EntityMetaFactory entityMetaFactory;
    protected Pattern shortClassNamePattern;
    protected Pattern ignoreShortClassNamePattern;
    protected boolean readComment;
    protected List<File> javaFileSrcDirList = new ArrayList<File>();
    protected String javaFileEncoding;

    public EntityMetaReaderImpl(File classpathDir, String packageName, EntityMetaFactory entityMetaFactory, String shortClassNamePattern, String ignoreShortClassNamePattern, boolean readComment, List<File> javaFileSrcDirList, String javaFileEncoding) {
        if (classpathDir == null) {
            throw new NullPointerException("classpathDir");
        }
        if (entityMetaFactory == null) {
            throw new NullPointerException("entityMetaFactory");
        }
        if (shortClassNamePattern == null) {
            throw new NullPointerException("shortClassNamePattern");
        }
        if (ignoreShortClassNamePattern == null) {
            throw new NullPointerException("ignoreShortClassNamePattern");
        }
        if (readComment) {
            if (javaFileSrcDirList == null) {
                throw new NullPointerException("javaFileSrcDirList");
            }
            if (javaFileSrcDirList.isEmpty()) {
                throw new IllegalArgumentException("javaFileSrcDirList");
            }
            if (javaFileEncoding == null) {
                throw new NullPointerException("javaFileEncoding");
            }
        }
        this.classpathDir = classpathDir;
        this.packageName = packageName;
        this.entityMetaFactory = entityMetaFactory;
        this.shortClassNamePattern = Pattern.compile(shortClassNamePattern);
        this.ignoreShortClassNamePattern = Pattern.compile(ignoreShortClassNamePattern);
        this.readComment = readComment;
        if (javaFileSrcDirList != null) {
            this.javaFileSrcDirList.addAll(javaFileSrcDirList);
        }
        this.javaFileEncoding = javaFileEncoding;
    }

    @Override
    public List<EntityMeta> read() {
        final ArrayList<EntityMeta> entityMetaList = new ArrayList<EntityMeta>();
        ClassTraversal.forEach((File)this.classpathDir, (ClassTraversal.ClassHandler)new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                String className;
                Class clazz;
                if (EntityMetaReaderImpl.this.isTargetPackage(packageName) && EntityMetaReaderImpl.this.isTargetClass(shortClassName) && (clazz = ClassUtil.forName((String)(className = ClassUtil.concatName((String)packageName, (String)shortClassName)))).isAnnotationPresent(Entity.class)) {
                    EntityMeta entityMeta = EntityMetaReaderImpl.this.entityMetaFactory.getEntityMeta(clazz);
                    entityMetaList.add(entityMeta);
                }
            }
        });
        if (entityMetaList.isEmpty()) {
            throw new EntityClassNotFoundRuntimeException(this.classpathDir, this.packageName, this.shortClassNamePattern.pattern(), this.ignoreShortClassNamePattern.pattern());
        }
        if (this.readComment) {
            this.readComment(entityMetaList);
        }
        return entityMetaList;
    }

    protected boolean isTargetPackage(String packageName) {
        if (packageName == null) {
            return true;
        }
        if (packageName.equals(this.packageName)) {
            return true;
        }
        return packageName.startsWith(this.packageName + ".");
    }

    protected boolean isTargetClass(String shortClassName) {
        if (!this.shortClassNamePattern.matcher(shortClassName).matches()) {
            return false;
        }
        return !this.ignoreShortClassNamePattern.matcher(shortClassName).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readComment(List<EntityMeta> entityMetaList) {
        if (!docletAvailable) {
            throw new DocletUnavailableRuntimeException();
        }
        String[] args = this.createDocletArgs();
        StringBuilder buf = new StringBuilder();
        for (String arg : args) {
            buf.append(arg).append(" ");
        }
        logger.log("DS2JDBCGen0019", new Object[]{buf.toString()});
        CommentDocletContext.setEntityMetaList(entityMetaList);
        try {
            Main.execute((String[])args);
        }
        finally {
            CommentDocletContext.setEntityMetaList(null);
        }
    }

    protected String[] createDocletArgs() {
        StringBuilder srcDirListBuf = new StringBuilder();
        for (File dir : this.javaFileSrcDirList) {
            srcDirListBuf.append(FileUtil.getCanonicalPath(dir));
            srcDirListBuf.append(File.pathSeparator);
        }
        srcDirListBuf.setLength(srcDirListBuf.length() - File.pathSeparator.length());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-doclet");
        args.add(CommentDoclet.class.getName());
        args.add("-sourcepath");
        args.add(srcDirListBuf.toString());
        args.add("-encoding");
        args.add(this.javaFileEncoding);
        args.add("-subpackages");
        args.add(this.packageName);
        if (logger.isDebugEnabled()) {
            args.add("-verbose");
        }
        return args.toArray(new String[args.size()]);
    }

    @Override
    public boolean isFiltered() {
        return !this.shortClassNamePattern.pattern().equals(".*") || !this.ignoreShortClassNamePattern.pattern().equals("");
    }

    static {
        try {
            Class.forName("com.sun.javadoc.Doclet");
            docletAvailable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

