/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.io.File;
import javax.transaction.UserTransaction;
import org.seasar.extension.jdbc.gen.data.Dumper;
import org.seasar.extension.jdbc.gen.desc.DatabaseDesc;
import org.seasar.extension.jdbc.gen.desc.DatabaseDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.command.AbstractCommand;
import org.seasar.extension.jdbc.gen.internal.exception.RequiredPropertyNullRuntimeException;
import org.seasar.extension.jdbc.gen.meta.EntityMetaReader;
import org.seasar.extension.jdbc.gen.provider.ValueTypeProvider;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.extension.jdbc.gen.sql.SqlUnitExecutor;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectoryTree;
import org.seasar.extension.jdbc.gen.version.ManagedFile;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;

public class DumpDataCommand
extends AbstractCommand {
    protected static Logger logger = Logger.getLogger(DumpDataCommand.class);
    protected File classpathDir = null;
    protected String rootPackageName = "";
    protected String entityPackageName = "entity";
    protected String entityClassNamePattern = ".*";
    protected String ignoreEntityClassNamePattern = "";
    protected File dumpDir = null;
    protected String dumpDirName = "040-dump";
    protected String dumpFileEncoding = "UTF-8";
    protected File migrateDir = new File("db", "migrate");
    protected File ddlInfoFile = new File("db", "ddl-info.txt");
    protected String versionNoPattern = "0000";
    protected boolean applyEnvToVersion;
    protected String genDialectClassName = null;
    protected boolean transactional = false;
    protected UserTransaction userTransaction;
    protected GenDialect dialect;
    protected ValueTypeProvider valueTypeProvider;
    protected EntityMetaReader entityMetaReader;
    protected DatabaseDescFactory databaseDescFactory;
    protected SqlUnitExecutor sqlUnitExecutor;
    protected Dumper dumper;
    protected DdlVersionDirectoryTree ddlVersionDirectoryTree;

    public File getClasspathDir() {
        return this.classpathDir;
    }

    public void setClasspathDir(File classpathDir) {
        this.classpathDir = classpathDir;
    }

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public void setEntityPackageName(String entityPackageName) {
        this.entityPackageName = entityPackageName;
    }

    public String getEntityClassNamePattern() {
        return this.entityClassNamePattern;
    }

    public void setEntityClassNamePattern(String entityClassNamePattern) {
        this.entityClassNamePattern = entityClassNamePattern;
    }

    public String getIgnoreEntityClassNamePattern() {
        return this.ignoreEntityClassNamePattern;
    }

    public void setIgnoreEntityClassNamePattern(String ignoreEntityClassNamePattern) {
        this.ignoreEntityClassNamePattern = ignoreEntityClassNamePattern;
    }

    public String getRootPackageName() {
        return this.rootPackageName;
    }

    public void setRootPackageName(String rootPackageName) {
        this.rootPackageName = rootPackageName;
    }

    public File getDumpDir() {
        return this.dumpDir;
    }

    public void setDumpDir(File dumpDir) {
        this.dumpDir = dumpDir;
    }

    public String getDumpFileEncoding() {
        return this.dumpFileEncoding;
    }

    public void setDumpFileEncoding(String dumpFileEncoding) {
        this.dumpFileEncoding = dumpFileEncoding;
    }

    public String getGenDialectClassName() {
        return this.genDialectClassName;
    }

    public void setGenDialectClassName(String genDialectClassName) {
        this.genDialectClassName = genDialectClassName;
    }

    public File getDdlInfoFile() {
        return this.ddlInfoFile;
    }

    public void setDdlInfoFile(File ddlInfoFile) {
        this.ddlInfoFile = ddlInfoFile;
    }

    public String getVersionNoPattern() {
        return this.versionNoPattern;
    }

    public void setVersionNoPattern(String versionNoPattern) {
        this.versionNoPattern = versionNoPattern;
    }

    public String getDumpDirName() {
        return this.dumpDirName;
    }

    public void setDumpDirName(String dumpDirName) {
        this.dumpDirName = dumpDirName;
    }

    public File getMigrateDir() {
        return this.migrateDir;
    }

    public void setMigrateDir(File migrateDir) {
        this.migrateDir = migrateDir;
    }

    public boolean isApplyEnvToVersion() {
        return this.applyEnvToVersion;
    }

    public void setApplyEnvToVersion(boolean applyEnvToVersion) {
        this.applyEnvToVersion = applyEnvToVersion;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    protected void doValidate() {
        if (this.classpathDir == null) {
            throw new RequiredPropertyNullRuntimeException("classpathDir");
        }
    }

    protected void doInit() {
        this.dialect = this.getGenDialect(this.genDialectClassName);
        if (this.transactional) {
            this.userTransaction = (UserTransaction)SingletonS2Container.getComponent(UserTransaction.class);
        }
        this.valueTypeProvider = this.createValueTypeProvider();
        this.entityMetaReader = this.createEntityMetaReader();
        this.databaseDescFactory = this.createDatabaseDescFactory();
        this.sqlUnitExecutor = this.createSqlUnitExecutor();
        this.dumper = this.createDumper();
        this.ddlVersionDirectoryTree = this.createDdlVersionDirectoryTree();
        this.logRdbmsAndGenDialect(this.dialect);
    }

    protected void doExecute() {
        final DatabaseDesc databaseDesc = this.databaseDescFactory.getDatabaseDesc();
        ManagedFile createDir = this.ddlVersionDirectoryTree.getCurrentVersionDirectory().getCreateDirectory();
        final File dir = this.dumpDir != null ? this.dumpDir : createDir.createChild(this.dumpDirName).asFile();
        this.sqlUnitExecutor.execute(new SqlUnitExecutor.Callback(){

            public void execute(SqlExecutionContext context) {
                DumpDataCommand.this.dumper.dump(context, databaseDesc, dir);
            }
        });
    }

    protected void doDestroy() {
    }

    protected EntityMetaReader createEntityMetaReader() {
        return this.factory.createEntityMetaReader(this, this.classpathDir, ClassUtil.concatName((String)this.rootPackageName, (String)this.entityPackageName), this.jdbcManager.getEntityMetaFactory(), this.entityClassNamePattern, this.ignoreEntityClassNamePattern, false, null, null);
    }

    protected DatabaseDescFactory createDatabaseDescFactory() {
        return this.factory.createDatabaseDescFactory(this, this.jdbcManager.getEntityMetaFactory(), this.entityMetaReader, this.dialect, this.valueTypeProvider, true);
    }

    protected Dumper createDumper() {
        return this.factory.createDumper(this, this.dialect, this.dumpFileEncoding);
    }

    protected DdlVersionDirectoryTree createDdlVersionDirectoryTree() {
        return this.factory.createDdlVersionDirectoryTree(this, this.migrateDir, this.ddlInfoFile, this.versionNoPattern, this.env, this.applyEnvToVersion);
    }

    protected SqlUnitExecutor createSqlUnitExecutor() {
        return this.factory.createSqlUnitExecutor(this, this.jdbcManager.getDataSource(), this.userTransaction, true);
    }

    protected ValueTypeProvider createValueTypeProvider() {
        return this.factory.createValueTypeProvider(this, this.jdbcManager.getDialect());
    }

    protected Logger getLogger() {
        return logger;
    }
}

