/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.Table;

public abstract class Constraint
extends SchemaObjectBase
implements Comparable {
    public static final String CHECK = "CHECK";
    public static final String REFERENTIAL = "REFERENTIAL";
    public static final String UNIQUE = "UNIQUE";
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    protected Table table;

    public abstract String getConstraintType();

    public abstract void checkRow(Session var1, Table var2, Row var3, Row var4) throws SQLException;

    public abstract boolean usesIndex(Index var1);

    public abstract void setIndexOwner(Index var1);

    public abstract boolean containsColumn(Column var1);

    public abstract String getCreateSQLWithoutIndexes();

    public abstract boolean isBefore();

    public abstract String getShortDescription();

    public abstract void checkExistingData(Session var1) throws SQLException;

    public Constraint(Schema schema, int id, String name, Table table) {
        this.initSchemaObjectBase(schema, id, name, "constraint");
        this.table = table;
        this.setTemporary(table.getTemporary());
    }

    public void checkRename() throws SQLException {
    }

    public int getType() {
        return 5;
    }

    public Table getTable() {
        return this.table;
    }

    public Table getRefTable() {
        return this.table;
    }

    public String getDropSQL() {
        return null;
    }

    private int getConstraintTypeOrder() {
        String constraintType = this.getConstraintType();
        if (CHECK.equals(constraintType)) {
            return 0;
        }
        if (PRIMARY_KEY.equals(constraintType)) {
            return 1;
        }
        if (UNIQUE.equals(constraintType)) {
            return 2;
        }
        if (REFERENTIAL.equals(constraintType)) {
            return 3;
        }
        throw Message.getInternalError("type: " + constraintType);
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        Constraint otherConstraint = (Constraint)other;
        int thisType = this.getConstraintTypeOrder();
        int otherType = otherConstraint.getConstraintTypeOrder();
        return thisType - otherType;
    }
}

