package net.waltzstudio.montecarlo.form;

import java.io.Serializable;
import net.arnx.jsonic.JSON;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.container.annotation.tiger.InstanceType;
import org.seasar.struts.annotation.DateType;
import org.seasar.struts.annotation.LongType;
import org.seasar.struts.annotation.Maxlength;
import org.seasar.struts.annotation.Required;

/**
 * チケットForm
 */
@Component(instance = InstanceType.SESSION)
public class TicketForm implements Serializable {
	private static final long serialVersionUID = 1L;

	/** ID */
	public String id;
	/** プロジェクトID */
	@Required
	@Maxlength(maxlength = 255)
	public String projectCode;
	/** パス */
	public String path;
	/** ステータス */
	@Required
	@Maxlength(maxlength = 1)
	public String status;
	/** 開始日 */
	@DateType(datePattern = "yyyy/M/d")
	public String fromDate;
	/** 終了日 */
	@DateType(datePattern = "yyyy/M/d")
	public String toDate;
	/** タイトル */
	@Required
	@Maxlength(maxlength = 255)
	public String title;
	/** 内容 */
	@Maxlength(maxlength = 50000)
	public String description;
	/** 担当者ID */
	@LongType
	public String assignedId;

	/**
	 * Form初期化
	 */
	public void reset() {
		id = null;
		projectCode = null;
		path = null;
		status = null;
		fromDate = null;
		toDate = null;
		title = null;
		description = null;
		assignedId = null;
	}

	@Override
	public String toString() {
		return JSON.encode(this);
	}

}
