package net.waltzstudio.montecarlo.action.ticket;

import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import java.util.List;
import javax.annotation.Resource;
import org.seasar.framework.log.Logger;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.enums.SaveType;
import net.waltzstudio.base.framework.util.BaseUtil;
import net.waltzstudio.montecarlo.dto.RequestInfoDto;
import net.waltzstudio.montecarlo.dto.SessionInfoDto;
import net.waltzstudio.montecarlo.entity.account.Account;
import net.waltzstudio.montecarlo.entity.ticket.Ticket;
import net.waltzstudio.montecarlo.form.TicketForm;
import net.waltzstudio.montecarlo.service.TicketService;
import net.waltzstudio.montecarlo.types.TicketStatus;

public class IndexAction {
	/** logger */
	private Logger logger = Logger.getLogger(IndexAction.class);

	/** リクエスト情報 */
	@Resource
	public RequestInfoDto requestInfoDto;
	/** セッション情報 */
	@Resource
	public SessionInfoDto sessionInfoDto;

	/** チケットステータスリスト */
	public TicketStatus[] ticketStatuses = TicketStatus.values();
	/** アカウントリスト */
	public List<Account> accounts;

	/** チケットリスト */
	public List<Ticket> tickets;
	/** チケット */
	public Ticket ticket;

	/** チケットForm */
	@ActionForm
	@Resource
	protected TicketForm ticketForm;

	/** チケットService */
	@Resource
	protected TicketService ticketService;

	/**
	 * チケット一覧
	 */
	@Execute(validator = false)
	public String index() {
		tickets = ticketService.search();
		return "index.jsp";
	}

	/**
	 * チケット表示
	 */
	@Execute(validator = false, urlPattern = "{id}")
	public String view() {
		ticket = ticketService.getTicket(Long.parseLong(ticketForm.id));
		return "view.jsp";
	}

	/**
	 * チケット登録
	 */
	@Execute(validator = false)
	public String add() {
		accounts = ticketService.getAccounts();
		ticketForm.projectCode = requestInfoDto.projectCode;
		return "add.jsp";
	}

	/**
	 * チケット登録処理
	 */
	@Execute(input = "back", saveErrors = SaveType.SESSION)
	public String register() {
		try {
			Ticket ticket = ticketService.register(ticketForm);
			return S("/", ticketForm.projectCode, "/ticket/", ticket.id, "?redirect=true");
		} catch (Exception e) {
			logger.error(S("チケット登録時にエラーが発生しました。：", ticketForm), e);
			BaseUtil.addError("errors.register");
			return "back";
		}
	}

	/**
	 * 画面戻し
	 */
	@Execute(validator = false)
	public String back() {
		return S("/", ticketForm.projectCode, "/ticket/add", "?redirect=true");
	}

}
