package net.waltzstudio.base.framework.types;

public enum DeleteFlg {

	/**
	 * 論理名：未削除<br />
	 * 物理名：Normal<br />
	 * 値　　：0<br />
	 */
	NORMAL("未削除", "Normal", "0"),

	/**
	 * 論理名：削除済み<br />
	 * 物理名：Deleted<br />
	 * 値　　：1<br />
	 */
	DELETED("削除済み", "Deleted", "1");

	private final String label;
	private final String state;
	private final String value;

	private DeleteFlg(String label, String state, String value) {
		this.label = label;
		this.state = state;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}
	public String getState() {
		return state;
	}
	public String getValue() {
		return value;
	}

	public static String convert(DeleteFlg value) {
		return value.value;
	}
	public static DeleteFlg convert(String value) {
		return create(value);
	}

	public static DeleteFlg create(Object value) {
		if (value == null) {
			return null;
		}
		if (value instanceof DeleteFlg) {
			return (DeleteFlg) value;
		}
		String key = value.toString();
		for (DeleteFlg e : values()) {
			if (e.value.equals(key) || e.state.equals(key)) {
				return e;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return value;
	}

}
