package net.waltzstudio.base.framework.taglib;

import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * ファンクション
 */
public class Functions {
	/** 時間フォーマット */
	private static final String DATE_FORMAT_TIME = "H:mm";
	/** 日付フォーマット */
	private static final String DATE_FORMAT_DAY = "M月d日";
	/** 年フォーマット */
	private static final String DATE_FORMAT_YEAR = "yyyy年";
	/** 完全日付フォーマット */
	private static final String DATE_FORMAT_FULL = "yyyy-MM-dd HH:mm:ss";

	/** 時間フォーマット表示閾値 */
	private static final long TIME_THRESHOLD = 86400000;

	/**
	 * 日付フォーマット
	 *
	 * @param date 日付オブジェクト
	 * @return H:mm or M月d日 or yyyy年
	 */
	public static String d(Date date) {
		if (date == null) {
			return "";
		}

		Calendar now = C();
		Calendar target = C(date);

		long nowTime = now.getTimeInMillis();
		long targetTime = C(date).getTimeInMillis();
		long diff = nowTime - targetTime;
		if (diff < TIME_THRESHOLD && diff > -TIME_THRESHOLD) {
			return new SimpleDateFormat(DATE_FORMAT_TIME).format(date);
		}

		int nowYear = now.get(Calendar.YEAR);
		int targetYear = target.get(Calendar.YEAR);
		if (nowYear != targetYear) {
			return new SimpleDateFormat(DATE_FORMAT_YEAR).format(date);
		}

		return new SimpleDateFormat(DATE_FORMAT_DAY).format(date);
	}

	/**
	 * 日付フォーマット
	 *
	 * @param date 日付オブジェクト
	 * @return yyyy-MM-dd HH:mm:ss
	 */
	public static String dt(Date date) {
		if (date == null) {
			return "";
		}
		return new SimpleDateFormat(DATE_FORMAT_FULL).format(date);
	}

}
