package net.waltzstudio.montecarlo.types;

/**
 * チケットステータス
 */
public enum TicketStatus {

	/**
	 * 論理名：新規<br />
	 * 物理名：Open<br />
	 * 値　　：0<br />
	 */
	OPEN("新規", "Open", "0"),

	/**
	 * 論理名：完了<br />
	 * 物理名：Closed<br />
	 * 値　　：9<br />
	 */
	CLOSED("完了", "Closed", "9");

	private final String label;
	private final String state;
	private final String value;

	private TicketStatus(String label, String state, String value) {
		this.label = label;
		this.state = state;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}
	public String getState() {
		return state;
	}
	public String getValue() {
		return value;
	}

	public static String convert(TicketStatus value) {
		return value.value;
	}
	public static TicketStatus convert(String value) {
		return create(value);
	}

	public static TicketStatus create(Object value) {
		if (value == null) {
			return null;
		}
		if (value instanceof TicketStatus) {
			return (TicketStatus) value;
		}
		String key = value.toString();
		for (TicketStatus e : values()) {
			if (e.value.equals(key) || e.state.equals(key)) {
				return e;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return value;
	}

}
