package net.waltzstudio.montecarlo.dao.ticketLabel;

import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.List;
import net.waltzstudio.base.framework.dao.AuditDao;
import net.waltzstudio.base.framework.types.DeleteFlg;
import net.waltzstudio.montecarlo.entity.ticketLabel.TicketLabel;
import net.waltzstudio.montecarlo.entity.ticketLabel.TicketLabelName;

/**
 * チケット・ラベル紐付けDaoBase
 */
public abstract class TicketLabelDaoBase extends AuditDao<TicketLabel> implements TicketLabelName {

	public TicketLabel findById(Long id) {
		return select().id(id).where(eq($DELETE_FLG, DeleteFlg.NORMAL)).getSingleResult();
	}

	public List<TicketLabel> findAllOrderById() {
		return select().where(eq($DELETE_FLG, DeleteFlg.NORMAL)).orderBy(asc($ID)).getResultList();
	}

}
