/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.seasar.extension.jdbc.types.TimestampType;
import org.seasar.framework.exception.ParseRuntimeException;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public class DateTimestampType
extends TimestampType {
    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.toDate(super.getValue(resultSet, index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.toDate(super.getValue(resultSet, columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toDate(super.getValue(cs, index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toDate(super.getValue(cs, parameterName));
    }

    protected Date toDate(Object value) {
        if (value instanceof Date || value instanceof Calendar) {
            return DateConversionUtil.toDate((Object)value);
        }
        try {
            return DateConversionUtil.toDate((Object)value, (String)TimestampConversionUtil.getPattern((Locale)Locale.getDefault()));
        }
        catch (ParseRuntimeException e) {
            return DateConversionUtil.toDate((Object)value);
        }
    }

    protected Timestamp toTimestamp(Object value) {
        return new Timestamp(this.toDate(value).getTime());
    }
}

