/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.h2.message.Message;

public class MathUtils {
    public static int roundUp(int x, int blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1 & -blockSizePowerOf2;
    }

    public static long roundUpLong(long x, long blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1L & -blockSizePowerOf2;
    }

    public static void checkPowerOf2(int len) {
        if ((len & len - 1) != 0 && len > 0) {
            throw Message.getInternalError("not a power of 2: " + len);
        }
    }

    public static int nextPowerOf2(int x) {
        long i;
        for (i = 1L; i < (long)x && i < 0x3FFFFFFFL; i += i) {
        }
        return (int)i;
    }

    public static long scaleUp50Percent(long start, long min, long blockSize, long maxIncrease) {
        long len;
        if (min > maxIncrease * 2L) {
            len = MathUtils.roundUpLong(min, maxIncrease);
        } else {
            for (len = start; len < min; len += len % blockSize) {
                len += len / 2L;
            }
        }
        return len;
    }

    public static BigDecimal setScale(BigDecimal bd, int scale) throws SQLException {
        if (scale > 100000) {
            throw Message.getInvalidValueException("" + scale, "scale");
        }
        if (scale < 0) {
            throw Message.getInvalidValueException("" + scale, "scale");
        }
        return bd.setScale(scale, 4);
    }

    public static byte decodeByte(String s) {
        return Byte.decode(s);
    }

    public static short decodeShort(String s) {
        return Short.decode(s);
    }

    public static int decodeInt(String s) {
        return Integer.decode(s);
    }

    public static long decodeLong(String s) {
        return Long.decode(s);
    }

    public static int convertLongToInt(long l) {
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }
}

