/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectInputStream;
import org.h2.store.fs.FileObjectZip;
import org.h2.store.fs.FileSystem;

public class FileSystemZip
extends FileSystem {
    private static final FileSystemZip INSTANCE = new FileSystemZip();

    private FileSystemZip() {
    }

    public static FileSystemZip getInstance() {
        return INSTANCE;
    }

    public boolean canWrite(String fileName) {
        return false;
    }

    public void copy(String original, String copy) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void createDirs(String fileName) throws SQLException {
    }

    public boolean createNewFile(String fileName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public String createTempFile(String prefix, String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException {
        throw new IOException("File system is read-only");
    }

    public void delete(String fileName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void deleteRecursive(String fileName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean exists(String fileName) {
        try {
            String entryName = this.getEntryName(fileName);
            if (entryName.length() == 0) {
                return true;
            }
            ZipFile file = this.openZipFile(fileName);
            return file.getEntry(entryName) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean fileStartsWith(String fileName, String prefix) {
        return fileName.startsWith(prefix);
    }

    public String getAbsolutePath(String fileName) {
        return fileName;
    }

    public String getFileName(String name) throws SQLException {
        int idx;
        if ((name = this.getEntryName(name)).endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((idx = name.lastIndexOf(47)) >= 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public long getLastModified(String fileName) {
        return 0L;
    }

    public String getParent(String fileName) {
        int idx = fileName.lastIndexOf(47);
        if (idx > 0) {
            fileName = fileName.substring(0, idx);
        }
        return fileName;
    }

    public boolean isAbsolute(String fileName) {
        return true;
    }

    public boolean isDirectory(String fileName) {
        try {
            String entryName = this.getEntryName(fileName);
            if (entryName.length() == 0) {
                return true;
            }
            ZipFile file = this.openZipFile(fileName);
            Enumeration<? extends ZipEntry> en = file.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String n = entry.getName();
                if (n.equals(entryName)) {
                    return entry.isDirectory();
                }
                if (!n.startsWith(entryName) || n.length() != entryName.length() + 1 || !n.equals(entryName + "/")) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isReadOnly(String fileName) {
        return true;
    }

    public long length(String fileName) {
        try {
            ZipFile file = this.openZipFile(fileName);
            ZipEntry entry = file.getEntry(this.getEntryName(fileName));
            return entry == null ? 0L : entry.getSize();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public String[] listFiles(String path) throws SQLException {
        try {
            if (path.indexOf(33) < 0) {
                path = path + "!";
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            ZipFile file = this.openZipFile(path);
            String dirName = this.getEntryName(path);
            String prefix = path.substring(0, path.length() - dirName.length());
            Enumeration<? extends ZipEntry> en = file.entries();
            ArrayList<String> list = new ArrayList<String>();
            while (en.hasMoreElements()) {
                int idx;
                ZipEntry entry = en.nextElement();
                String name = entry.getName();
                if (!name.startsWith(dirName) || name.length() <= dirName.length() || (idx = name.indexOf(47, dirName.length())) >= 0 && idx < name.length() - 1) continue;
                list.add(prefix + name);
            }
            String[] result = new String[list.size()];
            list.toArray(result);
            return result;
        }
        catch (IOException e) {
            throw Message.convertIOException(e, "listFiles " + path);
        }
    }

    public String normalize(String fileName) throws SQLException {
        return fileName;
    }

    public InputStream openFileInputStream(String fileName) throws IOException {
        FileObject file = this.openFileObject(fileName, "r");
        return new FileObjectInputStream(file);
    }

    public FileObject openFileObject(String fileName, String mode) throws IOException {
        ZipFile file = this.openZipFile(this.translateFileName(fileName));
        ZipEntry entry = file.getEntry(this.getEntryName(fileName));
        if (entry == null) {
            throw new FileNotFoundException(fileName);
        }
        return new FileObjectZip(file, entry);
    }

    public OutputStream openFileOutputStream(String fileName, boolean append) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void rename(String oldName, String newName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean tryDelete(String fileName) {
        return false;
    }

    private String translateFileName(String fileName) {
        int idx;
        if (fileName.startsWith("zip:")) {
            fileName = fileName.substring("zip:".length());
        }
        if ((idx = fileName.indexOf(33)) >= 0) {
            fileName = fileName.substring(0, idx);
        }
        return fileName;
    }

    private String getEntryName(String fileName) {
        int idx = fileName.indexOf(33);
        fileName = idx <= 0 ? "" : fileName.substring(idx + 1);
        if ((fileName = fileName.replace('\\', '/')).startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    private ZipFile openZipFile(String fileName) throws IOException {
        fileName = this.translateFileName(fileName);
        return new ZipFile(fileName);
    }
}

