/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.h2.Driver;
import org.h2.tools.Server;
import org.h2.util.StringUtils;

public class DbStarter
implements ServletContextListener {
    private Connection conn;
    private Server server;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            Driver.load();
            ServletContext servletContext = servletContextEvent.getServletContext();
            String url = this.getParameter(servletContext, "db.url", "jdbc:h2:~/test");
            String user = this.getParameter(servletContext, "db.user", "sa");
            String password = this.getParameter(servletContext, "db.password", "sa");
            this.conn = DriverManager.getConnection(url, user, password);
            servletContext.setAttribute("connection", (Object)this.conn);
            String serverParams = this.getParameter(servletContext, "db.tcpServer", null);
            if (serverParams != null) {
                String[] params = StringUtils.arraySplit(serverParams, ' ', true);
                this.server = Server.createTcpServer(params);
                this.server.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getParameter(ServletContext servletContext, String key, String defaultValue) {
        String value = servletContext.getInitParameter(key);
        return value == null ? defaultValue : value;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        try {
            this.conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

