/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.util.ByteUtils;

public class AlterUser
extends DefineCommand {
    public static final int SET_PASSWORD = 0;
    public static final int RENAME = 1;
    public static final int ADMIN = 2;
    private int type;
    private User user;
    private String newName;
    private Expression password;
    private Expression salt;
    private Expression hash;
    private boolean admin;

    public AlterUser(Session session) {
        super(session);
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setSalt(Expression e) throws SQLException {
        this.salt = e;
    }

    public void setHash(Expression e) throws SQLException {
        this.hash = e;
    }

    public void setPassword(Expression password) {
        this.password = password;
    }

    private char[] getCharArray(Expression e) throws SQLException {
        return e.getValue(this.session).getString().toCharArray();
    }

    private byte[] getByteArray(Expression e) throws SQLException {
        return ByteUtils.convertStringToBytes(e.getValue(this.session).getString());
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        switch (this.type) {
            case 0: {
                if (this.user != this.session.getUser()) {
                    this.session.getUser().checkAdmin();
                }
                if (this.hash != null && this.salt != null) {
                    this.user.setSaltAndHash(this.getByteArray(this.salt), this.getByteArray(this.hash));
                    break;
                }
                String name = this.newName == null ? this.user.getName() : this.newName;
                SHA256 sha = new SHA256();
                char[] passwordChars = this.getCharArray(this.password);
                byte[] userPasswordHash = sha.getKeyPasswordHash(name, passwordChars);
                this.user.setUserPasswordHash(userPasswordHash);
                break;
            }
            case 1: {
                this.session.getUser().checkAdmin();
                if (db.findUser(this.newName) != null || this.newName.equals(this.user.getName())) {
                    throw Message.getSQLException(90033, this.newName);
                }
                db.renameDatabaseObject(this.session, this.user, this.newName);
                break;
            }
            case 2: {
                this.session.getUser().checkAdmin();
                if (!this.admin) {
                    this.user.checkOwnsNoSchemas();
                }
                this.user.setAdmin(this.admin);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        db.update(this.session, this.user);
        return 0;
    }
}

