/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;

public abstract class NumericOperationEval
implements OperationEval {
    protected abstract ValueEvalToNumericXlator getXlator();

    protected ValueEval singleOperandEvaluate(Eval eval, int srcRow, short srcCol) {
        ValueEval retval;
        if (eval instanceof AreaEval) {
            AreaEval ae = (AreaEval)eval;
            if (ae.contains(srcRow, srcCol)) {
                retval = ErrorEval.CIRCULAR_REF_ERROR;
            } else if (ae.isRow()) {
                if (ae.containsColumn(srcCol)) {
                    ValueEval ve = ae.getValueAt(ae.getFirstRow(), srcCol);
                    ve = this.getXlator().attemptXlateToNumeric(ve);
                    retval = this.getXlator().attemptXlateToNumeric(ve);
                } else {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else if (ae.isColumn()) {
                if (ae.containsRow(srcRow)) {
                    ValueEval ve = ae.getValueAt(srcRow, ae.getFirstColumn());
                    retval = this.getXlator().attemptXlateToNumeric(ve);
                } else {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else {
                retval = ErrorEval.VALUE_INVALID;
            }
        } else {
            retval = this.getXlator().attemptXlateToNumeric((ValueEval)eval);
        }
        return retval;
    }
}

