/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.customizer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Msg;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ActionConfig;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.ComponentCustomizer;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ModifierUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.AnnotationUtil;
import org.seasar.struts.action.ActionFormWrapperClass;
import org.seasar.struts.action.S2DynaProperty;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Arg;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.annotation.Validator;
import org.seasar.struts.config.S2ActionMapping;
import org.seasar.struts.config.S2ExecuteConfig;
import org.seasar.struts.config.S2FormBeanConfig;
import org.seasar.struts.config.S2ModuleConfig;
import org.seasar.struts.config.S2ValidationConfig;
import org.seasar.struts.exception.DuplicateExecuteMethodAndPropertyRuntimeException;
import org.seasar.struts.exception.ExecuteMethodNotFoundRuntimeException;
import org.seasar.struts.exception.IllegalExecuteMethodRuntimeException;
import org.seasar.struts.exception.IllegalValidateMethodRuntimeException;
import org.seasar.struts.exception.IllegalValidatorOfExecuteMethodRuntimeException;
import org.seasar.struts.exception.MultipleAllSelectedUrlPatternRuntimeException;
import org.seasar.struts.exception.UnmatchValidatorAndValidateRuntimeException;
import org.seasar.struts.util.ActionUtil;
import org.seasar.struts.util.MessageResourcesUtil;
import org.seasar.struts.util.S2ModuleConfigUtil;
import org.seasar.struts.util.ValidatorResourcesUtil;
import org.seasar.struts.validator.S2ValidatorResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionCustomizer
implements ComponentCustomizer {
    protected static final String VALIDATOR = "@";

    public void customize(ComponentDef componentDef) {
        S2ActionMapping actionMapping = this.createActionMapping(componentDef);
        S2FormBeanConfig formConfig = this.createFormBeanConfig(actionMapping);
        S2ModuleConfig moduleConfig = S2ModuleConfigUtil.getModuleConfig();
        moduleConfig.addActionConfig((ActionConfig)actionMapping);
        moduleConfig.addFormBeanConfig(formConfig);
        S2ValidatorResources validatorResources = ValidatorResourcesUtil.getValidatorResources();
        this.setupValidator(actionMapping, validatorResources);
    }

    protected S2ActionMapping createActionMapping(ComponentDef componentDef) {
        S2ActionMapping actionMapping = this.createActionMapping();
        actionMapping.setPath(ActionUtil.fromActionNameToPath(componentDef.getComponentName()));
        actionMapping.setComponentDef(componentDef);
        actionMapping.setName(componentDef.getComponentName() + "Form");
        Class actionClass = componentDef.getComponentClass();
        this.setupActionForm(actionMapping, actionClass);
        this.setupMethod(actionMapping, actionClass);
        return actionMapping;
    }

    protected S2ActionMapping createActionMapping() {
        return new S2ActionMapping();
    }

    protected void setupMethod(S2ActionMapping actionMapping, Class<?> actionClass) {
        S2ExecuteConfig allSelectedExecuteConfig = null;
        for (Class<?> clazz = actionClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                Execute execute;
                if (!ModifierUtil.isPublic((Method)m) || (execute = m.getAnnotation(Execute.class)) == null || actionMapping.getExecuteConfig(m.getName()) != null) continue;
                if (m.getParameterTypes().length > 0 || m.getReturnType() != String.class) {
                    throw new IllegalExecuteMethodRuntimeException(actionClass, m.getName());
                }
                if (actionMapping.getActionFormBeanDesc().hasPropertyDesc(m.getName())) {
                    throw new DuplicateExecuteMethodAndPropertyRuntimeException(actionClass, m.getName());
                }
                String input = !StringUtil.isEmpty((String)execute.input()) ? execute.input() : null;
                S2ExecuteConfig executeConfig = this.createExecuteConfig();
                executeConfig.setMethod(m);
                executeConfig.setSaveErrors(execute.saveErrors());
                executeConfig.setInput(input);
                ArrayList<S2ValidationConfig> validationConfigs = new ArrayList<S2ValidationConfig>();
                String validate = execute.validate();
                boolean validator = false;
                if (!StringUtil.isEmpty((String)validate)) {
                    BeanDesc actionBeanDesc = actionMapping.getActionBeanDesc();
                    BeanDesc actionFormBeanDesc = actionMapping.getActionFormBeanDesc();
                    for (String name : StringUtil.split((String)validate, (String)", ")) {
                        Method validateMethod;
                        if (VALIDATOR.equals(name)) {
                            if (!execute.validator()) {
                                throw new UnmatchValidatorAndValidateRuntimeException(actionClass, m.getName());
                            }
                            validationConfigs.add(new S2ValidationConfig());
                            validator = true;
                            continue;
                        }
                        if (actionFormBeanDesc.hasMethod(name)) {
                            validateMethod = actionFormBeanDesc.getMethod(name);
                            if (validateMethod.getParameterTypes().length > 0 || !ActionMessages.class.isAssignableFrom(validateMethod.getReturnType())) {
                                throw new IllegalValidateMethodRuntimeException(actionClass, validateMethod.getName());
                            }
                            validationConfigs.add(new S2ValidationConfig(validateMethod));
                            continue;
                        }
                        validateMethod = actionBeanDesc.getMethod(name);
                        if (validateMethod.getParameterTypes().length > 0 || !ActionMessages.class.isAssignableFrom(validateMethod.getReturnType())) {
                            throw new IllegalValidateMethodRuntimeException(actionClass, validateMethod.getName());
                        }
                        validationConfigs.add(new S2ValidationConfig(validateMethod));
                    }
                }
                if (!validator && execute.validator()) {
                    validationConfigs.add(0, new S2ValidationConfig());
                }
                if (!validationConfigs.isEmpty() && input == null) {
                    throw new IllegalValidatorOfExecuteMethodRuntimeException(actionClass, m.getName());
                }
                executeConfig.setValidationConfigs(validationConfigs);
                executeConfig.setUrlPattern(execute.urlPattern());
                String roles = execute.roles().trim();
                if (!StringUtil.isEmpty((String)roles)) {
                    executeConfig.setRoles(StringUtil.split((String)roles, (String)", "));
                }
                executeConfig.setStopOnValidationError(execute.stopOnValidationError());
                executeConfig.setRemoveActionForm(execute.removeActionForm());
                String reset = execute.reset();
                if (!StringUtil.isEmpty((String)reset)) {
                    Method resetMethod = null;
                    resetMethod = "reset".equals(reset) ? actionMapping.getActionFormBeanDesc().getMethodNoException(reset) : actionMapping.getActionFormBeanDesc().getMethod(reset);
                    if (resetMethod != null) {
                        executeConfig.setResetMethod(resetMethod);
                    }
                }
                executeConfig.setRedirect(execute.redirect());
                if (executeConfig.isUrlPatternAllSelected()) {
                    if (allSelectedExecuteConfig != null) {
                        throw new MultipleAllSelectedUrlPatternRuntimeException(allSelectedExecuteConfig.getUrlPattern(), executeConfig.getUrlPattern());
                    }
                    allSelectedExecuteConfig = executeConfig;
                    continue;
                }
                actionMapping.addExecuteConfig(executeConfig);
            }
        }
        if (allSelectedExecuteConfig != null) {
            actionMapping.addExecuteConfig(allSelectedExecuteConfig);
        }
        if (actionMapping.getExecuteConfigSize() == 0) {
            throw new ExecuteMethodNotFoundRuntimeException(actionClass);
        }
    }

    protected S2ExecuteConfig createExecuteConfig() {
        return new S2ExecuteConfig();
    }

    protected void setupActionForm(S2ActionMapping actionMapping, Class<?> actionClass) {
        int size = actionMapping.getActionBeanDesc().getFieldSize();
        BeanDesc beanDesc = actionMapping.getActionBeanDesc();
        for (int i = 0; i < size; ++i) {
            Field f = beanDesc.getField(i);
            if (f.getAnnotation(ActionForm.class) == null) continue;
            actionMapping.setActionFormField(f);
            return;
        }
    }

    protected S2FormBeanConfig createFormBeanConfig(S2ActionMapping actionMapping) {
        S2FormBeanConfig formConfig = this.createFormBeanConfig();
        formConfig.setName(actionMapping.getName());
        ActionFormWrapperClass wrapperClass = this.createActionFormWrapperClass(actionMapping);
        BeanDesc beanDesc = actionMapping.getActionFormBeanDesc();
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.isReadable()) continue;
            S2DynaProperty property = this.createDynaProperty(pd);
            wrapperClass.addDynaProperty(property);
        }
        formConfig.setDynaClass(wrapperClass);
        return formConfig;
    }

    protected S2FormBeanConfig createFormBeanConfig() {
        return new S2FormBeanConfig();
    }

    protected ActionFormWrapperClass createActionFormWrapperClass(S2ActionMapping actionMapping) {
        return new ActionFormWrapperClass(actionMapping);
    }

    protected S2DynaProperty createDynaProperty(PropertyDesc pd) {
        return new S2DynaProperty(pd);
    }

    protected void setupValidator(S2ActionMapping actionMapping, S2ValidatorResources validatorResources) {
        HashMap<String, Form> forms = new HashMap<String, Form>();
        for (String methodName : actionMapping.getExecuteMethodNames()) {
            if (!actionMapping.getExecuteConfig(methodName).isValidator()) continue;
            Form form = new Form();
            form.setName(actionMapping.getName() + "_" + methodName);
            forms.put(methodName, form);
        }
        for (Class clazz = actionMapping.getActionFormBeanDesc().getBeanClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : ClassUtil.getDeclaredFields((Class)clazz)) {
                for (Annotation anno : field.getDeclaredAnnotations()) {
                    this.processAnnotation(field.getName(), anno, validatorResources, forms);
                }
            }
        }
        Iterator i = forms.values().iterator();
        while (i.hasNext()) {
            validatorResources.addForm((Form)i.next());
        }
    }

    protected void processAnnotation(String propertyName, Annotation annotation, S2ValidatorResources validatorResources, Map<String, Form> forms) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Validator metaAnnotation = annotationType.getAnnotation(Validator.class);
        if (metaAnnotation == null) {
            return;
        }
        String validatorName = this.getValidatorName(metaAnnotation);
        Map props = AnnotationUtil.getProperties((Annotation)annotation);
        this.registerValidator(propertyName, validatorName, props, validatorResources, forms);
    }

    protected String getValidatorName(Annotation annotation) {
        Class<? extends Annotation> annoType = annotation.annotationType();
        Method m = ClassUtil.getMethod(annoType, (String)"value", null);
        return (String)MethodUtil.invoke((Method)m, (Object)annotation, null);
    }

    protected void registerValidator(String propertyName, String validatorName, Map<String, Object> props, S2ValidatorResources validatorResources, Map<String, Form> forms) {
        org.apache.commons.validator.Field field = this.createField(propertyName, validatorName, props, validatorResources);
        for (String methodName : forms.keySet()) {
            if (!this.isTarget(methodName, (String)props.get("target"))) continue;
            Form form = forms.get(methodName);
            form.addField(field);
        }
    }

    protected org.apache.commons.validator.Field createField(String propertyName, String validatorName, Map<String, Object> props, S2ValidatorResources validatorResources) {
        Arg[] args;
        org.apache.commons.validator.Field field = new org.apache.commons.validator.Field();
        field.setDepends(validatorName);
        field.setProperty(propertyName);
        org.seasar.struts.annotation.Msg msg = (org.seasar.struts.annotation.Msg)props.remove("msg");
        if (msg != null) {
            Msg m = new Msg();
            m.setName(validatorName);
            m.setKey(msg.key());
            String bundle = msg.bundle();
            if (!StringUtil.isEmpty((String)bundle)) {
                m.setBundle(bundle);
            }
            m.setResource(msg.resource());
            field.addMsg(m);
        }
        if ((args = (Arg[])props.remove("args")) != null && args.length > 0) {
            for (Arg arg : args) {
                org.apache.commons.validator.Arg a = new org.apache.commons.validator.Arg();
                a.setKey(this.resolveKey(arg.key(), arg.resource(), props, validatorResources));
                String bundle = arg.bundle();
                if (!StringUtil.isEmpty((String)bundle)) {
                    a.setBundle(bundle);
                }
                a.setResource(arg.resource());
                a.setPosition(arg.position());
                field.addArg(a);
            }
        }
        for (int i = 0; i < 5; ++i) {
            Arg arg = (Arg)props.remove("arg" + i);
            if (arg != null && !StringUtil.isEmpty((String)arg.key())) {
                org.apache.commons.validator.Arg a = new org.apache.commons.validator.Arg();
                a.setKey(this.resolveKey(arg.key(), arg.resource(), props, validatorResources));
                String bundle = arg.bundle();
                if (!StringUtil.isEmpty((String)bundle)) {
                    a.setBundle(bundle);
                }
                a.setResource(arg.resource());
                a.setPosition(i);
                field.addArg(a);
                continue;
            }
            if (i != 0) continue;
            org.apache.commons.validator.Arg a = new org.apache.commons.validator.Arg();
            String key = "labels." + propertyName;
            String message = MessageResourcesUtil.getMessage(key);
            if (!StringUtil.isEmpty((String)message)) {
                a.setKey(key);
            } else {
                a.setKey(propertyName);
                a.setResource(false);
            }
            a.setPosition(0);
            field.addArg(a);
        }
        for (String name : props.keySet()) {
            if (name.equals("target")) continue;
            Object value = props.get(name);
            String jsType = "string";
            if (value instanceof Number) {
                jsType = "int";
            } else if (name.equals("mask")) {
                jsType = "regexp";
            }
            field.addVar(name, value.toString(), jsType);
        }
        return field;
    }

    protected String resolveKey(String key, boolean resource, Map<String, Object> props, S2ValidatorResources validatorResources) {
        if (resource) {
            return key;
        }
        if (key.startsWith("${") && key.endsWith("}")) {
            String s = key.substring(2, key.length() - 1);
            if (s.startsWith("var:")) {
                s = s.substring(4);
                return String.valueOf(props.get(s));
            }
            return validatorResources.getConstant(s);
        }
        return key;
    }

    protected boolean isTarget(String methodName, String target) {
        String[] names;
        if (StringUtil.isEmpty((String)target)) {
            return true;
        }
        for (String name : names = StringUtil.split((String)target, (String)", ")) {
            if (!methodName.equals(name.trim())) continue;
            return true;
        }
        return false;
    }
}

