/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import java.util.Map;
import javax.persistence.EntityManager;
import org.seasar.framework.jpa.Dialect;
import org.seasar.framework.jpa.DialectManager;
import org.seasar.framework.jpa.exception.DialectNotFoundException;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectManagerImpl
implements DialectManager {
    protected Map<Class<?>, Dialect> dialects = CollectionsUtil.newLinkedHashMap();

    @Override
    public void addDialect(Class<?> delegateClass, Dialect dialect) {
        this.dialects.put(delegateClass, dialect);
    }

    @Override
    public void removeDialect(Class<?> delegateClass) {
        this.dialects.remove(delegateClass);
    }

    @Override
    public Dialect getDialect(EntityManager em) {
        Object delegate = em.getDelegate();
        for (Map.Entry<Class<?>, Dialect> entry : this.dialects.entrySet()) {
            if (!entry.getKey().isInstance(delegate)) continue;
            return entry.getValue();
        }
        throw new DialectNotFoundException(em);
    }
}

